/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.eas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.eas.EasTaskFacadeImpl;
import kd.ssc.task.http.FileUploadService;
import kd.ssc.task.util.AttachmentHelper;
import kd.ssc.task.util.UUIDUtil;

public class EasAttchmentRequestMQCustomer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(EasAttchmentRequestMQCustomer.class);
    private static final int rpTimes = 5;

    public void onMessage(Object arg0, String arg1, boolean arg2, MessageAcker messageAcker) {
        log.info("in mq arg0 : " + arg0);
        EasTaskFacadeImpl taskFacade = new EasTaskFacadeImpl();
        if (arg0 == null) {
            messageAcker.ack(arg1);
            log.error("arg0 \u4e3anull,\u4e0d\u7528\u8bf7\u6c42");
            return;
        }
        HashMap easNextMap = new HashMap(4);
        FileUploadService upload = new FileUploadService();
        for (int i = 0; i < 5; ++i) {
            try {
                Map mqCusMap = (Map)arg0;
                Set<String> fileNames = new HashSet();
                if (mqCusMap.get("fileName") instanceof ArrayList) {
                    ArrayList mqFiles = (ArrayList)mqCusMap.get("fileName");
                    for (String fileName : mqFiles) {
                        fileNames.add(fileName);
                    }
                } else {
                    fileNames = (Set)mqCusMap.get("fileName");
                }
                Map attachIDMap = (Map)mqCusMap.get("attachIDMap");
                String bindbillNumber = mqCusMap.get("bindbillNumber").toString();
                String billID = mqCusMap.get("billID").toString();
                HashMap attchGetMap = new HashMap(2);
                attchGetMap.put("attachmentID", attachIDMap.get("id"));
                attchGetMap.put("taskID", mqCusMap.get("taskID").toString());
                log.info("kd.ssc.task.face.TaskFacade.getAttachment(Map<String, Object>) Param : " + attchGetMap);
                Map attachDataMap = taskFacade.getAttachment(attchGetMap);
                log.info("kd.ssc.task.face.TaskFacade.getAttachment(Map<String, Object>) end ");
                if (attachDataMap == null) {
                    return;
                }
                ArrayList attachments = new ArrayList();
                easNextMap.clear();
                InputStream attachmentStream = (InputStream)attachDataMap.get("data");
                String fileName = (String)attachIDMap.get("name");
                String uuid = UUIDUtil.generateShortUuid();
                String storePath = "/eas/attachment/" + uuid + "/" + fileName;
                log.info("ssc upload attachment");
                log.info("storePath " + storePath);
                log.info("fileName " + fileName);
                String url = upload.upload(storePath, fileName, attachmentStream);
                HashMap<String, Object> atta = new HashMap<String, Object>();
                atta.put("uid", uuid);
                int size = this.getAttchMentSize(attachIDMap);
                atta.put("lastModified", (Long)attachIDMap.get("createtime"));
                atta.put("name", fileName);
                atta.put("size", size);
                atta.put("url", url);
                if (!fileNames.contains(fileName)) {
                    attachments.add(atta);
                    easNextMap.put((String)attachIDMap.get("id"), atta);
                }
                if (attachments.size() > 0) {
                    AttachmentServiceHelper.upload((String)bindbillNumber, (Object)billID, (String)"attachmentpanel", attachments);
                    Map atMap = (Map)easNextMap.get(attachIDMap.get("id"));
                    if (atMap != null) {
                        DynamicObject atth = ORM.create().queryOne("bos_attachment", new QFilter[]{new QFilter("fnumber", "=", atMap.get("uid")), new QFilter("ffileid", "=", atMap.get("url"))});
                        AttachmentHelper.saveId("bos_attachment", atth.getPkValue().toString(), (String)attachIDMap.get("id"));
                    }
                }
                messageAcker.ack(arg1);
                log.info("\u9644\u4ef6\u8bf7\u6c42\u5b8c\u6bd5");
                this.deleteErrorMQ(arg0);
                return;
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
                if (i < 4) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        log.error("\u7ebf\u7a0b\u8bf7\u6c42\u5f02\u5e38", (Throwable)e1);
                    }
                    continue;
                }
                this.saveErrorMQ(arg0, e);
                continue;
            }
        }
        messageAcker.ack(arg1);
        log.info("\u5df2\u8bf7\u6c425\u6b21\uff0c\u8bf7\u6c42\u5b8c\u6bd5");
    }

    private int getAttchMentSize(Map<String, Object> attachIDMap) {
        int size = 0;
        Object sizeObj = attachIDMap.get("size");
        if (sizeObj != null) {
            size = Integer.parseInt(sizeObj.toString());
        }
        return size;
    }

    public void deleteErrorMQ(Object arg0) {
        QFilter mqParamFilter = new QFilter("mqparam_tag", "=", (Object)SerializationUtils.toJsonString((Object)arg0));
        DeleteServiceHelper.delete((String)"task_mq_faile", (QFilter[])new QFilter[]{mqParamFilter});
    }

    public void saveErrorMQ(Object arg0, Exception e) {
        QFilter mqParamFilter = new QFilter("mqparam_tag", "=", (Object)SerializationUtils.toJsonString((Object)arg0));
        if (!QueryServiceHelper.exists((String)"task_mq_faile", (QFilter[])new QFilter[]{mqParamFilter})) {
            DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)"task_mq_faile");
            mqErrDyObj.set("mqregion", (Object)"ssc");
            mqErrDyObj.set("mqqueue", (Object)"kd.ssc.task.eas.ssc_attachment");
            mqErrDyObj.set("mqexceptionmsg", (Object)ExceptionUtil.getExcetionMsg((Throwable)e));
            mqErrDyObj.set("mqexceptionstack_tag", (Object)ExceptionUtil.getStackTrace((Throwable)e));
            mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
            mqErrDyObj.set("mqparam_tag", (Object)SerializationUtils.toJsonString((Object)arg0));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
        }
    }

    private int getAttachmentSize(Map attachDataMap) {
        int size = 0;
        try {
            size = attachDataMap.get("size") == null ? 0 : Integer.parseInt(attachDataMap.get("size").toString());
        }
        catch (Exception e) {
            size = 0;
            log.error("\u8f6c\u6362\u9644\u4ef6\u5927\u5c0f\u62a5\u9519");
        }
        return size;
    }
}

