/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.eas.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.eas.EASUtil;
import kd.ssc.task.eas.bill.EASTaskBillHandler;

public class EASPaymentBillHandler
extends EASTaskBillHandler {
    private static final Log log = LogFactory.getLog(EASPaymentBillHandler.class);

    @Override
    public void process(DynamicObject dataEntity, Set<Long> costcompany) {
        DynamicObject company = dataEntity.getDynamicObject("company");
        if (company != null && company.getLong("id") > 0L) {
            costcompany.add(company.getLong("id"));
        }
    }

    @Override
    public void getOpinion(DynamicObject dataEntity, HashMap<String, Object> opinionMap) {
        DynamicObjectCollection dataCc = dataEntity.getDynamicObjectCollection("entries");
        if (dataCc != null && dataCc.size() > 0) {
            DynamicObject dataDb = (DynamicObject)dataCc.get(0);
            Long expenseTypeId = dataDb.getLong("expensetype_Id");
            opinionMap.put("fieldKey", expenseTypeId);
        }
    }

    public Map<String, Object> pack(DynamicObject billData, boolean isPass) {
        HashMap<String, Object> bizData = new HashMap<String, Object>();
        bizData.put("subject", (String)billData.get("cause"));
        DynamicObjectCollection entries = (DynamicObjectCollection)billData.get("entries");
        ArrayList entryList = new ArrayList();
        BigDecimal amountApprovedTotal = new BigDecimal("0");
        BigDecimal approvedTotalBCTotal = new BigDecimal("0");
        BigDecimal approvedMoneyBC = new BigDecimal("0");
        DynamicObject loccur = (DynamicObject)billData.get("loccur");
        for (DynamicObject d : entries) {
            Object productTypeIdObject;
            HashMap<String, Object> entryData = new HashMap<String, Object>();
            entryData.put("remark", d.get("purpose").toString());
            entryData.put("approvedMoney", d.get("approvedmoney").toString());
            approvedMoneyBC = ((BigDecimal)d.get("approvedmoney")).multiply((BigDecimal)billData.get("rate")).setScale(loccur.getInt("amtprecision"), 4);
            log.info("approvedTotal\u5206\u5f55\u6838\u5b9a\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\uff1a" + approvedMoneyBC);
            entryData.put("approvedMoneyBC", approvedMoneyBC.toString());
            entryData.put("nottaxmoney", d.get("nottaxmoney").toString());
            entryData.put("taxrate", d.get("taxrate").toString());
            entryData.put("taxmoney", d.get("taxmoney").toString());
            if (d.get("expensetype.id") != null) {
                Object numberobj;
                HashMap<String, String> expensetype = new HashMap<String, String>();
                String expensetypeId = d.get("expensetype.easid").toString();
                expensetype.put("id", expensetypeId);
                Object nameobj = d.get("expensetype.name");
                if (nameobj != null) {
                    String expensetypeName = nameobj.toString();
                    expensetype.put("name", expensetypeName);
                }
                if ((numberobj = d.get("expensetype.number")) != null) {
                    String expensetypeNumber = numberobj.toString();
                    expensetype.put("number", expensetypeNumber);
                }
                entryData.put("expenseType", expensetype);
            }
            if ((productTypeIdObject = d.get("producttype.id")) != null) {
                Object numberobj;
                long projectpk = (Long)productTypeIdObject;
                String expensetypeId = EASUtil.getEASDataId("kd_producttype", projectpk);
                Object nameobj = d.get("producttype.name");
                if (nameobj != null) {
                    String string = nameobj.toString();
                }
                if ((numberobj = d.get("producttype.number")) != null) {
                    String string = numberobj.toString();
                }
            }
            amountApprovedTotal = amountApprovedTotal.add(d.getBigDecimal("approvedmoney"));
            approvedTotalBCTotal = approvedTotalBCTotal.add(approvedMoneyBC);
            entryList.add(entryData);
        }
        log.info("approvedTotal \u6838\u5b9a\u603b\u989d\uff1a" + amountApprovedTotal);
        log.info("approvedTotalBC\u6838\u5b9a\u603b\u989d\uff08\u672c\u4f4d\u5e01\uff09\uff1a" + approvedTotalBCTotal);
        bizData.put("approvedTotal", amountApprovedTotal.toString());
        bizData.put("approvedTotalBC", approvedTotalBCTotal.toString());
        bizData.put("settlementEntry", entryList);
        return bizData;
    }

    public void validate(DynamicObject billData, boolean isPass) {
    }
}

