/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.extendplugin.TaskSumAmountBill;
import kd.ssc.task.extendplugin.base.TaskExtendBill;
import kd.ssc.task.util.EasTaskExpenseHelper;

public class TaskEvectionLoanBill
extends TaskExtendBill
implements BeforeF7SelectListener,
ClickListener {
    private static final String CHCHE_TASKEVECTIONLOANBILL_APPLAYID_VALUE = "CHCHE_TASKEVECTIONLOANBILL_APPLAYID_VALUE";

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if ("currency".equals(propertyName)) {
            model.setValue("amountori", (Object)((BigDecimal)model.getValue("amountori", changeData.getRowIndex())), changeData.getRowIndex());
        }
        if ("amountapprovedori".equals(propertyName)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entries");
            DynamicObjectCollection doc = this.getModel().getEntryEntity("entries");
            BigDecimal initialAmountori = (BigDecimal)((DynamicObject)doc.get(entryCurrentRowIndex)).get("amountori");
            BigDecimal newAmountori = (BigDecimal)changeData.getNewValue();
            if (newAmountori.compareTo(initialAmountori) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d\u539f\u5e01\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u539f\u5e01\u3002", (String)"TaskEvectionLoanBill_0", (String)"ssc-task-ext", (Object[])new Object[0]));
                model.setValue("amountapprovedori", (Object)initialAmountori, changeData.getRowIndex());
                this.calculation(initialAmountori, changeData.getRowIndex());
            } else {
                this.calculation(newAmountori, changeData.getRowIndex());
            }
            DynamicObjectCollection collectionentries = this.getModel().getEntryEntity("entries");
            this.setSumAmountValues(collectionentries, "amountapprovedori", "entries");
            this.setSumAmountapprovedValues(collectionentries, "amountapproved", "entries");
        } else if ("currency".equals(propertyName)) {
            DynamicObjectCollection collectionentries = this.getModel().getEntryEntity("entries");
            this.setSumAmountValues(collectionentries, "amountori", "entries");
            this.setSumAmountValues(collectionentries, "amountapprovedori", "entries");
            this.setSumAmountapprovedValues(collectionentries, "amountapproved", "entries");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit expensetype = (BasedataEdit)this.getControl("expensetype");
        expensetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int entryRowCount = this.getModel().getEntryRowCount("entries");
        for (int i = 0; i < entryRowCount; ++i) {
            String initialAmountori = this.getModel().getValue("amountori", i).toString();
            this.getPageCache().put(i + "entries", initialAmountori);
        }
        this.initPositionAndCostCompany();
    }

    public void initPositionAndCostCompany() {
        DynamicObject firstrow;
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        String costcompany = "";
        String costdept = "";
        if (entries.size() > 0) {
            DynamicObject companycurrency = (DynamicObject)((DynamicObject)entries.get(0)).get("costcompany");
            if (companycurrency != null) {
                costcompany = companycurrency.getString("name");
            }
            costdept = ((DynamicObject)entries.get(0)).getString("costcenter");
        }
        Label costcompanyv = (Label)this.getControl("costcompanyv");
        Label costdeptv = (Label)this.getControl("costdeptv");
        costcompanyv.setText(costcompany);
        costdeptv.setText(costdept);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskID = (String)formShowParameter.getCustomParams().get("taskID");
        FormShowParameter parFormShowPara = this.getView().getParentView().getFormShowParameter();
        String pooltype = (String)parFormShowPara.getCustomParams().get("pooltype");
        if (StringUtils.isNull((String)pooltype)) {
            pooltype = (String)parFormShowPara.getCustomParams().get("pooltype-mytask");
        }
        DynamicObject task = null;
        task = !pooltype.equals("2") ? BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task")) : BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_taskhistory"));
        DynamicObject applier = task.getDynamicObject("creator");
        String applierid = String.valueOf(applier.getLong("id"));
        String picturefield = (String)applier.get("picturefield");
        String position = "";
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)applierid, (String)"bos_user");
        if (userObject != null && (firstrow = (DynamicObject)userObject.getDynamicObjectCollection("entryentity").get(0)) != null) {
            position = firstrow.getString("position");
        }
        Label positionLabel = (Label)this.getControl("position");
        positionLabel.setText(position);
        this.getPageCache().put(CHCHE_TASKEVECTIONLOANBILL_APPLAYID_VALUE, applierid);
        EasTaskExpenseHelper.showCreditInfoForm(this.getView(), applier.getLong("id"));
        Image picture = (Image)this.getControl("imageap");
        picture.setUrl(picturefield);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            String userId = this.getPageCache().get(CHCHE_TASKEVECTIONLOANBILL_APPLAYID_VALUE);
            IFormView view = this.getView();
            EasTaskExpenseHelper.showCreditFilesForm(view, userId);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.afterBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection collectionentries = data.getDynamicObjectCollection("entries");
        this.setSumAmountValues(collectionentries, "amountori", "entries");
        this.setSumAmountValues(collectionentries, "amountapprovedori", "entries");
        this.setSumAmountapprovedValues(collectionentries, "amountapproved", "entries");
    }

    private void setSumAmountValues(DynamicObjectCollection collectionentries, String keyValues, String keyEntry) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(collectionentries, keyValues);
        DecimalFormat dFormat = new DecimalFormat("###,###.00");
        String sign = "\uffe5";
        if (collectionentries.size() > 0) {
            DynamicObject currency = (DynamicObject)((DynamicObject)collectionentries.get(0)).get("currency");
            sign = currency.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    private void setSumAmountapprovedValues(DynamicObjectCollection collectionentries, String keyValues, String keyEntry) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(collectionentries, keyValues);
        DecimalFormat dFormat = new DecimalFormat("###,###.00");
        String sign = "\uffe5";
        if (collectionentries.size() > 0) {
            DynamicObject loccur = (DynamicObject)this.getModel().getValue("loccur");
            sign = loccur.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("expensetype".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        }
    }

    private void calculation(BigDecimal newAmountori, int rowIndex) {
        this.getModel().setValue("amountapproved", (Object)newAmountori.multiply((BigDecimal)this.getModel().getValue("exchangeRate")).setScale(((DynamicObject)this.getModel().getValue("loccur")).getInt("amtprecision"), 4), rowIndex);
    }
}

