/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.extendplugin.base.TaskExtendBill;
import kd.ssc.task.util.EasTaskExpenseHelper;

public class TaskMarketAccountBill
extends TaskExtendBill
implements BeforeF7SelectListener,
ClickListener {
    private BigDecimal originM;
    private static final String CHCHE_TASKMARKETACCOUNT_APPLAYID_VALUE = "CHCHE_TASKMARKETACCOUNT_APPLAYID_VALUE";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.originM = (BigDecimal)this.getModel().getValue("amoundstriked");
        this.getPageCache().put("originM", SerializationUtils.toJsonString((Object)this.originM));
    }

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit expensetype = (BasedataEdit)this.getControl("expensetype");
        expensetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("amountapproved".equals(propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            IDataModel model = this.getModel();
            BigDecimal amtloc_new = (BigDecimal)changeData.getNewValue();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entries");
            BigDecimal initialAmountapproved = new BigDecimal(this.getPageCache().get(entryCurrentRowIndex + "entries"));
            if (amtloc_new.compareTo(initialAmountapproved) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"TaskMarketAccountBill_0", (String)"ssc-task-ext", (Object[])new Object[0]));
                model.setValue("amountapproved", (Object)initialAmountapproved, changeData.getRowIndex());
            }
            BigDecimal totalAmountapproved = this.getTotalAmountapproved();
            this.originM = new BigDecimal(this.getPageCache().get("originM"));
            if (this.originM.compareTo(totalAmountapproved) > 0) {
                model.setValue("amoundstriked", (Object)totalAmountapproved);
            } else {
                model.setValue("amoundstriked", (Object)this.originM);
            }
            this.refreshAmountencashed(totalAmountapproved);
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int entryRowCount = this.getModel().getEntryRowCount("entries");
        for (int i = 0; i < entryRowCount; ++i) {
            String initialAmountapproved = this.getModel().getValue("amountapproved", i).toString();
            this.getPageCache().put(i + "entries", initialAmountapproved);
        }
        this.initPositionAndCostCompany();
    }

    public void initPositionAndCostCompany() {
        DynamicObject firstrow;
        String costcompany = "";
        DynamicObject data = this.getModel().getDataEntity();
        costcompany = ((DynamicObject)data.get("company")).getString("name");
        Label costcompanyv = (Label)this.getControl("costcompanyv");
        costcompanyv.setText(costcompany);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskID = (String)formShowParameter.getCustomParams().get("taskID");
        FormShowParameter parFormShowPara = this.getView().getParentView().getFormShowParameter();
        String pooltype = (String)parFormShowPara.getCustomParams().get("pooltype");
        if (StringUtils.isNull((String)pooltype)) {
            pooltype = (String)parFormShowPara.getCustomParams().get("pooltype-mytask");
        }
        DynamicObject task = null;
        task = !pooltype.equals("2") ? BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task")) : BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_taskhistory"));
        DynamicObject applier = task.getDynamicObject("creator");
        String company = "";
        String dept = "";
        long deptID = UserServiceHelper.getUserMainOrgId((long)applier.getLong("id"));
        OrgServiceHelper orgSerHelper = new OrgServiceHelper();
        DynamicObject bizOrg = orgSerHelper.getBizOrg(Long.valueOf(deptID), "01");
        dept = bizOrg.get("name").toString();
        this.getModel().setValue("dept", (Object)dept);
        Map companyInfo = OrgServiceHelper.getCompanyfromOrg((Object)deptID);
        company = (String)companyInfo.get("name");
        this.getModel().setValue("appliercompany", (Object)company);
        String applierid = String.valueOf(applier.getLong("id"));
        String picturefield = (String)applier.get("picturefield");
        String position = "";
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)applierid, (String)"bos_user");
        if (userObject != null && (firstrow = (DynamicObject)userObject.getDynamicObjectCollection("entryentity").get(0)) != null) {
            position = firstrow.getString("position");
        }
        Label positionLabel = (Label)this.getControl("position");
        positionLabel.setText(position);
        this.getPageCache().put(CHCHE_TASKMARKETACCOUNT_APPLAYID_VALUE, applierid);
        EasTaskExpenseHelper.showCreditInfoForm(this.getView(), applier.getLong("id"));
        Image picture = (Image)this.getControl("imageap");
        picture.setUrl(picturefield);
        String product = (String)this.getModel().getValue("producttype");
        if (product.equals(" ")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"producttype"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            String userId = this.getPageCache().get(CHCHE_TASKMARKETACCOUNT_APPLAYID_VALUE);
            IFormView view = this.getView();
            EasTaskExpenseHelper.showCreditFilesForm(view, userId);
        }
    }

    public BigDecimal getTotalAmountapproved() {
        BigDecimal totalAmountapproved = new BigDecimal(0);
        int entryRowCount = this.getModel().getEntryRowCount("entries");
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal entryAmountapproved = (BigDecimal)this.getModel().getValue("amountapproved", i);
            totalAmountapproved = totalAmountapproved.add(entryAmountapproved);
        }
        return totalAmountapproved;
    }

    private void refreshAmountencashed(BigDecimal totalAmountapproved) {
        Object amoundstriked = this.getModel().getValue("amoundstriked");
        if (amoundstriked == null) {
            amoundstriked = new BigDecimal(0);
        }
        BigDecimal amountencashed = totalAmountapproved.subtract((BigDecimal)amoundstriked);
        this.getModel().setValue("amountencashed", (Object)amountencashed);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("expensetype".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        }
    }
}

