/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.eas.bill.EASTaskReimbursebillHandler;
import kd.ssc.task.extendplugin.TaskSumAmountBill;
import kd.ssc.task.extendplugin.base.TaskExtendBill;
import kd.ssc.task.util.EasTaskExpenseHelper;
import kd.ssc.task.util.ExchangeRateService;

public class TaskReimburseBill
extends TaskExtendBill
implements BeforeF7SelectListener,
ClickListener {
    private static final String CHCHE_TASKREIMBURSEBILL_APPLAYID_VALUE = "CHCHE_TASKREIMBURSEBILL_APPLAYID_VALUE";
    private boolean isAmountapprovedCalled = false;
    private boolean isAmountapprovedoriCalled = false;
    private static final Log logger = LogFactory.getLog(TaskReimburseBill.class);

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit expensetype = (BasedataEdit)this.getControl("expensetype");
        expensetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bgitem1 = (BasedataEdit)this.getControl("bgitem1");
        bgitem1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit paymode1 = (BasedataEdit)this.getControl("paymode1");
        paymode1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit loanbill = (BasedataEdit)this.getControl("loanbill");
        loanbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entries = (BasedataEdit)this.getControl("operationtype1");
        entries.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    private void setFloatAmountValues(DynamicObjectCollection entries, String keyCol, String entryName, String signColName) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(entries, keyCol);
        DecimalFormat dFormat = new DecimalFormat("###,##0.00");
        String sign = "\uffe5";
        if (entries.size() > 0) {
            DynamicObject currency = (DynamicObject)((DynamicObject)entries.get(0)).get(signColName);
            sign = currency.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyCol, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    @Override
    public void afterLoadData(EventObject e) {
        int payModeSize;
        super.afterLoadData(e);
        int operationtypeSize = this.getModel().getEntryRowCount("entries");
        if (operationtypeSize > 0) {
            for (int i = 0; i < operationtypeSize; ++i) {
                if (StringUtils.isNotEmpty((String)((String)this.getModel().getValue("operationtype", i)))) {
                    this.setFieldEditVisible(false, "operationtype1");
                } else {
                    this.setFieldEditVisible(false, "operationtype");
                }
                if (StringUtils.isNotEmpty((String)((String)this.getModel().getValue("bgitem", i)))) {
                    this.setFieldEditVisible(false, "bgitem1");
                    continue;
                }
                this.setFieldEditVisible(false, "bgitem");
            }
        }
        if (!this.isMoreCurrency()) {
            this.setFieldEditVisible(false, "checkamountori");
        }
        if ((payModeSize = this.getModel().getEntryRowCount("collectionentries")) > 0) {
            for (int i = 0; i < payModeSize; ++i) {
                if (StringUtils.isNotEmpty((String)((String)this.getModel().getValue("paymode", i)))) {
                    this.setFieldEditVisible(false, "paymode1");
                    continue;
                }
                this.setFieldEditVisible(false, "paymode");
            }
        }
        this.initPositionAndCostCompany();
    }

    public void initPositionAndCostCompany() {
        DynamicObject firstrow;
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        String costcompany = "";
        String costdept = "";
        if (entries.size() > 0) {
            DynamicObject companycurrency = (DynamicObject)((DynamicObject)entries.get(0)).get("company");
            if (companycurrency != null) {
                costcompany = companycurrency.getString("name");
            }
            costdept = ((DynamicObject)entries.get(0)).getString("costcenter");
        }
        Label costcompanyv = (Label)this.getControl("costcompanyv");
        Label costdeptv = (Label)this.getControl("costdeptv");
        costcompanyv.setText(costcompany);
        costdeptv.setText(costdept);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskID = (String)formShowParameter.getCustomParams().get("taskID");
        FormShowParameter parFormShowPara = this.getView().getParentView().getFormShowParameter();
        String pooltype = (String)parFormShowPara.getCustomParams().get("pooltype");
        if (StringUtils.isNull((String)pooltype)) {
            pooltype = (String)parFormShowPara.getCustomParams().get("pooltype-mytask");
        }
        DynamicObject task = null;
        task = !pooltype.equals("2") ? BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task")) : BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_taskhistory"));
        DynamicObject applier = task.getDynamicObject("creator");
        String applierid = String.valueOf(applier.getLong("id"));
        String picturefield = (String)applier.get("picturefield");
        String position = "";
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)applierid, (String)"bos_user");
        if (userObject != null && (firstrow = (DynamicObject)userObject.getDynamicObjectCollection("entryentity").get(0)) != null) {
            position = firstrow.getString("position");
        }
        Label positionLabel = (Label)this.getControl("position");
        positionLabel.setText(position);
        this.getPageCache().put(CHCHE_TASKREIMBURSEBILL_APPLAYID_VALUE, applierid);
        EasTaskExpenseHelper.showCreditInfoForm(this.getView(), applier.getLong("id"));
        Image picture = (Image)this.getControl("imageap");
        picture.setUrl(picturefield);
        String product = (String)this.getModel().getValue("producttypeid");
        if (product.equals(" ")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"producttypeid"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            String userId = this.getPageCache().get(CHCHE_TASKREIMBURSEBILL_APPLAYID_VALUE);
            IFormView view = this.getView();
            EasTaskExpenseHelper.showCreditFilesForm(view, userId);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        String taskID;
        DynamicObject task;
        DynamicObjectCollection collectionentries;
        super.afterBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        boolean hideOriAmt = true;
        this.amountUpdateDCtr();
        for (DynamicObject ey : entries) {
            BigDecimal exg = (BigDecimal)ey.get("exchangerate");
            if (exg.compareTo(new BigDecimal("1")) == 0) continue;
            hideOriAmt = false;
            break;
        }
        if (hideOriAmt) {
            this.setFieldEditVisible(false, "amountoriwithouttax", "amountori", "amountapprovedoriwithoutt", "amountapprovedori");
        }
        this.setFieldEditEnable((collectionentries = data.getDynamicObjectCollection("collectionentries")).size() > 1, "pamountori");
        this.setSumAmountValues(collectionentries, "pamountori", "collectionentries");
        EASTaskReimbursebillHandler handler = new EASTaskReimbursebillHandler();
        BigDecimal result = handler.getPreparedAmt(this.getModel().getDataEntity().get("id").toString());
        Label pamt = (Label)this.getControl("preparedamt");
        pamt.setText(String.format(ResManager.loadKDString((String)"\u5907\u7528\u91d1\uff1a%s", (String)"TaskReimburseBill_0", (String)"ssc-task-ext", (Object[])new Object[0]), result));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW != formShowParameter.getStatus() && (task = BusinessDataReader.loadSingle((Object)(taskID = (String)formShowParameter.getCustomParams().get("taskID")), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task"))) != null) {
            DynamicObject applier = task.getDynamicObject("creator");
            this.getPageCache().put("applierid", Long.valueOf(applier.getLong("id")).toString());
            try {
                handler.importLoanbill(applier.getLong("id"), "BizAccountBill", "dailyLoan");
            }
            catch (Exception exp) {
                logger.error("\u540c\u6b65\u501f\u6b3e\u5355\u51fa\u9519", (Throwable)exp);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u501f\u6b3e\u5355\u51fa\u9519\uff1a%s", (String)"TaskReimburseBill_1", (String)"ssc-task-ext", (Object[])new Object[0]), exp.getMessage()));
            }
        }
        this.setFloatAmountValues(entries, "amountapprovedori", "entries", "entrycurrency");
    }

    private void setSumAmountValues(DynamicObjectCollection collectionentries, String keyValues, String keyEntry) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(collectionentries, keyValues);
        DecimalFormat dFormat = new DecimalFormat("###,##0.00");
        String sign = "\uffe5";
        if (collectionentries.size() > 0) {
            DynamicObject currency = (DynamicObject)((DynamicObject)collectionentries.get(0)).get("currency");
            sign = currency.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    private void amountUpdateDCtr() {
        boolean moreCurrency = this.isMoreCurrency();
        if (moreCurrency) {
            this.setFieldEditEnable(false, "amountapproved");
        } else {
            this.setFieldEditEnable(false, "amountapprovedori");
        }
    }

    private boolean isMoreCurrency() {
        boolean moreCurrency = false;
        DynamicObjectCollection entries = this.getModel().getDataEntity().getDynamicObjectCollection("entries");
        long loccurID = this.getModel().getValue("loccur") == null ? 0L : ((DynamicObject)this.getModel().getValue("loccur")).getLong("id");
        for (DynamicObject ey : entries) {
            long entryCurID = ey.getDynamicObject("entrycurrency").getLong("id");
            if (loccurID == entryCurID) continue;
            moreCurrency = true;
            break;
        }
        return moreCurrency;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int pamoutSize;
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if ("amountapproved".equals(propertyName)) {
            if (this.isAmountapprovedCalled) {
                return;
            }
            this.isAmountapprovedCalled = true;
            BigDecimal amtloc = (BigDecimal)changeData.getNewValue();
            BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate", changeData.getRowIndex());
            BigDecimal oriAmt = (BigDecimal)model.getValue("amountapprovedori", changeData.getRowIndex());
            int oriPrec = ((DynamicObject)model.getValue("entrycurrency", changeData.getRowIndex())).getInt("amtprecision");
            oriAmt = amtloc.divide(exchangerate, oriPrec, 4);
            if (!this.isAmountapprovedoriCalled) {
                model.setValue("amountapprovedori", (Object)oriAmt, changeData.getRowIndex());
            }
            BigDecimal amtloc_old = (BigDecimal)changeData.getOldValue();
            BigDecimal addLocAmt = amtloc.subtract(amtloc_old);
            this.addRecAmt(model, addLocAmt);
            BigDecimal amountAppproved = (BigDecimal)changeData.getNewValue();
            BigDecimal tax = (BigDecimal)model.getValue("tax", changeData.getRowIndex());
            this.calcTax(model, changeData.getRowIndex(), amountAppproved, tax);
        } else if ("amountapprovedori".equals(propertyName)) {
            if (this.isAmountapprovedoriCalled) {
                return;
            }
            this.isAmountapprovedoriCalled = true;
            BigDecimal oriAmt = (BigDecimal)changeData.getNewValue();
            BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate", changeData.getRowIndex());
            BigDecimal amtloc = oriAmt.multiply(exchangerate);
            int oriPrec = ((DynamicObject)model.getValue("loccur")).getInt("amtprecision");
            amtloc = amtloc.setScale(oriPrec, 4);
            if (!this.isAmountapprovedCalled) {
                model.setValue("amountapproved", (Object)amtloc, changeData.getRowIndex());
            }
            this.setSumAmountValues2("amountapprovedori", "entries", "entrycurrency");
        } else if ("tax".equals(propertyName)) {
            BigDecimal amountAppproved = (BigDecimal)model.getValue("amountapproved", changeData.getRowIndex());
            BigDecimal tax = (BigDecimal)changeData.getNewValue();
            this.calcTax(model, changeData.getRowIndex(), amountAppproved, tax);
        } else if ("amountwithouttax".equals(propertyName)) {
            BigDecimal amtloc = (BigDecimal)changeData.getNewValue();
            model.setValue("amountapprovedwithouttax", (Object)amtloc, changeData.getRowIndex());
            BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate", changeData.getRowIndex());
            BigDecimal oriAmt = (BigDecimal)model.getValue("amountapprovedoriwithoutt", changeData.getRowIndex());
            int oriPrec = ((DynamicObject)model.getValue("entrycurrency", changeData.getRowIndex())).getInt("amtprecision");
            oriAmt = amtloc.divide(exchangerate, oriPrec, 4);
            model.setValue("amountapprovedoriwithoutt", (Object)oriAmt, changeData.getRowIndex());
            model.setValue("amountoriwithouttax", (Object)oriAmt, changeData.getRowIndex());
        } else if ("pamountori".equals(propertyName)) {
            BigDecimal amtOri = (BigDecimal)changeData.getNewValue();
            BigDecimal payrate = (BigDecimal)model.getValue("payrate", changeData.getRowIndex());
            BigDecimal pamount = (BigDecimal)model.getValue("pamount", changeData.getRowIndex());
            int locPrec = ((DynamicObject)model.getValue("loccur")).getInt("amtprecision");
            BigDecimal amtLoc = amtOri.multiply(payrate).setScale(locPrec, 4);
            int lastCollectionentryIndex = this.getModel().getEntryRowCount("collectionentries") - 1;
            if (lastCollectionentryIndex != changeData.getRowIndex()) {
                model.setValue("pamount", (Object)amtLoc, changeData.getRowIndex());
            }
            BigDecimal amountapprovedoriSum = new BigDecimal("0");
            BigDecimal amountapprovedSum = new BigDecimal("0");
            int entrySize = this.getModel().getEntryRowCount("entries");
            if (entrySize > 0) {
                for (int i = 0; i < entrySize; ++i) {
                    BigDecimal amountapprovedori = (BigDecimal)this.getModel().getValue("amountapprovedori", i);
                    BigDecimal amountapproved = (BigDecimal)this.getModel().getValue("amountapproved", i);
                    amountapprovedoriSum = amountapprovedoriSum.add(amountapprovedori);
                    amountapprovedSum = amountapprovedSum.add(amountapproved);
                }
            }
            BigDecimal checkamountoriSum = new BigDecimal("0");
            BigDecimal checkamountSum = new BigDecimal("0");
            int loancheckSize = this.getModel().getEntryRowCount("loancheckentries");
            if (loancheckSize > 0) {
                for (int i = 0; i < loancheckSize; ++i) {
                    BigDecimal checkamountori = (BigDecimal)this.getModel().getValue("checkamountori", i);
                    BigDecimal checkamount = (BigDecimal)this.getModel().getValue("checkamount", i);
                    checkamountoriSum = checkamountoriSum.add(checkamountori);
                    checkamountSum = checkamountSum.add(checkamount);
                }
            }
            BigDecimal pamountoriSum = new BigDecimal("0");
            BigDecimal pamountSum = new BigDecimal("0");
            BigDecimal pamountSumNotLast = new BigDecimal("0");
            int collectionentrySize = this.getModel().getEntryRowCount("collectionentries");
            if (collectionentrySize > 0) {
                for (int i = 0; i < collectionentrySize; ++i) {
                    BigDecimal pamountori = (BigDecimal)this.getModel().getValue("pamountori", i);
                    BigDecimal pamountForSum = (BigDecimal)this.getModel().getValue("pamount", i);
                    if (i != collectionentrySize - 1) {
                        pamountSumNotLast = pamountSumNotLast.add(pamountForSum);
                    }
                    pamountoriSum = pamountoriSum.add(pamountori);
                    pamountSum = pamountSum.add(pamountForSum);
                }
            }
            if (pamountoriSum.add(checkamountoriSum).compareTo(amountapprovedoriSum) == 0) {
                BigDecimal approvedAndCheckDiff = amountapprovedSum.subtract(checkamountSum);
                BigDecimal amountapprovedDiff = approvedAndCheckDiff.subtract(pamountSumNotLast);
                model.setValue("pamount", (Object)amountapprovedDiff, lastCollectionentryIndex);
            } else {
                model.setValue("pamount", (Object)amtLoc, changeData.getRowIndex());
            }
            this.setPamountOriSum();
        } else if ("checkamount".equals(propertyName)) {
            if ("1".equals(this.getPageCache().get("loanChange"))) {
                return;
            }
            BigDecimal amtloc_old = (BigDecimal)changeData.getOldValue();
            if (amtloc_old == null) {
                amtloc_old = BigDecimal.ZERO;
            }
            BigDecimal amtloc = (BigDecimal)changeData.getNewValue();
            BigDecimal addAmt = amtloc_old.subtract(amtloc);
            DynamicObject loanBill = (DynamicObject)model.getValue("loanbill", changeData.getRowIndex());
            if (loanBill == null) {
                return;
            }
            DynamicObject currency = loanBill.getDynamicObject("currency");
            if (currency == null) {
                loanBill = BusinessDataServiceHelper.loadSingle((Object)loanBill.get("id"), (String)"task_loan", (String)"id,currency.id,currency.number,currency.name,currency.amtprecision,rate");
                currency = loanBill.getDynamicObject("currency");
            } else {
                currency = BusinessDataServiceHelper.loadSingle((Object)currency.get("id"), (String)"bd_currency", (String)"id,number,name,amtprecision");
            }
            int oriPrec = 2;
            if (currency != null) {
                currency = BusinessDataServiceHelper.loadSingle((Object)currency.get("id"), (String)"bd_currency", (String)"id,number,name,amtprecision");
                oriPrec = currency.getInt("amtprecision");
            }
            BigDecimal oriAmt = amtloc.divide(loanBill.getBigDecimal("rate"), 2, 4);
            model.setValue("checkamountori", (Object)oriAmt, changeData.getRowIndex());
            this.addRecAmt(model, BigDecimal.ZERO);
            if ("0".equals(this.getPageCache().get("loanChange"))) {
                this.getPageCache().put("loanChange", "1");
            }
        } else if ("loanbill".equals(propertyName)) {
            this.getPageCache().put("loanChange", "0");
            DynamicObject loanbill = (DynamicObject)changeData.getNewValue();
            if (loanbill == null) {
                return;
            }
            DynamicObject loanbillOld = (DynamicObject)changeData.getOldValue();
            boolean isExist = this.isExist(Long.parseLong(loanbill.get("id").toString()), changeData.getRowIndex());
            if (isExist) {
                model.setValue("sourcebillexpensetype", loanbill.get("expensetype"), changeData.getRowIndex());
                model.setValue("sourcebillcause", loanbill.get("cause"), changeData.getRowIndex());
                model.setValue("sourcebillamountbalance", loanbill.get("amountbalance"), changeData.getRowIndex());
                model.setValue("checkamount", loanbill.get("amountbalance"), changeData.getRowIndex());
                model.setValue("sourcebillid", loanbill.get("easid"), changeData.getRowIndex());
                model.setValue("sourcebillentryid", loanbill.get("entryid"), changeData.getRowIndex());
            } else {
                this.getModel().setValue("loanbill", (Object)loanbillOld, changeData.getRowIndex());
            }
            this.getPageCache().put("loanChange", null);
        } else if ("currency".equals(propertyName)) {
            DynamicObject currency = (DynamicObject)changeData.getNewValue();
            DynamicObject loccur = (DynamicObject)model.getValue("loccur");
            List tablePks = QueryServiceHelper.queryPrimaryKeys((String)"ssc.TaskReimburseBill.bd_exratetable", (String)"bd_exratetable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"er_exchangeratetable")}, null, (int)1);
            if (tablePks != null && tablePks.size() > 0) {
                ExchangeRateService service = new ExchangeRateService();
                BigDecimal excg = service.getExchangeRate((Long)tablePks.get(0), (Long)currency.getPkValue(), (Long)loccur.getPkValue(), new Date());
                if (excg == null) {
                    excg = new BigDecimal("1.0000");
                }
                model.setValue("payrate", (Object)excg, changeData.getRowIndex());
                BigDecimal pamount = (BigDecimal)model.getValue("pamount", changeData.getRowIndex());
                int oriPrecRec = currency.getInt("amtprecision");
                BigDecimal recOriAmt = pamount.divide(excg, oriPrecRec, 4);
                model.setValue("pamountori", (Object)recOriAmt, changeData.getRowIndex());
            }
        } else if ("pamount".equals(propertyName) && (pamoutSize = this.getModel().getEntryRowCount("collectionentries")) > 0) {
            BigDecimal pamountSum = new BigDecimal("0");
            for (int i = 0; i < pamoutSize; ++i) {
                BigDecimal curPamount = (BigDecimal)this.getModel().getValue("pamount", i);
                pamountSum = pamountSum.add(curPamount);
            }
            model.setValue("amountencashed", (Object)pamountSum);
        }
    }

    private void setPamountOriSum() {
        BigDecimal pamountoriForSum = this.getSKPamontoriSum();
        String sign = this.getCurrentcyTag();
        Map<String, String> floatButtomData = this.buildGradeSumData(pamountoriForSum, sign);
        this.setSumValue(floatButtomData);
    }

    private void setSumValue(Map<String, String> floatButtomData) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("collectionentries");
        entryGrid.setFloatButtomData(floatButtomData);
    }

    private Map<String, String> buildGradeSumData(BigDecimal pamountoriForSum, String sign) {
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        DecimalFormat dFormat = new DecimalFormat("###,##0.00");
        floatButtomData.put("pamountori", sign + dFormat.format(pamountoriForSum));
        return floatButtomData;
    }

    private String getCurrentcyTag() {
        DynamicObject currencyDyObj = (DynamicObject)this.getModel().getValue("currency");
        String sign = currencyDyObj.get("sign").toString();
        return sign;
    }

    private BigDecimal getSKPamontoriSum() {
        BigDecimal pamountoriForSum = new BigDecimal("0");
        int collectionentrySizeForSum = this.getModel().getEntryRowCount("collectionentries");
        if (collectionentrySizeForSum > 0) {
            for (int i = 0; i < collectionentrySizeForSum; ++i) {
                BigDecimal pamountori = (BigDecimal)this.getModel().getValue("pamountori", i);
                pamountoriForSum = pamountoriForSum.add(pamountori);
            }
        }
        return pamountoriForSum;
    }

    private boolean isExist(long loanbillID, int index) {
        int loancheckentriesCount = this.getModel().getEntryRowCount("loancheckentries");
        for (int i = 0; i < loancheckentriesCount; ++i) {
            long id;
            DynamicObject obj = (DynamicObject)this.getModel().getValue("loanbill", i);
            if (index == i || obj == null || loanbillID != (id = ((Long)obj.get("id")).longValue())) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u6b64\u501f\u6b3e\u5355\u53f7\u5df2\u7ecf\u5f55\u5165\uff0c\u8bf7\u91cd\u65b0\u5f55\u3002", (String)"TaskReimburseBill_3", (String)"ssc-task-ext", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void calcTax(IDataModel model, int rowIndex, BigDecimal amountAppproved, BigDecimal tax) {
        int oriPrec = ((DynamicObject)model.getValue("entrycurrency", rowIndex)).getInt("amtprecision");
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate", rowIndex);
        BigDecimal amountwithouttax = amountAppproved.subtract(tax);
        model.setValue("amountwithouttax", (Object)amountwithouttax, rowIndex);
        BigDecimal amountoriwithouttax = amountwithouttax.divide(exchangerate, oriPrec, 4);
        model.setValue("amountoriwithouttax", (Object)amountoriwithouttax, rowIndex);
    }

    private void addRecAmt(IDataModel model, BigDecimal addLocAmt) {
        if (this.getModel().getEntryRowCount("collectionentries") == 1) {
            BigDecimal pamount = (BigDecimal)model.getValue("pamount", 0);
            BigDecimal recLocalAmt = addLocAmt.add(pamount);
            model.setValue("pamount", (Object)recLocalAmt, 0);
            BigDecimal amountapprovedoriSum = this.getAmountapprovedoriSum();
            BigDecimal checkamountoriSum = this.getCheckamountori();
            BigDecimal pamountoriSum = amountapprovedoriSum.subtract(checkamountoriSum);
            model.setValue("pamountori", (Object)pamountoriSum, 0);
        }
    }

    private BigDecimal getCheckamountori() {
        int loancheckentriesSize = this.getModel().getEntryRowCount("loancheckentries");
        BigDecimal checkamountoriSum = BigDecimal.ZERO;
        if (loancheckentriesSize > 0) {
            for (int i = 0; i < loancheckentriesSize; ++i) {
                BigDecimal checkamountori = (BigDecimal)this.getModel().getValue("checkamountori", i);
                checkamountoriSum = checkamountoriSum.add(checkamountori);
            }
        }
        return checkamountoriSum;
    }

    private BigDecimal getAmountapprovedoriSum() {
        int entriesSize = this.getModel().getEntryRowCount("entries");
        BigDecimal amountapprovedoriSum = BigDecimal.ZERO;
        if (entriesSize > 0) {
            for (int i = 0; i < entriesSize; ++i) {
                BigDecimal amountapprovedori = (BigDecimal)this.getModel().getValue("amountapprovedori", i);
                amountapprovedoriSum = amountapprovedoriSum.add(amountapprovedori);
            }
        }
        return amountapprovedoriSum;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject oldValue = (DynamicObject)e.getOriginalValue();
        if ("loanbill".equals(edit.getKey())) {
            showParameter.getListFilterParameter().setFilter(new QFilter("billtype", "=", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"TaskReimburseBill_4", (String)"ssc-task-ext", (Object[])new Object[0])).and(new QFilter("sourcetype", "=", (Object)"1").and(new QFilter("applier", "=", (Object)this.getPageCache().get("applierid")))));
        } else if ("expensetype".equals(edit.getKey())) {
            Object oeprationTypeObj = this.getModel().getValue("operationtype1", e.getRow());
            if (oeprationTypeObj != null) {
                if (oeprationTypeObj instanceof String) {
                    return;
                }
                DynamicObject operationtype = (DynamicObject)this.getModel().getValue("operationtype1", e.getRow());
                showParameter.getListFilterParameter().setFilter(new QFilter("operationtype", "=", operationtype.get("easid")));
            }
            showParameter.setMultiSelect(false);
        } else if ("operationtype1".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        } else if ("bgitem1".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        } else if ("paymode1".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryProp p = e.getEntryProp();
        if ("loancheckentries".equals(p.getName())) {
            IDataModel model = this.getModel();
            int entriesCnt = model.getEntryRowCount("entries");
            BigDecimal total = BigDecimal.ZERO;
            for (int i = 0; i < entriesCnt; ++i) {
                BigDecimal amountapproved = (BigDecimal)model.getValue("amountapproved", i);
                total = total.add(amountapproved);
            }
            int loancheckentriesCnt = model.getEntryRowCount("loancheckentries");
            BigDecimal totalLoan = BigDecimal.ZERO;
            for (int i = 0; i < loancheckentriesCnt; ++i) {
                BigDecimal checkamount = (BigDecimal)model.getValue("checkamount", i);
                totalLoan = totalLoan.add(checkamount);
            }
            BigDecimal recAmt = total.subtract(totalLoan);
            int collectionentriesCnt = model.getEntryRowCount("collectionentries");
            if (collectionentriesCnt > 0) {
                for (int i = 1; i < collectionentriesCnt; ++i) {
                    BigDecimal pamount = (BigDecimal)model.getValue("pamount", i);
                    recAmt = recAmt.subtract(pamount);
                }
            }
            BigDecimal payrate = (BigDecimal)model.getValue("payrate", 0);
            model.setValue("pamount", (Object)recAmt, 0);
            int oriPrecRec = ((DynamicObject)model.getValue("currency", 0)).getInt("amtprecision");
            BigDecimal recOriAmt = recAmt.divide(payrate, oriPrecRec, 4);
            model.setValue("pamountori", (Object)recOriAmt, 0);
            BigDecimal totalrec = BigDecimal.ZERO;
            for (int i = 0; i < collectionentriesCnt; ++i) {
                BigDecimal pamount = (BigDecimal)model.getValue("pamount", i);
                totalrec = totalrec.add(pamount);
            }
            model.setValue("amountencashed", (Object)totalrec);
        }
    }

    private void setSumAmountValues2(String keyValues, String keyEntry, String currencySign) {
        BigDecimal valueSum = new BigDecimal("0.00");
        DecimalFormat dFormat = new DecimalFormat("###,##0.00");
        int sizeForSum = this.getModel().getEntryRowCount(keyEntry);
        String sign = "\uffe5";
        if (sizeForSum > 0) {
            for (int i = 0; i < sizeForSum; ++i) {
                BigDecimal tmp = (BigDecimal)this.getModel().getValue(keyValues, i);
                valueSum = valueSum.add(tmp);
            }
            sign = ((DynamicObject)this.getModel().getValue(currencySign, 0)).get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        IFormView subView = this.getView().getView(this.getPageCache().get("pageID"));
        DynamicObject billData = subView.getModel().getDataEntity(true);
        DynamicObjectCollection entries = (DynamicObjectCollection)billData.get("entries");
        for (DynamicObject entry : entries) {
            String amount = entry.get("amount").toString();
            String amountapproved = entry.get("amountapproved").toString();
            if (!(Double.parseDouble(amountapproved) > Double.parseDouble(amount))) continue;
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7b2c%s\u884c\u6838\u5b9a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u4f4d\u5e01\u7533\u8bf7\u91d1\u989d\uff01", (String)"TaskReimburseBill_5", (String)"ssc-task-ext", (Object[])new Object[0]), entry.get("seq")));
            return;
        }
    }
}

