/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class EasTaskExpenseHelper {
    private static final String TABLE_TASK_CREDITFILES = "task_creditfiles";

    public static void showCreditInfoForm(IFormView view, long userid) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("task_creditfilecontrol");
        parameter.getOpenStyle().setTargetKey("creditinfopanel");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setHasRight(true);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("userid", userid);
        parameter.setCustomParams(map);
        view.showForm((FormShowParameter)parameter);
    }

    public static void showCreditFilesForm(IFormView view, String userId) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u53f7 %s \u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"EasTaskExpenseHelper_0", (String)"ssc-task-ext", (Object[])new Object[0]), userId));
            return;
        }
        String id = EasTaskExpenseHelper.getCreditFilesID(userId);
        if (StringUtils.isBlank((CharSequence)id)) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u53f7 %s \u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"EasTaskExpenseHelper_0", (String)"ssc-task-ext", (Object[])new Object[0]), userId));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(TABLE_TASK_CREDITFILES);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848", (String)"EasTaskExpenseHelper_1", (String)"ssc-task-ext", (Object[])new Object[0]));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId((Object)id);
        parameter.setHasRight(true);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fromwhere", "tasklist");
        map.put("pageid", view.getPageId());
        parameter.setCustomParams(map);
        view.showForm((FormShowParameter)parameter);
    }

    public static String getCreditFilesID(String userId) {
        QFilter filter = new QFilter("user", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject user = QueryServiceHelper.queryOne((String)TABLE_TASK_CREDITFILES, (String)"id,user.name,user.id", (QFilter[])filters);
        if (user == null) {
            return null;
        }
        return user.getString("id");
    }
}

