/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.Expirestate;
import kd.ssc.task.util.DateUtil;

public class ExpenseBoardApiServiceUtil {
    private static String entityName = "task_task";
    private static String algoPrefix = "kd.ssc.task.util.ExpenseBoardApiServiceHelper.getTaskAmountWithFilters.";
    private static String algoPrefix2 = "kd.ssc.task.util.ExpenseBoardApiServiceHelper.getTaskAmountWithDateRange.";
    private static String completentityName = "task_taskhistory";
    private static final Log log = LogFactory.getLog(ExpenseBoardApiServiceUtil.class);
    private static final String FLAG_DAY = "day";
    private static final String FLAG_MONTH = "month";
    private static final String FLAG_YEAR = "year";
    private static String algoPrefix3 = "kd.ssc.task.util.ExpenseBoardApiServiceUtil.getMonthTaskRankMap";
    private static String algoPrefix4 = "kd.ssc.task.util.ExpenseBoardApiServiceUtil.getTaskAmountWithDateRangeWithRank.";
    private static String algoPrefix5 = "kd.ssc.task.util.ExpenseBoardApiServiceUtil.getExpiredTaskAmountWithDateRangeWithRank";
    private static String algoPrefix6 = "kd.ssc.task.util.ExpenseBoardApiServiceUtil.getUnExpiredTaskAmountWithDateRangeWithRank";
    private static String algoPrefix7 = "kd.ssc.task.util.ExpenseBoardApiServiceUtil.getAllTaskAmountWithDateRangeWithRank";
    private static final String TABLE_BOS_USER = "bos_user";
    private static final String TABLE_BOS_ORG = "bos_org";
    private static final String IMAGE_PATH_RANK_FIRST = "url(.//images//first.png)";
    private static final String IMAGE_PATH_RANK_SECOND = "url(.//images//second.png)";
    private static final String IMAGE_PATH_RANK_THIRD = "url(.//images//third.png)";
    private static final String IMAGE_PATH_RANK_DEFAULT = "url(.//images//background.png)";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ssc-task");

    public static List<Map<String, Object>> getExpenseBoardShowData(Map<Object, Object> params) {
        long sscId;
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        String sscIdStr = (String)params.get("sscId");
        try {
            sscId = Long.parseLong(sscIdStr);
        }
        catch (NumberFormatException e) {
            log.error("transfer billId error,only support long type sscId:" + sscIdStr);
            return retList;
        }
        List<Map<String, Object>> topList = ExpenseBoardApiServiceUtil.getBoardTopShowData(sscId);
        HashMap<String, List<Map<String, Object>>> topMap = new HashMap<String, List<Map<String, Object>>>();
        topMap.put("top", topList);
        List<Map<String, Object>> bottomList = ExpenseBoardApiServiceUtil.getBoardBottomShowData(sscId);
        HashMap<String, List<Map<String, Object>>> bottomMap = new HashMap<String, List<Map<String, Object>>>();
        bottomMap.put("bottom", bottomList);
        retList.add(topMap);
        retList.add(bottomMap);
        return retList;
    }

    public static Map<Long, String> getExpenseBoardOrgData() {
        long userid = Long.parseLong(RequestContext.get().getUserId());
        List orgIDs = PermissionServiceHelper.getUserOrgs((long)userid);
        QFilter idFilter = new QFilter("id", "in", (Object)orgIDs);
        QFilter issccFilter = new QFilter("fisscc", "=", (Object)"1");
        ArrayList<QFilter> qFList = new ArrayList<QFilter>();
        qFList.add(idFilter);
        qFList.add(issccFilter);
        QFilter[] qF = qFList.toArray(new QFilter[qFList.size()]);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)TABLE_BOS_ORG, (String)"id,name", (QFilter[])qF, null);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(16);
        if (result == null || result.length == 0) {
            return orgMap;
        }
        for (DynamicObject dynObj : result) {
            Long orgId = dynObj.getLong("id");
            String orgName = dynObj.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((Object)orgName)) {
                orgName = dynObj.getString("name");
            }
            orgMap.put(orgId, orgName);
        }
        return orgMap;
    }

    private static List<Map<String, Object>> getBoardTopShowData(Long sscId) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> progressingMap = new HashMap<String, String>();
        HashMap<String, String> uploadImageMap = new HashMap<String, String>();
        HashMap<String, String> expiredMap = new HashMap<String, String>();
        Map<String, Object> processingValueMap = ExpenseBoardApiServiceUtil.getTaskAmountWithFilters(Arrays.asList(TaskPoolTypeEnum.TO_BE_DIS.getValue(), TaskPoolTypeEnum.PROCESSING.getValue()), sscId);
        String processingValue = String.valueOf(processingValueMap.get("currentValue"));
        progressingMap.put("value", processingValue);
        progressingMap.put("name", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ExpenseBoardApiServiceUtil_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        Map<String, Object> uploadImageValueMap = ExpenseBoardApiServiceUtil.getTaskAmountWithFilters(Collections.singletonList(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue()), sscId);
        String uploadImageValue = String.valueOf(uploadImageValueMap.get("currentValue"));
        uploadImageMap.put("value", uploadImageValue);
        uploadImageMap.put("name", ResManager.loadKDString((String)"\u5f85\u626b\u63cf", (String)"ExpenseBoardApiServiceUtil_1", (String)"ssc-task-ext", (Object[])new Object[0]));
        Map<String, Object> expiredValueMap = ExpenseBoardApiServiceUtil.getTaskAmountWithFilters(Collections.singletonList(TaskPoolTypeEnum.COMPLETE.getValue()), sscId);
        String expiredValue = String.valueOf(expiredValueMap.get("currentValue"));
        expiredMap.put("value", expiredValue);
        expiredMap.put("name", ResManager.loadKDString((String)"\u5df2\u8d85\u671f", (String)"ExpenseBoardApiServiceUtil_2", (String)"ssc-task-ext", (Object[])new Object[0]));
        retList.add(progressingMap);
        retList.add(uploadImageMap);
        retList.add(expiredMap);
        return retList;
    }

    private static List<Map<String, Object>> getBoardBottomShowData(Long sscId) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> taskChartList = ExpenseBoardApiServiceUtil.getBoardTopShowData(sscId);
        Map<String, Object> taskMap = ExpenseBoardApiServiceUtil.getDifferentRangeCompleteTaskMap(sscId);
        Map<String, Object> progressMap = ExpenseBoardApiServiceUtil.getAllTaskAmountWithDateRangeWithRank(FLAG_MONTH, 12, sscId);
        Map<String, Object> rankMap = ExpenseBoardApiServiceUtil.getMonthTaskRankMap(FLAG_MONTH, sscId);
        retList.add(taskMap);
        retList.add(progressMap);
        retList.add(rankMap);
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getTaskAmountWithFilters(List<String> poolTypeList, Long sscId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        ORM orm = ORM.create();
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscId);
        QFilter poolTypeFilter = null;
        String alogKey = ExpenseBoardApiServiceUtil.class + ".getTaskAmountWithFilters() ";
        try (DataSet retDs = null;){
            if (poolTypeList.contains(TaskPoolTypeEnum.COMPLETE.getValue())) {
                poolTypeFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
                QFilter outDateFilter = new QFilter("expirestate", "=", (Object)Expirestate.Yes.getValue());
                QFilter[] filters = new QFilter[]{poolTypeFilter, shareCenterFilter, outDateFilter};
                retDs = QueryServiceHelper.queryDataSet((String)(alogKey + "_0"), (String)entityName, (String)"id", (QFilter[])filters, null);
                int expireCount = retDs.count("id", true);
                retMap.put("avgValue", 0);
                retMap.put("currentValue", expireCount);
                retMap.put("maxValue", 200);
            } else {
                poolTypeFilter = new QFilter("pooltype", "in", poolTypeList);
                retDs = orm.queryDataSet(algoPrefix + poolTypeList, entityName, "id", new QFilter[]{poolTypeFilter, shareCenterFilter});
                long currentCount = retDs.count("id", false);
                retMap.put("avgValue", 0);
                retMap.put("currentValue", currentCount);
                if (poolTypeList.contains(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue())) {
                    retMap.put("maxValue", 2000);
                } else {
                    retMap.put("maxValue", 1500);
                }
            }
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> getTaskAmountWithDateRange(String dateFlag, Long sscId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Map<String, Date> dateMap = ExpenseBoardApiServiceUtil.getDayRange(dateFlag);
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscId);
        Date startDate = dateMap.get("startDate");
        Date endDate = dateMap.get("endDate");
        QFilter completetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        ORM orm = ORM.create();
        try (DataSet completetimeDataSet = null;){
            completetimeDataSet = orm.queryDataSet(algoPrefix2 + dateFlag, completentityName, "id", new QFilter[]{completetimeFilter, shareCenterFilter});
            int completetimeCount = completetimeDataSet.count("id", false);
            retMap.put("sum", completetimeCount);
            switch (dateFlag) {
                case "day": {
                    retMap.put("text", ResManager.loadKDString((String)"\u672c\u65e5\u5b8c\u6210\u4efb\u52a1\u6570", (String)"ExpenseBoardApiServiceUtil_3", (String)"ssc-task-ext", (Object[])new Object[0]));
                    return retMap;
                }
                case "month": {
                    retMap.put("text", ResManager.loadKDString((String)"\u672c\u6708\u5b8c\u6210\u4efb\u52a1\u6570", (String)"ExpenseBoardApiServiceUtil_4", (String)"ssc-task-ext", (Object[])new Object[0]));
                    return retMap;
                }
                case "year": {
                    retMap.put("text", ResManager.loadKDString((String)"\u672c\u5e74\u5b8c\u6210\u4efb\u52a1\u6570", (String)"ExpenseBoardApiServiceUtil_5", (String)"ssc-task-ext", (Object[])new Object[0]));
                    return retMap;
                }
            }
            return retMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getAllTaskAmountWithDateRangeWithRank(String dateFlag, int rows, Long sscId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Map<String, Date> dateMap = ExpenseBoardApiServiceUtil.getDayRange(dateFlag);
        Date startDate = dateMap.get("startDate");
        Date endDate = dateMap.get("endDate");
        QFilter completetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscId);
        QFilter processingFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter outOfDateFilter = new QFilter("expirestate", "=", (Object)Expirestate.Yes.getValue());
        DataSet allDataSet = null;
        DataSet taskDataSet = null;
        DataSet taskhistoryDataSet = null;
        DataSet completetimeDataSet = null;
        DataSet processingDataSet = null;
        DataSet expiredDataSet = null;
        DataSet partDs = null;
        DataSet partDs2 = null;
        DataSet partDs3 = null;
        DataSet unexpiredDataSet = null;
        DataSet retDs = null;
        String selectFields = "personid.id as personid, id";
        String completeSelectFields = "personid.id as xpersonid, id";
        String processingSlectFields = "personid.id as ypersonid, id";
        String expiredSelectFields = "personid.id as zpersonid, id";
        ORM orm = ORM.create();
        try {
            taskDataSet = QueryServiceHelper.queryDataSet((String)(algoPrefix7 + ".alltasks"), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{shareCenterFilter}, null);
            taskDataSet = taskDataSet.select(new String[]{"personid"}).groupBy(new String[]{"personid"}).finish();
            taskhistoryDataSet = QueryServiceHelper.queryDataSet((String)(algoPrefix7 + ".alltaskhistory"), (String)completentityName, (String)selectFields, (QFilter[])new QFilter[]{completetimeFilter, shareCenterFilter}, null);
            taskhistoryDataSet = taskhistoryDataSet.select(new String[]{"personid"}).groupBy(new String[]{"personid"}).finish();
            allDataSet = taskDataSet.union(taskhistoryDataSet);
            completetimeDataSet = orm.queryDataSet(algoPrefix7 + dateFlag, completentityName, completeSelectFields, new QFilter[]{completetimeFilter, shareCenterFilter});
            completetimeDataSet = completetimeDataSet.select(new String[]{"xpersonid", "id"}).groupBy(new String[]{"xpersonid"}).count("completetaskcount").finish();
            completetimeDataSet = completetimeDataSet.select(new String[]{"xpersonid", "completetaskcount"});
            partDs = allDataSet.join(completetimeDataSet, JoinType.LEFT).on("personid", "xpersonid").select(new String[]{"personid", "(case when completetaskcount is null then 0 else completetaskcount end) as completetaskcount"}).finish();
            processingDataSet = QueryServiceHelper.queryDataSet((String)(algoPrefix7 + ".processing"), (String)entityName, (String)processingSlectFields, (QFilter[])new QFilter[]{processingFilter, shareCenterFilter}, null);
            processingDataSet = processingDataSet.select(new String[]{"ypersonid", "id"}).groupBy(new String[]{"ypersonid"}).count("processingtaskcount").finish();
            processingDataSet = processingDataSet.select(new String[]{"ypersonid", "processingtaskcount"});
            partDs2 = partDs.join(processingDataSet, JoinType.LEFT).on("personid", "ypersonid").select(new String[]{"personid", "completetaskcount", "(case when processingtaskcount is null then 0 else processingtaskcount end) as processingtaskcount"}).finish();
            expiredDataSet = QueryServiceHelper.queryDataSet((String)(algoPrefix7 + ".expired"), (String)entityName, (String)expiredSelectFields, (QFilter[])new QFilter[]{processingFilter, shareCenterFilter, outOfDateFilter}, null);
            expiredDataSet = expiredDataSet.select(new String[]{"zpersonid", "id"}).groupBy(new String[]{"zpersonid"}).count("expiredtaskcount").finish();
            expiredDataSet = expiredDataSet.select(new String[]{"zpersonid", "expiredtaskcount"});
            partDs3 = partDs2.join(expiredDataSet, JoinType.LEFT).on("personid", "zpersonid").select(new String[]{"personid", "completetaskcount", "processingtaskcount", "(case when expiredtaskcount is null then 0 else expiredtaskcount end) as expiredtaskcount"}).finish();
            unexpiredDataSet = partDs3.select(new String[]{"personid", "(processingtaskcount - expiredtaskcount) as unexpiredtaskcount"});
            retDs = partDs3.select(new String[]{"personid", "completetaskcount", "processingtaskcount", "expiredtaskcount", "(processingtaskcount - expiredtaskcount) as unexpiredtaskcount", "(completetaskcount + processingtaskcount) as alltaskcount"}).orderBy(new String[]{"alltaskcount desc"});
            ArrayList<String> xAxisDataList = new ArrayList<String>();
            ArrayList<Integer> achievedList = new ArrayList<Integer>();
            ArrayList<Integer> processingList = new ArrayList<Integer>();
            ArrayList<Integer> expiredList = new ArrayList<Integer>();
            int rowCount = 0;
            HashSet<Long> personIdSet = new HashSet<Long>();
            for (Row row : retDs) {
                Long personid = row.getLong("personid");
                if (personid == null || personid == 0L || rowCount >= rows || !personIdSet.add(personid)) continue;
                String name = ExpenseBoardApiServiceUtil.getUserName(personid);
                Integer completetaskcount = row.getInteger("completetaskcount");
                Integer unexpiredtaskcount = row.getInteger("unexpiredtaskcount");
                Integer expiredtaskcount = row.getInteger("expiredtaskcount");
                xAxisDataList.add(name);
                achievedList.add(completetaskcount);
                processingList.add(unexpiredtaskcount);
                expiredList.add(expiredtaskcount);
                ++rowCount;
            }
            HashMap<String, ArrayList<String>> xAxisDataMap = new HashMap<String, ArrayList<String>>();
            HashMap<String, ArrayList<Integer>> achievedMap = new HashMap<String, ArrayList<Integer>>();
            HashMap<String, ArrayList<Integer>> processingMap = new HashMap<String, ArrayList<Integer>>();
            HashMap<String, ArrayList<Integer>> expiredMap = new HashMap<String, ArrayList<Integer>>();
            HashMap dataMap = new HashMap();
            ArrayList<HashMap<String, ArrayList<Integer>>> dataList = new ArrayList<HashMap<String, ArrayList<Integer>>>();
            ArrayList<HashMap<String, ArrayList<String>>> progressList = new ArrayList<HashMap<String, ArrayList<String>>>();
            xAxisDataMap.put("xAxisData", xAxisDataList);
            achievedMap.put("achieved", achievedList);
            processingMap.put("processing", processingList);
            expiredMap.put("expired", expiredList);
            dataList.add(achievedMap);
            dataList.add(processingMap);
            dataList.add(expiredMap);
            dataMap.put("data", dataList);
            progressList.add(xAxisDataMap);
            progressList.add(dataMap);
            retMap.put("progress", progressList);
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.ExpenseBoardApiServiceHelper.getAllTaskAmountWithDateRangeWithRank", (Throwable)e);
        }
        finally {
            if (allDataSet != null) {
                allDataSet.close();
            }
            if (taskDataSet != null) {
                taskDataSet.close();
            }
            if (taskhistoryDataSet != null) {
                taskhistoryDataSet.close();
            }
            if (completetimeDataSet != null) {
                completetimeDataSet.close();
            }
            if (processingDataSet != null) {
                processingDataSet.close();
            }
            if (expiredDataSet != null) {
                expiredDataSet.close();
            }
            if (partDs != null) {
                partDs.close();
            }
            if (partDs2 != null) {
                partDs2.close();
            }
            if (partDs3 != null) {
                partDs3.close();
            }
            if (unexpiredDataSet != null) {
                unexpiredDataSet.close();
            }
            if (retDs != null) {
                retDs.close();
            }
        }
        return retMap;
    }

    private static Map<String, Object> getDifferentRangeCompleteTaskMap(Long sscId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        Map<String, Object> dayMap = ExpenseBoardApiServiceUtil.getTaskAmountWithDateRange(FLAG_DAY, sscId);
        Map<String, Object> monthMap = ExpenseBoardApiServiceUtil.getTaskAmountWithDateRange(FLAG_MONTH, sscId);
        Map<String, Object> yearMap = ExpenseBoardApiServiceUtil.getTaskAmountWithDateRange(FLAG_YEAR, sscId);
        listMap.add(dayMap);
        listMap.add(monthMap);
        listMap.add(yearMap);
        retMap.put("task", listMap);
        return retMap;
    }

    private static Map<String, Object> getMonthTaskRankMap(String dateFlag, Long sscId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Map<String, Date> dateMap = ExpenseBoardApiServiceUtil.getDayRange(dateFlag);
        Date startDate = dateMap.get("startDate");
        Date endDate = dateMap.get("endDate");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscId);
        QFilter receivetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter pooltypeFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        QFilter pooltypeUnauto = new QFilter("autoprocess", "=", (Object)"0");
        qfList.add(shareCenterFilter);
        qfList.add(receivetimeFilter);
        qfList.add(pooltypeFilter);
        qfList.add(pooltypeUnauto);
        log.info("\u8d39\u7528\u770b\u677f\uff1a" + qfList);
        String selectFields = "personid.id as personid, pooltype, coefficient, costwaittime";
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoPrefix3, (String)completentityName, (String)selectFields, (QFilter[])qfList.toArray(new QFilter[qfList.size()]), null);
        ds = ds.select(new String[]{"personid", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "pooltype", "(case when costwaittime is null or costwaittime = 0 then 0.01 else costwaittime end) as costwaittime"}).groupBy(new String[]{"personid"}).count().sum("coefficient", "taskamount").sum("costwaittime").finish();
        ds = ds.select(new String[]{"personid", "count", "taskamount", "costwaittime", "cast(case when taskamount=0 then 0.0 else costwaittime/taskamount end as decimal) as taskefficiency"}).orderBy(new String[]{"count desc", "taskefficiency asc"});
        ArrayList retList = new ArrayList();
        ArrayList avgRetList = new ArrayList();
        HashMap<String, Number> avgMap = new HashMap<String, Number>();
        int i = 0;
        Long totalTaskCount = 0L;
        Long avgTaskCount = 0L;
        BigDecimal totalCostwaittime = new BigDecimal(0);
        BigDecimal avgTaskEfficiency = new BigDecimal(0);
        for (Row row : ds) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ++i;
            Long personid = row.getLong("personid");
            String name = ExpenseBoardApiServiceUtil.getUserName(personid);
            Integer taskcount = row.getInteger("taskamount");
            String taskefficiency = String.valueOf(row.get("taskefficiency"));
            BigDecimal bgtaskefficiency = new BigDecimal(taskefficiency).setScale(2, 4);
            String costwaittime = String.valueOf(row.get("costwaittime"));
            BigDecimal bgcostwaittime = new BigDecimal(costwaittime).setScale(2, 4);
            map.put("name", name);
            map.put("num", taskcount);
            map.put("speed", bgtaskefficiency);
            switch (i) {
                case 1: {
                    map.put("bg", IMAGE_PATH_RANK_FIRST);
                    break;
                }
                case 2: {
                    map.put("bg", IMAGE_PATH_RANK_SECOND);
                    break;
                }
                case 3: {
                    map.put("bg", IMAGE_PATH_RANK_THIRD);
                    break;
                }
                default: {
                    map.put("bg", IMAGE_PATH_RANK_DEFAULT);
                }
            }
            totalTaskCount = totalTaskCount + (long)taskcount.intValue();
            totalCostwaittime = totalCostwaittime.add(bgcostwaittime);
            retList.add(map);
        }
        avgTaskCount = i > 0 ? totalTaskCount / (long)i : 0L;
        if (totalTaskCount > 0L) {
            avgTaskEfficiency = totalCostwaittime.divide(new BigDecimal(totalTaskCount), 2, 4);
        }
        avgMap.put("avgtaskcount", avgTaskCount);
        avgMap.put("avgtaskefficiency", avgTaskEfficiency);
        avgRetList.add(avgMap);
        retMap.put("rank", retList);
        retMap.put("avgrank", avgRetList);
        retMap.put("account", Arrays.asList(RequestContext.get().getUserId(), sscId));
        return retMap;
    }

    private static Map<String, Date> getDayRange(String dateFlag) {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        try {
            Date nowDate = new Date();
            switch (dateFlag) {
                case "day": {
                    dateMap.put("startDate", DateUtil.getCurDateForm((Date)nowDate, (boolean)true));
                    dateMap.put("endDate", DateUtil.getCurDateForm((Date)nowDate, (boolean)false));
                    break;
                }
                case "month": {
                    Date firstDay = DateUtil.getFirstDayOfMonth((Date)nowDate);
                    dateMap.put("startDate", DateUtil.getCurDateForm((Date)firstDay, (boolean)true));
                    dateMap.put("endDate", nowDate);
                    break;
                }
                case "year": {
                    Date firstDay = DateUtil.getFirstDayOfYear((Date)nowDate);
                    dateMap.put("startDate", DateUtil.getCurDateForm((Date)firstDay, (boolean)true));
                    dateMap.put("endDate", nowDate);
                    break;
                }
            }
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return dateMap;
    }

    private static String getUserName(Long personId) {
        if (personId == null) {
            return null;
        }
        ORM orm = ORM.create();
        DynamicObject user = orm.getById(TABLE_BOS_USER, (Object)personId);
        if (user == null) {
            return null;
        }
        return user.getString("name");
    }
}

