/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class IncomeReceiptBoardApiServiceUtil {
    private static final Log log = LogFactory.getLog(IncomeReceiptBoardApiServiceUtil.class);
    private static final String TABLE_INCOMERECEIPT = "task_incomereceipt";
    private static final String algoPrefix = "kd.ssc.task.util.IncomeReceiptBoardApiServiceUtil";

    public static Map<String, Map<String, Object>> getIncomeReceiptBoardData() {
        HashMap<String, Map<String, Object>> retMap = new HashMap<String, Map<String, Object>>();
        List<Integer> patBizTypes = Arrays.asList(0, 1, 2, 3, 4, 5, 6);
        Integer sumBizType = 99;
        Map<String, Map<String, Object>> partMap = IncomeReceiptBoardApiServiceUtil.getPartRecordData(patBizTypes);
        Map<String, Map<String, Object>> sumMap = IncomeReceiptBoardApiServiceUtil.getSumRecordData(sumBizType);
        retMap.putAll(partMap);
        retMap.putAll(sumMap);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, Object>> getPartRecordData(List<Integer> bizTypes) {
        HashMap<String, Map<String, Object>> retMap = new HashMap<String, Map<String, Object>>();
        ORM orm = ORM.create();
        QFilter biztypeQF = new QFilter("biztype", "in", bizTypes);
        String selectFields = "id,biztype,unvouchercount,voucheredcount,completionrate";
        try (DataSet retDs = null;){
            retDs = orm.queryDataSet(algoPrefix, TABLE_INCOMERECEIPT, selectFields, new QFilter[]{biztypeQF});
            if (retDs == null) {
                HashMap<String, Map<String, Object>> hashMap = retMap;
                return hashMap;
            }
            for (Row row : retDs) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                Integer biztype = row.getInteger("biztype");
                Integer unvouchercount = row.getInteger("unvouchercount");
                Integer voucheredcount = row.getInteger("voucheredcount");
                Integer completionrate = row.getInteger("completionrate");
                String tagName = IncomeReceiptBoardApiServiceUtil.getTagName(biztype);
                String bizTypeName = IncomeReceiptBoardApiServiceUtil.getBizTypeName(biztype);
                dataMap.put("titleName", bizTypeName);
                dataMap.put("unCreated", unvouchercount);
                dataMap.put("hasCreated", voucheredcount);
                dataMap.put("completedPer", completionrate);
                retMap.put(tagName, dataMap);
            }
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, Object>> getSumRecordData(Integer bizType) {
        HashMap<String, Map<String, Object>> retMap = new HashMap<String, Map<String, Object>>();
        ORM orm = ORM.create();
        QFilter biztypeQF = new QFilter("biztype", "=", (Object)bizType);
        String selectFields = "id,periodtype,biztype,unvouchercount,voucheredcount";
        try (DataSet retDs = null;){
            retDs = orm.queryDataSet(algoPrefix, TABLE_INCOMERECEIPT, selectFields, new QFilter[]{biztypeQF});
            if (retDs == null) {
                HashMap<String, Map<String, Object>> hashMap = retMap;
                return hashMap;
            }
            String tagName = IncomeReceiptBoardApiServiceUtil.getTagName(bizType);
            String bizTypeName = IncomeReceiptBoardApiServiceUtil.getBizTypeName(bizType);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("name", bizTypeName);
            for (Row row : retDs) {
                Integer periodtype = row.getInteger("periodtype");
                Integer voucheredcount = row.getInteger("voucheredcount");
                if (periodtype == 0) {
                    dataMap.put("unCreated", voucheredcount);
                    continue;
                }
                dataMap.put("hasCreated", voucheredcount);
            }
            retMap.put(tagName, dataMap);
        }
        return retMap;
    }

    private static String getBizTypeName(Integer bizType) {
        String name = null;
        switch (bizType) {
            case 0: {
                name = ResManager.loadKDString((String)"\u76f4\u9500\u6536\u6b3e\u5904\u7406\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_0", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 1: {
                name = ResManager.loadKDString((String)"\u5206\u9500\u6536\u6b3e\u5904\u7406\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_1", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 2: {
                name = ResManager.loadKDString((String)"\u7a0e\u52a1\u6536\u5165\u5904\u7406\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_2", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 3: {
                name = ResManager.loadKDString((String)"\u5206\u9500\u6536\u5165\u5904\u7406\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_3", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 4: {
                name = ResManager.loadKDString((String)"\u51fa\u5e93\u5355\u5904\u7406\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_4", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 5: {
                name = ResManager.loadKDString((String)"\u5165\u5e93\u5355\u5904\u7406\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_5", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 6: {
                name = ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5ba1\u6838\u60c5\u51b5", (String)"IncomeReceiptBoardApiServiceUtil_6", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
            case 99: {
                name = ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b8c\u6210\u91cf", (String)"IncomeReceiptBoardApiServiceUtil_7", (String)"ssc-task-ext", (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }

    private static String getTagName(Integer bizType) {
        String name = null;
        switch (bizType) {
            case 0: {
                name = "straightObj";
                break;
            }
            case 1: {
                name = "fenxiaoInMObj";
                break;
            }
            case 2: {
                name = "inTaxObj";
                break;
            }
            case 3: {
                name = "fenxiaoInObj";
                break;
            }
            case 4: {
                name = "outStoreObj";
                break;
            }
            case 5: {
                name = "inStoreObj";
                break;
            }
            case 6: {
                name = "shouldPayObj";
                break;
            }
            case 99: {
                name = "addWorkObj";
                break;
            }
        }
        return name;
    }
}

