/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.user.UserServiceHelper;

public class AchieveDeptUpgradeServiceImpl
implements IUpgradeService {
    private static final String DEPT_NULL_ACHIEVE_EVALUATE = "select fid,fassessuserid from t_tk_achieveevalute where fassessdimension = '2' and fdept = 0";
    private static final String DEPT_NULL_EXTRAPOINT = "select fid,fuserid from t_tk_extrapoints where fdept = 0";
    private static final String UPDATE_ACHIEVE_EVALUATE_DEPT = "update t_tk_achieveevalute set fdept = ? where fid = ?";
    private static final String UPDATE_EXTRA_POINT_DEPT = "update t_tk_extrapoints set fdept = ? where fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Object[]> reportParams = new ArrayList<Object[]>(10);
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.achieve.upAchieveDeptData", (DBRoute)DBRoute.of((String)"ssc"), (String)DEPT_NULL_ACHIEVE_EVALUATE);){
            while (ds.hasNext()) {
                long userMainOrgId;
                Row row = ds.next();
                long userId = row.getLong("fassessuserid");
                long fid = row.getLong("fid");
                if (userId == 0L || (userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId)) == 0L) continue;
                reportParams.add(new Object[]{userMainOrgId, fid});
            }
        }
        if (reportParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_ACHIEVE_EVALUATE_DEPT, reportParams);
        }
        ArrayList<Object[]> extraParams = new ArrayList<Object[]>(10);
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.achieve.upExtrapointData", (DBRoute)DBRoute.of((String)"ssc"), (String)DEPT_NULL_EXTRAPOINT);){
            while (ds.hasNext()) {
                long userMainOrgId;
                Row row = ds.next();
                long userId = row.getLong("fuserid");
                long fid = row.getLong("fid");
                if (userId == 0L || (userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId)) == 0L) continue;
                extraParams.add(new Object[]{userMainOrgId, fid});
            }
        }
        if (extraParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_EXTRA_POINT_DEPT, extraParams);
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }
}

