/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class AchieveTargetUpgradeServiceImpl
implements IUpgradeService {
    private static Map<Long, Long> idNewKindMap = new HashMap<Long, Long>(4);
    private static final String INDIVIDUATION_TARGET_QUERY = "select fid,fmasterid from t_tk_achievetarget where fid != fmasterid and fmasterid in (1265197028707835904,1265198320863844352,1265197756159531008,1265197999445942272)";
    private static final String TARGET_QUERY = "select fid,fparentid from t_tk_achievetarget";
    private static final String UPDATE_GROUP = "update t_tk_achievetarget set fgroupid = ? where fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.AchieveTargetUpGradeServiceImpl.individuationQuery", (DBRoute)DBRoute.of((String)"ssc"), (String)INDIVIDUATION_TARGET_QUERY);){
            ds.forEach(row -> {
                Long fid = row.getLong("fid");
                Long masterId = row.getLong("fmasterid");
                Long targetGroupId = idNewKindMap.get(masterId);
                if (targetGroupId != null) {
                    idNewKindMap.put(fid, targetGroupId);
                }
            });
        }
        ArrayList paramList = new ArrayList();
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.AchieveTargetUpGradeServiceImpl.queryAllTarget", (DBRoute)DBRoute.of((String)"ssc"), (String)TARGET_QUERY);){
            ds.forEach(row -> {
                Long fid = row.getLong("fid");
                Long parentId = row.getLong("fparentid");
                Long targetGroupId = idNewKindMap.get(parentId);
                if (targetGroupId != null) {
                    paramList.add(new Object[]{targetGroupId, fid});
                }
            });
        }
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_GROUP, paramList);
        }
        if (idNewKindMap.size() > 0) {
            String condition = StringUtils.join((Object[])idNewKindMap.keySet().toArray(), (String)",");
            String delSql = "delete from t_tk_achievetarget where fid in (%s)";
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)String.format(delSql, condition), (Object[])new Object[0]);
        }
        result.setSuccess(true);
        return result;
    }

    static {
        idNewKindMap.put(1265197028707835904L, 1716567382384048128L);
        idNewKindMap.put(1265198320863844352L, 1716567142503413760L);
        idNewKindMap.put(1265197756159531008L, 1716564493422703616L);
        idNewKindMap.put(1265197999445942272L, 1716566900206860288L);
    }
}

