/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class CreditFilesCompanyUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!this.hasFileDataToUpgrade()) {
            result.setLog(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848\u516c\u53f8\u5b57\u6bb5\u6ca1\u6709\u6570\u636e\u9700\u8981\u8fc1\u79fb", (String)"CreditFilesCompanyUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
            result.setSuccess(true);
            return result;
        }
        if (this.hasFileDataToUpgrade()) {
            int maxSize = 1000;
            QFilter filter = new QFilter("company", "=", (Object)0);
            int count = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"task_creditfiles", (String)"id", (QFilter[])new QFilter[]{filter}, null).count("id", false);
            for (int pageIndex = 0; count > 0 && pageIndex <= count / maxSize; ++pageIndex) {
                int pageSize = maxSize;
                int sub = count - pageIndex * maxSize;
                if (sub < maxSize) {
                    pageSize = sub;
                }
                this.updateCreditFile(pageIndex, pageSize);
            }
        }
        result.setLog(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848\u516c\u53f8\u5b57\u6bb5\u6570\u636e\u8fc1\u79fb\u6210\u529f", (String)"CreditFilesCompanyUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private void updateCreditFile(int pageIndex, int pageSize) {
        QFilter filter = new QFilter("company", "=", (Object)0);
        DynamicObject[] files = BusinessDataServiceHelper.load((String)"task_creditfiles", (String)"id,user,company", (QFilter[])new QFilter[]{filter}, (String)"id asc", (int)pageIndex, (int)pageSize);
        HashSet userIds = new HashSet();
        Arrays.stream(files).forEach(file -> {
            Object user = file.get("user");
            if (user != null) {
                userIds.add(((DynamicObject)user).getLong("id"));
            }
        });
        Map companysOfUsers = UserServiceHelper.getCompanyByUserIds(new ArrayList(userIds));
        if (!companysOfUsers.isEmpty()) {
            Arrays.stream(files).forEach(file -> {
                Object user = file.get("user");
                if (user != null) {
                    file.set("company", companysOfUsers.get(((DynamicObject)user).getLong("id")));
                }
            });
            SaveServiceHelper.save((DynamicObject[])files);
        }
    }

    private boolean hasFileDataToUpgrade() {
        QFilter filter = new QFilter("company", "=", (Object)0);
        return QueryServiceHelper.exists((String)"task_creditfiles", (QFilter[])new QFilter[]{filter});
    }
}

