/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.ssc.enums.ImageDefaultConfigEnum;

public class ImageStrategyUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_SQL0 = "select top 1 fnumber, fimagesystermip, fimageport, fimageurl from t_bas_imageconfig where fenable='A'";
    private static final String QUERY_SQL1 = "select top 1 fnumber from t_tk_billimagemap where fimagestate<>'0'";
    private static final String UPDATE_SQL = "update t_bas_imagestrategy set fenable='0' where fnumber='001' and fenable='1'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";
        List<Object[]> imageSystemConfigList = this.getEnableImageSystem(algoKey);
        if (imageSystemConfigList.isEmpty()) {
            return this.getSuccessResult();
        }
        Object[] imageSystemConfig = imageSystemConfigList.get(0);
        String currentConfig = this.getCurrentImageConfig(imageSystemConfig);
        String defaultConfig = ImageDefaultConfigEnum.getValue((String)(imageSystemConfig[0] + ""));
        boolean defaultConfigNotChange = StringUtils.equals((CharSequence)defaultConfig, (CharSequence)currentConfig);
        if (defaultConfigNotChange && !this.existImageState(algoKey)) {
            return this.updateImageStrategy();
        }
        return this.getSuccessResult();
    }

    private UpgradeResult updateImageStrategy() {
        try (TXHandle h = TX.requiresNew((String)"ssc_task_image_strategy_update");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)UPDATE_SQL);
            }
            catch (Throwable e) {
                h.markRollback();
                UpgradeResult upgradeResult = this.getFailResult(e);
                if (h != null) {
                    if (var2_2 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        return this.getSuccessResult();
    }

    private List<Object[]> getEnableImageSystem(String algoKey) {
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_SQL0);){
            ArrayList<Object[]> imageSystemConfigList = new ArrayList<Object[]>(16);
            for (Row row : resultSet) {
                Object[] paramArr = new Object[8];
                paramArr[0] = row.get("fnumber");
                paramArr[1] = row.get("fimagesystermip");
                paramArr[2] = row.get("fimageport");
                paramArr[3] = row.get("fimageurl");
                imageSystemConfigList.add(paramArr);
            }
            ArrayList<Object[]> arrayList = imageSystemConfigList;
            return arrayList;
        }
    }

    private String getCurrentImageConfig(Object[] currentConfig) {
        String number = currentConfig[0] + "";
        String ip = currentConfig[1] + "";
        String port = currentConfig[2] + "";
        String url = currentConfig[3] + "";
        return String.join((CharSequence)number, ip, port, url);
    }

    private boolean existImageState(String algoKey) {
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_1"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL1);){
            if (resultSet.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private UpgradeResult getSuccessResult() {
        UpgradeResult result = new UpgradeResult();
        result.setLog(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\u751f\u6210\u7b56\u7565\u5347\u7ea7\u6210\u529f", (String)"ImageStrategyUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private UpgradeResult getFailResult(Throwable e) {
        UpgradeResult result = new UpgradeResult();
        result.setErrorInfo(e.getMessage());
        result.setLog(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\u751f\u6210\u7b56\u7565\u5347\u7ea7\u5931\u8d25", (String)"ImageStrategyUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(false);
        return result;
    }
}

