/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.mulilang.GLDataServiceHelper;
import kd.bos.util.ExceptionUtils;

public class MultilingualFieldUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String defaultLocaleId = GLDataServiceHelper.getDefaultLocaleId();
            this.repairCheckPointData(defaultLocaleId);
            this.repairDisruleData(defaultLocaleId);
            this.repairMainBillData(defaultLocaleId);
            this.repairTaskLevelNameData(defaultLocaleId);
            this.repairTaskLevelExplanationData(defaultLocaleId);
            this.repairTaskTypeData(defaultLocaleId);
            this.repairUserGroupData(defaultLocaleId);
            this.repairWithDrawalData(defaultLocaleId);
            this.repairBilliMageNameData(defaultLocaleId);
            this.repairBilliMageDescData(defaultLocaleId);
            this.repairCreditArgData(defaultLocaleId);
            this.repairCreditArgExplanData(defaultLocaleId);
            this.repairTaskSubjectData(defaultLocaleId);
            this.repairUnQualifiedData(defaultLocaleId);
            this.repairCtraDetailsData(defaultLocaleId);
            this.repairSerBillNameData(defaultLocaleId);
            this.repairSerBillContractNameData(defaultLocaleId);
            this.repairSerContractData(defaultLocaleId);
            this.repairIndicatorsGroupData(defaultLocaleId);
            this.repairAreaData(defaultLocaleId);
            this.repairAreaDescData(defaultLocaleId);
            this.repairDetailNameData(defaultLocaleId);
            this.repairDetailKeyWordData(defaultLocaleId);
            this.repairDetailAnswerData(defaultLocaleId);
            this.repairDetailLinkData(defaultLocaleId);
            this.repairDetailQuestionData(defaultLocaleId);
            this.repairDetailSimilarquesData(defaultLocaleId);
            this.repairLeadWordData(defaultLocaleId);
            this.repairLeadNameData(defaultLocaleId);
            this.repairExtCaseData(defaultLocaleId);
            this.repairCreditBoardData(defaultLocaleId);
            this.repairAlgorithmNameData(defaultLocaleId);
            this.repairAlgorithmDescData(defaultLocaleId);
            this.repairAppvopinionNameData(defaultLocaleId);
            this.repairAppvopinionFullNameData(defaultLocaleId);
            this.repairAppvopinionOpinionData(defaultLocaleId);
            this.repairBillClassifyData(defaultLocaleId);
            this.repairBizTypeData(defaultLocaleId);
            this.repairCreditQualityData(defaultLocaleId);
            this.repairCreditWithdrawalData(defaultLocaleId);
            this.repairPartaskflowData(defaultLocaleId);
            this.repairPendingReasonData(defaultLocaleId);
            this.repairQualityChecksData(defaultLocaleId);
            this.repairSatisFiedNameData(defaultLocaleId);
            this.repairSatisFiedData(defaultLocaleId);
            this.repairRescanReasonData(defaultLocaleId);
            this.repairSmartChecksData(defaultLocaleId);
            this.repairTaskBillImptData(defaultLocaleId);
            result.setSuccess(true);
            result.setLog(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u5b57\u6bb5\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u3002", (String)"MultilingualFieldUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setLog(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u5b57\u6bb5\u6570\u636e\u5347\u7ea7\u5931\u8d25\u3002", (String)"MultilingualFieldUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void repairCheckPointData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_checkpoint a inner join t_tk_checkpoint_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCheckPointData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_checkpoint set fname = ? where fid = ?", upParams);
        }
    }

    private void repairDisruleData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_disrule_new a inner join t_tk_disrule_new_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDisruleData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_disrule_new set fname = ? where fid = ?", upParams);
        }
    }

    private void repairMainBillData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_taskmainbill a inner join t_tk_taskmainbill_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !=''  ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairMainBillData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_taskmainbill set fname = ? where fid = ?", upParams);
        }
    }

    private void repairTaskLevelNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_tasklevel a inner join t_tk_tasklevel_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairTaskLevelNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_tasklevel set fname = ? where fid = ?", upParams);
        }
    }

    private void repairTaskLevelExplanationData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fexplanation from t_tk_tasklevel a inner join t_tk_tasklevel_l b on a.fid = b.fid where (a.fexplanation = '' or a.fexplanation = ' ') and b.fexplanation !=' ' and b.fexplanation!='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairTaskLevelExplanationData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fexplanation");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_tasklevel set fexplanation = ? where fid = ?", upParams);
        }
    }

    private void repairTaskTypeData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_taskType a inner join t_tk_taskType_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairTaskTypeData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_taskType set fname = ? where fid = ?", upParams);
        }
    }

    private void repairUserGroupData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_usergroup a inner join t_tk_usergroup_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairUserGroupData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_usergroup set fname = ? where fid = ?", upParams);
        }
    }

    private void repairWithDrawalData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_withdrawal a inner join t_tk_withdrawal_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairWithDrawalData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_withdrawal set fname = ? where fid = ?", upParams);
        }
    }

    private void repairBilliMageNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from T_tk_billimagemap a inner join T_tk_billimagemap_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairBilliMagemapData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update T_tk_billimagemap set fname = ? where fid = ?", upParams);
        }
    }

    private void repairBilliMageDescData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdescription from T_tk_billimagemap a inner join T_tk_billimagemap_l b on a.fid = b.fid where (a.fdescription = '' or a.fdescription = ' ')  and b.fdescription !=' ' and b.fdescription !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairBilliMageDescData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fdescription");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update T_tk_billimagemap set fdescription = ? where fid = ?", upParams);
        }
    }

    private void repairCreditArgData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_creditarg a inner join t_tk_creditarg_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditArgData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditarg set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditArgExplanData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fexplanation from t_tk_creditarg a inner join t_tk_creditarg_l b on a.fid = b.fid where (a.fexplanation = '' or a.fexplanation = ' ') and b.fexplanation !=' ' and b.fexplanation !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditArgExplanData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fexplanation");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditarg set fexplanation = ? where fid = ?", upParams);
        }
    }

    private void repairTaskSubjectData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from T_tk_TaskSubject a inner join T_tk_TaskSubject_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairTaskSubjectData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update T_tk_TaskSubject set fname = ? where fid = ?", upParams);
        }
    }

    private void repairUnQualifiedData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_unqualifiedreason a inner join t_tk_unqualifiedreason_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairUnQualifiedData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_unqualifiedreason set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCtraDetailsData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_sla_ctradetails a inner join t_tk_sla_ctradetails_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCtraDetailsData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_sla_ctradetails set fname = ? where fid = ?", upParams);
        }
    }

    private void repairSerBillNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_sla_serbill a inner join t_tk_sla_serbill_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairSerBillNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_sla_serbill set fname = ? where fid = ?", upParams);
        }
    }

    private void repairSerBillContractNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fcontractname from t_tk_sla_serbill a inner join t_tk_sla_serbill_l b on a.fid = b.fid where (a.fcontractname = '' or a.fcontractname = ' ') and b.fcontractname !=' ' and b.fcontractname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairSerBillContractNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fcontractname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_sla_serbill set fcontractname = ? where fid = ?", upParams);
        }
    }

    private void repairSerContractData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_sla_sercontract a inner join t_tk_sla_sercontract_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairSerContractData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_sla_sercontract set fname = ? where fid = ?", upParams);
        }
    }

    private void repairIndicatorsGroupData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_indicatorsgroup a inner join t_tk_indicatorsgroup_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairIndicatorsGroupData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_indicatorsgroup set fname = ? where fid = ?", upParams);
        }
    }

    private void repairAreaData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_scs_area a inner join t_tk_scs_area_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAreaData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_area set fname = ? where fid = ?", upParams);
        }
    }

    private void repairAreaDescData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdescription from t_tk_scs_area a inner join t_tk_scs_area_l b on a.fid = b.fid where (a.fdescription = '' or a.fdescription = ' ') and b.fdescription !=' ' and b.fdescription !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAreaDescData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fdescription");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_area set fdescription = ? where fid = ?", upParams);
        }
    }

    private void repairDetailNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_scs_detail a inner join t_tk_scs_detail_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDetailNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_detail set fname = ? where fid = ?", upParams);
        }
    }

    private void repairDetailKeyWordData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fkeyword from t_tk_scs_detail a inner join t_tk_scs_detail_l b on a.fid = b.fid where (a.fkeyword = '' or a.fkeyword = ' ') and b.fkeyword !=' ' and b.fkeyword !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDetailKeyWordData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fkeyword");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_detail set fkeyword = ? where fid = ?", upParams);
        }
    }

    private void repairDetailAnswerData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fanswer from t_tk_scs_detail a inner join t_tk_scs_detail_l b on a.fid = b.fid where (a.fanswer = '' or a.fanswer = ' ') and b.fanswer !=' ' and b.fanswer !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDetailAnswerData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fanswer");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_detail set fanswer = ? where fid = ?", upParams);
        }
    }

    private void repairDetailLinkData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.flinktitle from t_tk_scs_detail a inner join t_tk_scs_detail_l b on a.fid = b.fid where (a.flinktitle = '' or a.flinktitle = ' ') and b.flinktitle !=' ' and b.flinktitle !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDetailLinkData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("flinktitle");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_detail set flinktitle = ? where fid = ?", upParams);
        }
    }

    private void repairDetailQuestionData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fquestion from t_tk_scs_detail a inner join t_tk_scs_detail_l b on a.fid = b.fid where (a.fquestion = '' or a.fquestion = ' ') and b.fquestion !=' ' and b.fquestion !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDetailQuestionData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fquestion");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_detail set fquestion = ? where fid = ?", upParams);
        }
    }

    private void repairDetailSimilarquesData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fentryid,b.fsimilarques from t_tk_scs_simques a inner join t_tk_scs_simques_l b on a.fentryid = b.fentryid where (a.fsimilarques = '' or a.fsimilarques = ' ') and b.fsimilarques !=' ' and b.fsimilarques !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairDetailSimilarquesData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fsimilarques");
                long id = row.getLong("fentryid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_simques set fsimilarques = ? where fentryid = ?", upParams);
        }
    }

    private void repairLeadWordData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_scs_leadword a inner join t_tk_scs_leadword_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairLeadWordData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_leadword set fname = ? where fid = ?", upParams);
        }
    }

    private void repairLeadNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fentryid,b.fleadname from t_tk_scs_lwentry a inner join t_tk_scs_lwentry_l b on a.fentryid = b.fentryid where (a.fleadname = '' or a.fleadname = ' ') and b.fleadname !=' ' and b.fleadname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairLeadNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fleadname");
                long id = row.getLong("fentryid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_scs_lwentry set fleadname = ? where fentryid = ?", upParams);
        }
    }

    private void repairExtCaseData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdescription from t_tk_bizextcase a inner join t_tk_bizextcase_l b on a.fid = b.fid where (a.fdescription = '' or a.fdescription = ' ') and b.fdescription !=' ' and b.fdescription !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairExtCaseData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fdescription");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_bizextcase set fdescription = ? where fid = ?", upParams);
        }
    }

    private void repairCreditBoardData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fentryid,b.fbiztypename from t_tk_creditboard_detail a inner join t_tk_creditboard_detail_l b on a.fentryid = b.fentryid where (a.fbiztypename = '' or a.fbiztypename = ' ') and b.fbiztypename !=' ' and b.fbiztypename !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditBoardData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fbiztypename");
                long id = row.getLong("fentryid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditboard_detail set fbiztypename = ? where fentryid = ?", upParams);
        }
    }

    private void repairAlgorithmNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_approve_algorithm a inner join t_tk_approve_algorithm_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAlgorithmNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_approve_algorithm set fname = ? where fid = ?", upParams);
        }
    }

    private void repairAlgorithmDescData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdescription from t_tk_approve_algorithm a inner join t_tk_approve_algorithm_l b on a.fid = b.fid where (a.fdescription = '' or a.fdescription = ' ') and b.fdescription !=' ' and b.fdescription !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAlgorithmDescData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fdescription");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_approve_algorithm set fdescription = ? where fid = ?", upParams);
        }
    }

    private void repairAppvopinionNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_appvopinion a inner join t_tk_appvopinion_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAppvopinionNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_appvopinion set fname = ? where fid = ?", upParams);
        }
    }

    private void repairAppvopinionFullNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.ffullname from t_tk_appvopinion a inner join t_tk_appvopinion_l b on a.fid = b.fid where (a.ffullname = '' or a.ffullname = ' ') and b.ffullname !=' ' and b.ffullname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAppvopinionFullNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("ffullname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_appvopinion set ffullname = ? where fid = ?", upParams);
        }
    }

    private void repairAppvopinionOpinionData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fopinions from t_tk_appvopinion a inner join t_tk_appvopinion_l b on a.fid = b.fid where (a.fopinions = '' or a.fopinions = ' ') and b.fopinions !=' ' and b.fopinions !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairAppvopinionOpinionData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fopinions");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_appvopinion set fopinions = ? where fid = ?", upParams);
        }
    }

    private void repairBillClassifyData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.ffullname from t_tk_billclassify a inner join t_tk_billclassify_l b on a.fid = b.fid where (a.ffullname = '' or a.ffullname = ' ') and b.ffullname !=' ' and b.ffullname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairBillClassifyData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("ffullname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_billclassify set ffullname = ? where fid = ?", upParams);
        }
    }

    private void repairBizTypeData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_biztype a inner join t_tk_biztype_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairBizTypeData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_biztype set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditQualityData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_creditbyquality a inner join t_tk_creditbyquality_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditQualityData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditbyquality set fname = ? where fid = ?", upParams);
        }
    }

    private void repairCreditWithdrawalData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_creditbywithdrawal a inner join t_tk_creditbywithdrawal_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairCreditWithdrawalData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_creditbywithdrawal set fname = ? where fid = ?", upParams);
        }
    }

    private void repairPartaskflowData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_partaskflowdef a inner join t_tk_partaskflowdef_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairPartaskflowData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_partaskflowdef set fname = ? where fid = ?", upParams);
        }
    }

    private void repairPendingReasonData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_pendingreason a inner join t_tk_pendingreason_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairPendingReasonData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_pendingreason set fname = ? where fid = ?", upParams);
        }
    }

    private void repairQualityChecksData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_qualitycheckscheme a inner join t_tk_qualitycheckscheme_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairQualityChecksData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_qualitycheckscheme set fname = ? where fid = ?", upParams);
        }
    }

    private void repairSatisFiedNameData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_satisfiedquestion a inner join t_tk_satisfiedquestion_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairSatisFiedNameData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_satisfiedquestion set fname = ? where fid = ?", upParams);
        }
    }

    private void repairSatisFiedData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fdelivertype from t_tk_satisfiedquestion a inner join t_tk_satisfiedquestion_l b on a.fid = b.fid where (a.fdelivertype = '' or a.fdelivertype = ' ') and b.fdelivertype !=' ' and b.fdelivertype !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairSatisFiedData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fdelivertype");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_satisfiedquestion set fdelivertype = ? where fid = ?", upParams);
        }
    }

    private void repairRescanReasonData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_rescanreason a inner join t_tk_rescanreason_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairRescanReasonData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_rescanreason set fname = ? where fid = ?", upParams);
        }
    }

    private void repairSmartChecksData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_smartcheckscheme a inner join t_tk_smartcheckscheme_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairSmartChecksData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_smartcheckscheme set fname = ? where fid = ?", upParams);
        }
    }

    private void repairTaskBillImptData(String defaultLocaleId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname from t_tk_taskbill4impt a inner join t_tk_taskbill4impt_l b on a.fid = b.fid where (a.fname = '' or a.fname = ' ') and b.fname !=' ' and b.fname !='' ", new Object[0]);
        sqlBuilder.append("and b.flocaleid = ? ", new Object[]{defaultLocaleId});
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(32);
        try (DataSet dataSet = DB.queryDataSet((String)"repairTaskBillImptData", (DBRoute)DBRoute.of((String)"ssc"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String name = row.getString("fname");
                long id = row.getLong("fid");
                upParams.add(new Object[]{name, id});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_taskbill4impt set fname = ? where fid = ?", upParams);
        }
    }
}

