/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;

public class OrgRelationUpgradeServiceImpl
implements IUpgradeService {
    private static final long TO_RELATION_TYPE_ID = OrgRelationQueryHelper.UNIT2SSC_RELATION_TYPE_ID;
    private static final String QUERY_FROM = "SELECT ffromorgid, ftoorgid, fisdefaultfromorg, fisdefaulttoorg FROM t_org_orgrelation WHERE ftyperelationid = 460713649061769216";
    private static final String QUERY_TO = "SELECT ffromorgid, ftoorgid, fisdefaultfromorg, fisdefaulttoorg FROM t_org_orgrelation WHERE ftyperelationid = " + TO_RELATION_TYPE_ID;
    private static final String INSERT_RELATION = "INSERT INTO t_org_orgrelation (fid, ftyperelationid, ffromorgid, ftoorgid, fisdefaultfromorg, fisdefaulttoorg) VALUES (?, ?, ?, ?, ?, ?);";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        String routeKey = "kd.ssc.task.upgradeservice.OrgRelationUpgradeServiceImpl";
        HashMap<String, Object[]> fromRelations = new HashMap<String, Object[]>(256);
        try (DataSet ds = DB.queryDataSet((String)(routeKey + "_0"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_FROM);){
            for (Row row : ds) {
                Long fromOrg = row.getLong("ffromorgid");
                Long toOrg = row.getLong("ftoorgid");
                Object[] obj = new Object[]{DB.genLongId((String)"t_org_orgrelation"), TO_RELATION_TYPE_ID, fromOrg, toOrg, row.getString("fisdefaultfromorg"), row.getString("fisdefaulttoorg")};
                fromRelations.put(fromOrg.toString() + "_" + toOrg.toString(), obj);
            }
        }
        var9_9 = null;
        try (DataSet alreadyExistDs = DB.queryDataSet((String)(routeKey + "_1"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_TO);){
            for (Row row : alreadyExistDs) {
                String key = row.getLong("ffromorgid").toString() + "_" + row.getLong("ftoorgid").toString();
                fromRelations.remove(key);
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        if (fromRelations.size() > 0) {
            ArrayList insertDataList = new ArrayList(fromRelations.values());
            int[] res = DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)INSERT_RELATION, insertDataList);
            upgradeResult.setLog("upgrade org relation of accounting2unit is success: success data size is " + res.length);
        } else {
            upgradeResult.setLog("upgrade org relation of accounting2unit is success: no data need upgrade. ");
        }
        return upgradeResult;
    }
}

