/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class TaskBillAuditOpConfigUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(TaskBillAuditOpConfigUpgradeServiceImpl.class);
    private static final String ENTRY_CONFIG_COUNT = "select count(fid) from t_tk_billopconfig";
    private static final String QUERY_BILL_OP_CONFIG = "select fid,fbilloperationconfig from t_tk_taskbillchild";
    private static final String INSERT_BILL_OP_CONFIG = "insert into t_tk_billopconfig(fentryid,fid,fseq,fsscoperation,fsrcoperationdesc,fsrcoperationkey) values(?,?,?,?,?,?)";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        long tableDataCount = 0L;
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.taskbill.updateSscAuditOpCfg_queryCount", (DBRoute)DBRoute.of((String)"ssc"), (String)ENTRY_CONFIG_COUNT);){
            tableDataCount = ((Row)ds.iterator().next()).getInteger(0).intValue();
        }
        if (tableDataCount > 0L) {
            log.info("\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u914d\u7f6e\u8868\uff08\u76ee\u6807\u8868\uff09\u7684\u6570\u636e\u4e0d\u4e3a\u7a7a\uff0c\u8ba4\u5b9a\u4e3a\u5df2\u7ecf\u5347\u7ea7\u8fc7\uff0c\u672c\u6b21\u5347\u7ea7\u7ed3\u675f\u3002");
            upgradeResult.setSuccess(Boolean.TRUE.booleanValue());
            return upgradeResult;
        }
        HashMap<Long, String> taskBillOperationConfigMap = new HashMap<Long, String>();
        ArrayList<Long> noBillOperationConfigList = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.taskbill.updateSscAuditOpCfg_query", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_BILL_OP_CONFIG);){
            while (ds.hasNext()) {
                Row row = ds.next();
                long fid = row.getLong("fid");
                String billOperationConfig = row.getString("fbilloperationconfig");
                if (StringUtils.isBlank((CharSequence)billOperationConfig)) {
                    noBillOperationConfigList.add(fid);
                    continue;
                }
                taskBillOperationConfigMap.put(fid, billOperationConfig);
            }
        }
        log.info("\u5b58\u5728\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u7684\u5355\u636e\u4efb\u52a1\u4e2a\u6570\uff1a" + taskBillOperationConfigMap.size() + "\uff0c\u4e0d\u5b58\u5728\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u7684\u5355\u636e\u4efb\u52a1\u4e2a\u6570\uff1a" + noBillOperationConfigList.size());
        String value = "false";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"pendRescanBillOpConfig")});
        if (dynamicObject != null) {
            value = dynamicObject.getString("paramvalue");
        }
        boolean pendRescanNoCallBillOp = "true".equals(value);
        log.info("\u5171\u4eab\u53c2\u6570\uff1a\u3010\u6682\u6302\u3011\u3010\u9000\u626b\u3011\u4e0d\u8c03\u7528\u5355\u636e\u64cd\u4f5c \u7684\u503c\u4e3a\uff1a" + pendRescanNoCallBillOp);
        int count = noBillOperationConfigList.size() * 2;
        count = pendRescanNoCallBillOp ? (count += taskBillOperationConfigMap.size() * 3) : (count += taskBillOperationConfigMap.size() * 5);
        log.info("\u9700\u8981\u751f\u6210\u7684fentryid\u7684\u4e2a\u6570\u4e3a\uff1a" + count);
        if (count > 0) {
            long[] detailId = DBServiceHelper.genLongIds((String)"t_tk_billopconfig", (int)count);
            int curIndex = -1;
            ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(count);
            if (noBillOperationConfigList.size() > 0) {
                String saveKDString = ResManager.loadKDString((String)"save-\u4fdd\u5b58", (String)"TaskBillAuditOpConfigUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]);
                for (Long fid : noBillOperationConfigList) {
                    Object[] param = new Object[]{detailId[++curIndex], fid, 1, "1", saveKDString, "save"};
                    Object[] param1 = new Object[]{detailId[++curIndex], fid, 2, "7", saveKDString, "save"};
                    insertParamsList.add(param);
                    insertParamsList.add(param1);
                }
            }
            if (taskBillOperationConfigMap.size() > 0) {
                for (Map.Entry entry : taskBillOperationConfigMap.entrySet()) {
                    Long fid;
                    fid = (Long)entry.getKey();
                    String operation = (String)entry.getValue();
                    Object[] param = new Object[]{detailId[++curIndex], fid, 1, "1", operation, operation};
                    Object[] param1 = new Object[]{detailId[++curIndex], fid, 2, "2", operation, operation};
                    Object[] param2 = new Object[]{detailId[++curIndex], fid, 3, "7", operation, operation};
                    insertParamsList.add(param);
                    insertParamsList.add(param1);
                    insertParamsList.add(param2);
                    if (pendRescanNoCallBillOp) continue;
                    Object[] param4 = new Object[]{detailId[++curIndex], fid, 5, "3", operation, operation};
                    Object[] param5 = new Object[]{detailId[++curIndex], fid, 6, "4", operation, operation};
                    insertParamsList.add(param4);
                    insertParamsList.add(param5);
                }
            }
            int[] execResult = DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)INSERT_BILL_OP_CONFIG, insertParamsList);
            log.info("\u63d2\u5165\u4e2a\u6570\uff1a" + execResult.length);
            if (execResult.length > 0) {
                this.delPendRescanParam();
            }
        } else {
            log.info("\u6ca1\u67e5\u8be2\u5230\u6709\u4e1a\u52a1\u5355\u636e\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u5347\u7ea7");
            this.delPendRescanParam();
        }
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }

    private void delPendRescanParam() {
        DeleteServiceHelper.delete((String)"task_paramcontrol", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"pendRescanBillOpConfig")});
        log.info("\u5220\u9664\u5171\u4eab\u53c2\u6570\uff1a\u3010\u6682\u6302\u3011\u3010\u9000\u626b\u3011\u65f6\u4e0d\u8c03\u7528\u5ba1\u6279\u64cd\u4f5c");
    }
}

