/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class TaskBillChildFieldUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"TaskBillChildFieldUpgradeServiceImpl");
    private static final String QUERY_SQL = "select fentryid, fpriorityid from t_tk_levelentry where fpriorityid = 2";
    private static final String UPDATE_SQL = "update t_tk_levelentry set fisdefault=?  where fentryid=?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";
        DBRoute dbRoute = DBRoute.of((String)"ssc");
        this.upgradeLevelEntry(algoKey, dbRoute);
        return this.getUpgradeResult();
    }

    private void upgradeLevelEntry(String algoKey, DBRoute dbRoute) {
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)QUERY_SQL);){
            if (dataSet.isEmpty()) {
                log.info("There is no LevelEntry need upgrade!");
                return;
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(9);
            for (Row row : dataSet) {
                Long priorityid = row.getLong("fpriorityid");
                if (2L != priorityid) continue;
                Object[] paramArr = new Object[]{"1", row.getLong("fentryid")};
                params.add(paramArr);
            }
            if (!params.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)UPDATE_SQL, params);
            }
        }
    }

    private UpgradeResult getUpgradeResult() {
        UpgradeResult result = new UpgradeResult();
        result.setLog("LevelEntry upgrade success!");
        result.setSuccess(true);
        return result;
    }
}

