/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class TaskBillChildUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"TaskBillChildUpgradeServiceImpl");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String algo = "TaskBillChildUpgradeServiceImpl#Q";
        String selectMain = "SELECT FId, fbindform, fbilloperationconfig FROM T_tk_taskmainbill;";
        String selectRule = "SELECT FId, Fchildpkid FROM t_tk_taskrulebill;";
        UpgradeResult result = new UpgradeResult();
        try (DataSet main = DB.queryDataSet((String)(algo + "main"), (DBRoute)DBRoute.of((String)"ssc"), (String)selectMain);
             DataSet rule = DB.queryDataSet((String)(algo + "rule"), (DBRoute)DBRoute.of((String)"ssc"), (String)selectRule);
             DataSet origin = main.join(rule).on("FId", "FId").select(new String[]{"FId", "fbindform", "fbilloperationconfig"}, new String[]{"Fchildpkid"}).finish();){
            ArrayList<Object[]> params = new ArrayList<Object[]>(64);
            for (Row row : origin) {
                String fBindForm = row.getString("fbindform");
                String fOpConfig = row.getString("fbilloperationconfig");
                Long fChildPK = row.getLong("Fchildpkid");
                if (StringUtils.isBlank((String)fBindForm) && StringUtils.isBlank((String)fOpConfig) || fChildPK == null || fChildPK == 0L) continue;
                Object[] param = new Object[]{fBindForm, fOpConfig, fChildPK};
                params.add(param);
                log.info(String.format("\u6570\u636e\u8fc1\u79fb\uff1a\u4e1a\u52a1\u5355\u636e%s===>\u5b50\u9875\u9762%s", row.getLong("FId"), fChildPK));
            }
            if (params.isEmpty()) {
                result.setLog(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u201d\u7ed1\u5b9a\u5c55\u793a\u754c\u9762\u201c\u548c\u201d\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u914d\u7f6e\u201c\u8fc1\u79fb\u81f3\u4e1a\u52a1\u5355\u636e-\u5b50\u9875\u9762\u6210\u529f\uff0c\u6ca1\u6709\u9700\u8981\u8fc1\u79fb\u7684\u6570\u636e\u3002", (String)"TaskBillChildUpgradeServiceImpl_3", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                result.setSuccess(true);
                Iterator iterator = result;
                return iterator;
            }
            String updateTaskBillChild = "UPDATE T_tk_taskbillchild SET fbindform = ?, fbilloperationconfig = ? WHERE fid = ?;";
            try (TXHandle h = TX.requiresNew((String)"ssc_task_taskbill_child_upgrade");){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)updateTaskBillChild, params);
                }
                catch (Throwable e) {
                    h.markRollback();
                    result.setErrorInfo(e.getMessage());
                    result.setLog(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u201d\u7ed1\u5b9a\u5c55\u793a\u754c\u9762\u201c\u548c\u201d\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u914d\u7f6e\u201c\u8fc1\u79fb\u81f3\u4e1a\u52a1\u5355\u636e-\u5b50\u9875\u9762\u5931\u8d25\u3002", (String)"TaskBillChildUpgradeServiceImpl_2", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                    result.setSuccess(false);
                    UpgradeResult upgradeResult = result;
                    if (h != null) {
                        if (var18_27 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var18_27.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    if (origin != null) {
                        if (var14_18 != null) {
                            try {
                                origin.close();
                            }
                            catch (Throwable throwable) {
                                var14_18.addSuppressed(throwable);
                            }
                        } else {
                            origin.close();
                        }
                    }
                    if (rule != null) {
                        if (var12_14 != null) {
                            try {
                                rule.close();
                            }
                            catch (Throwable throwable) {
                                var12_14.addSuppressed(throwable);
                            }
                        } else {
                            rule.close();
                        }
                    }
                    if (main != null) {
                        if (var10_10 != null) {
                            try {
                                main.close();
                            }
                            catch (Throwable throwable) {
                                var10_10.addSuppressed(throwable);
                            }
                        } else {
                            main.close();
                        }
                    }
                    return upgradeResult;
                }
            }
        }
        result.setLog(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u201d\u7ed1\u5b9a\u5c55\u793a\u754c\u9762\u201c\u548c\u201d\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u914d\u7f6e\u201c\u8fc1\u79fb\u81f3\u4e1a\u52a1\u5355\u636e-\u5b50\u9875\u9762\u6210\u529f\u3002", (String)"TaskBillChildUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }
}

