/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskStateEnum;

public class TaskStateRecordUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_SQL0 = "select fid, foperation, fnewjobstate, foldjobstate, ftasktype from %s where fnewjobstate = '1' or foldjobstate = '1'";
    private static final String QUERY_SQL1 = "select fid, fqualityjudge from t_tk_tasktype";
    private static final String UPDATE_SQL_0 = "update %s set fnewjobstate = ?, foldjobstate = ? where fid = ?";
    private List<String> opList0_1 = Arrays.asList("6", "8", "14");
    private List<String> opList1_1 = Arrays.asList("3", "4", "7", "12", "5");
    private List<String> opList1_0 = Collections.singletonList("13");
    private List<String> opList1_2 = Arrays.asList("1", "2", "10");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";
        try (TXHandle h = TX.requiresNew((String)"ssc_task_statechange_upgrade");){
            try {
                this.taskStateUpgrade(algoKey, false);
                this.taskStateUpgrade(algoKey + "_his", true);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setErrorInfo(e.getMessage());
                result.setLog(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55\u5347\u7ea7\u5931\u8d25", (String)"TaskStateRecordUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                result.setSuccess(false);
            }
        }
        result.setLog(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55\u5347\u7ea7\u6210\u529f", (String)"TaskStateRecordUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private void taskStateUpgrade(String algoKey, boolean isHistory) {
        String querySql0 = isHistory ? String.format(QUERY_SQL0, "t_tk_statechangehis") : String.format(QUERY_SQL0, "t_tk_statechange");
        String updateSql0 = isHistory ? String.format(UPDATE_SQL_0, "t_tk_statechangehis") : String.format(UPDATE_SQL_0, "t_tk_statechange");
        try (DataSet dSet0 = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)querySql0);
             DataSet dSet1 = DB.queryDataSet((String)(algoKey + "_1"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL1);
             DataSet resultSet = dSet0.leftJoin(dSet1).on("ftasktype", "fid").select(new String[]{"fid", "foperation", "fnewjobstate", "foldjobstate"}, new String[]{"fqualityjudge"}).finish().filter("fqualityjudge is not null");){
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Row row : resultSet) {
                Object[] paramArr;
                String taskProperty = row.getString("fqualityjudge");
                if (!"0".equals(taskProperty)) continue;
                Long fid = row.getLong("fid");
                String foperation = row.getString("foperation");
                String cur_fnewjobstate = row.getString("fnewjobstate");
                String cur_foldjobstate = row.getString("foldjobstate");
                if (fid == 0L || StringUtils.isEmpty((String)foperation) || StringUtils.isEmpty((String)cur_fnewjobstate) || StringUtils.isEmpty((String)cur_foldjobstate) || (paramArr = this.buildParams(isHistory, fid, foperation, cur_fnewjobstate, cur_foldjobstate)) == null) continue;
                params.add(paramArr);
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)updateSql0, params);
                params.clear();
            }
            if (params.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)updateSql0, params);
            }
        }
    }

    private Object[] buildParams(boolean isHistory, Long fid, String foperation, String cur_fnewjobstate, String cur_foldjobstate) {
        String target_fnewjobstate = "";
        String target_foldjobstate = "";
        if (this.opList0_1.contains(foperation)) {
            target_fnewjobstate = "1".equals(cur_fnewjobstate) ? TaskStateEnum.TO_BE_AUDIT.getValue() : cur_fnewjobstate;
            target_foldjobstate = "1".equals(cur_foldjobstate) ? TaskStateEnum.TO_BE_DIS.getValue() : cur_foldjobstate;
        } else if (this.opList1_1.contains(foperation)) {
            target_fnewjobstate = "1".equals(cur_fnewjobstate) ? TaskStateEnum.TO_BE_AUDIT.getValue() : cur_fnewjobstate;
            target_foldjobstate = "1".equals(cur_foldjobstate) ? TaskStateEnum.TO_BE_AUDIT.getValue() : cur_foldjobstate;
        } else if (this.opList1_0.contains(foperation)) {
            target_fnewjobstate = "1".equals(cur_fnewjobstate) ? TaskStateEnum.TO_BE_DIS.getValue() : cur_fnewjobstate;
            target_foldjobstate = "1".equals(cur_foldjobstate) ? TaskStateEnum.TO_BE_AUDIT.getValue() : cur_foldjobstate;
        } else if (isHistory && this.opList1_2.contains(foperation)) {
            target_fnewjobstate = cur_fnewjobstate;
            target_foldjobstate = "1".equals(cur_foldjobstate) ? TaskStateEnum.TO_BE_AUDIT.getValue() : cur_foldjobstate;
        } else {
            return null;
        }
        Object[] paramArr = new Object[]{target_fnewjobstate, target_foldjobstate, fid};
        return paramArr;
    }
}

