/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeSysParam2SSCServiceImpl
implements IUpgradeService {
    private static final String QUERY_PARAM_ID = "SELECT FID FROM T_BAS_SYSPARACONSOLE WHERE FAPPID= '83bfebc8000020ac' AND FENABLED = '1'";
    private static final String QUERY_PARAM = "SELECT forgid, fdata FROM t_bas_sysparameter WHERE fparamid = ? AND fviewtypeid = '12'";
    private static final String QUERY_DUTY = "SELECT fsscorg FROM t_tk_dutymanage WHERE fsscorg in (%s)";
    private static final String INSERT_DUTY = "INSERT INTO t_tk_dutymanage (fid, fsscorg, fsscbusinesstype, fsscdutyscope) VALUES (?, ?, ?, ?)";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        String routeKey = "kd.ssc.task.upgradeservice.UpgradeSysParam2SSCServiceImpl";
        String paramId = "1/TMX25WPB/X";
        try (DataSet ds = DB.queryDataSet((String)(routeKey + "_0"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_PARAM_ID);){
            if (ds.hasNext()) {
                paramId = ds.next().getString(0);
            }
        }
        HashMap<Long, String> needMigrationData = new HashMap<Long, String>(32);
        DataSet ds = DB.queryDataSet((String)(routeKey + "_1"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_PARAM, (Object[])new Object[]{paramId});
        Object object = null;
        try {
            for (Row row : ds) {
                Map map;
                Object sscBusinessTypeObj;
                Long orgId = row.getLong("forgid");
                String dataStr = row.getString("fdata");
                if (!StringUtils.isNotBlank((CharSequence)dataStr) || (sscBusinessTypeObj = (map = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class)).get("sscbusinesstype")) == null || sscBusinessTypeObj.equals("1")) continue;
                needMigrationData.put(orgId, sscBusinessTypeObj.toString());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (needMigrationData.size() > 0) {
            ds = DB.queryDataSet((String)(routeKey + "_2"), (DBRoute)DBRoute.of((String)"ssc"), (String)String.format(QUERY_DUTY, StringUtils.join((Object[])needMigrationData.keySet().toArray(), (String)",")));
            object = null;
            try {
                for (Row row : ds) {
                    needMigrationData.remove(row.getLong(0));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if (needMigrationData.size() > 0) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(needMigrationData.size());
            for (Map.Entry entry : needMigrationData.entrySet()) {
                Object[] obj = new Object[]{DB.genLongId((String)"t_tk_dutymanage"), entry.getKey(), entry.getValue(), ",10,"};
                params.add(obj);
            }
            int[] res = DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)INSERT_DUTY, params);
            upgradeResult.setLog("system param data migration to ssc_duty is success.data size is " + res.length);
        } else {
            upgradeResult.setLog("no data need migration to ssc_duty from system param");
        }
        return upgradeResult;
    }
}

