/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkBillFlowNumUpgradeServiceImpl
implements IUpgradeService {
    String UPD_SQL = "if not exists (select 1 from ksql_usercolumns where ksql_col_tabname = '%s' and ksql_col_name in ('fflownumber')) alter table %s add (fflownumber varchar(50) default ' ' not null )";
    private static final String QUERY_SQL = "select fid from t_meta_formdesign where fparentid = '2LYDMCNXHB+5'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Set<String> tableNameSet = this.buildParamList();
        if (CollectionUtils.isEmpty(tableNameSet)) {
            return WorkBillFlowNumUpgradeServiceImpl.buildSuccessResult();
        }
        try (TXHandle h = TX.requiresNew((String)"ssc_task_flownum_upgrade");){
            try {
                for (String tableName : tableNameSet) {
                    if (StringUtils.isEmpty((Object)tableName)) continue;
                    String sql = String.format(this.UPD_SQL, tableName, tableName);
                    DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                UpgradeResult upgradeResult = WorkBillFlowNumUpgradeServiceImpl.buildErrorResult(e);
                if (h != null) {
                    if (var7_7 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        return WorkBillFlowNumUpgradeServiceImpl.buildSuccessResult();
    }

    private static UpgradeResult buildSuccessResult() {
        UpgradeResult result = new UpgradeResult();
        result.setLog(ResManager.loadKDString((String)"\u901a\u7528\u5de5\u5355\u6a21\u677f\u65b0\u589e\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u5b57\u6bb5\u5347\u7ea7\u6210\u529f", (String)"WorkBillFlowNumUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private static UpgradeResult buildErrorResult(Throwable e) {
        UpgradeResult result = new UpgradeResult();
        result.setErrorInfo(e.getMessage());
        result.setLog(ResManager.loadKDString((String)"\u901a\u7528\u5de5\u5355\u6a21\u677f\u65b0\u589e\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u5b57\u6bb5\u5347\u7ea7\u5931\u8d25", (String)"WorkBillFlowNumUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(false);
        return result;
    }

    private Set<String> buildParamList() {
        Set<String> dataEntityIds = this.queryEntityIdSet();
        if (CollectionUtils.isEmpty(dataEntityIds)) {
            return new HashSet<String>();
        }
        HashSet<String> tableNames = new HashSet<String>(8);
        for (String entityId : dataEntityIds) {
            AbstractMetadata metadata = MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            String tableName = ((EntityMetadata)metadata).getRootEntity().getTableName();
            tableNames.add(tableName);
        }
        return tableNames;
    }

    public Set<String> queryEntityIds() {
        String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";
        HashSet<String> entityIdSet = new HashSet<String>();
        try (DataSet resultSet = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_SQL);){
            for (Row row : resultSet) {
                entityIdSet.add(row.get("fid") + "");
            }
        }
        return entityIdSet;
    }

    private Set<String> queryEntityIdSet() {
        HashSet<String> dataEntitys = new HashSet<String>(8);
        QFilter qf1 = new QFilter("parentid.number", "=", (Object)"ssc_workbilltemplate");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{qf1});
        for (DynamicObject obj : collection) {
            String number = (String)obj.get("id");
            dataEntitys.add(number);
        }
        return dataEntitys;
    }
}

