/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.achieve;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AchieveDateUtil {
    private static final Log log = LogFactory.getLog(AchieveDateUtil.class);

    public static Date getBeforeDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date time = calendar.getTime();
        try {
            time = sdf.parse(sdf.format(time));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return time;
    }

    public static int getTimeShow(String time) {
        String[] aa = time.split(":");
        int b = Integer.parseInt(aa[0]) * 60 * 60 + Integer.parseInt(aa[1]) * 60;
        return b;
    }

    public static float getHourTotal(String endtime, String begintime) {
        DecimalFormat df = new DecimalFormat("0.00");
        int timeShow1 = AchieveDateUtil.getTimeShow(endtime);
        int timeShow2 = AchieveDateUtil.getTimeShow(begintime);
        return Float.parseFloat(df.format((double)(timeShow1 - timeShow2) / 3600.0));
    }

    public static long between(Date begin, Date end) {
        LocalDate beginDate = AchieveDateUtil.dateToLocalDate(begin);
        LocalDate endDate = AchieveDateUtil.dateToLocalDate(end);
        return endDate.toEpochDay() - beginDate.toEpochDay();
    }

    public static LocalDate dateToLocalDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String format = sdf.format(date);
        return LocalDate.parse(format, dtf);
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        ArrayList<Date> Datelist = new ArrayList<Date>(10);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            Datelist.add(calBegin.getTime());
        }
        Datelist.add(dBegin);
        return Datelist;
    }

    public static double getHours(Date date1, Date date2) {
        DecimalFormat dft = new DecimalFormat("#.000");
        double hour = 0.0;
        try {
            long diff = date1.getTime() - date2.getTime();
            hour = Double.parseDouble(dft.format(diff / 3600000L));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return hour;
    }

    public static boolean belongTime(Date beginTime, Date endTime, Date nowTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static int getDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime ldt = LocalDateTime.parse(sdf.format(date), formatter);
        return ldt.getDayOfMonth();
    }

    public static Integer getTimeNum(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String time = sdf.format(date);
        String[] split = time.split(":");
        return Integer.parseInt(split[0] + split[1]);
    }

    public static String getFisrtDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public static Date getDateByYearMonth(int year, int month, boolean isStart) {
        YearMonth yearMonth = YearMonth.of(year, month);
        LocalDate localDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.now();
        if (isStart) {
            localDate = yearMonth.atDay(1);
            localDateTime = localDate.atStartOfDay();
        } else {
            localDate = yearMonth.atEndOfMonth();
            localDateTime = localDate.atTime(23, 59, 59, 999);
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Calendar getCalendarByTimeStr(String timeString) {
        String[] intStrings = timeString.split(":");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, Integer.parseInt(intStrings[0]));
        calendar.set(12, Integer.parseInt(intStrings[1]));
        calendar.set(13, 0);
        return calendar;
    }

    public static String getTimeStrByCalendar(Calendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        return sdf.format(calendar.getTime());
    }

    public static Float getHours(int min) {
        BigDecimal minBig = new BigDecimal(min);
        BigDecimal hourBig = minBig.divide(new BigDecimal("60"), 2, 4);
        return Float.valueOf(hourBig.toString());
    }

    public static BigDecimal getHoursBigDecimal(int min) {
        BigDecimal minBig = new BigDecimal(min);
        return minBig.divide(new BigDecimal("60"), 2, RoundingMode.HALF_UP);
    }

    public static Date timeStringToDate(String timeString) {
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        Date result = null;
        try {
            result = SDFTIME.parse(timeString);
        }
        catch (Exception e) {
            log.error("timeString\u8f6c\u5316\u4e3aDate\u5931\u8d25\uff0ctimeString\uff1a" + timeString);
        }
        return result;
    }

    public static int timeStringToInt(String timeString) {
        String[] aa = timeString.split(":");
        return Integer.parseInt(aa[0]) * 60 + Integer.parseInt(aa[1]);
    }
}

