/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.achieve;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.achieve.TimeBitSetAggFunction;
import kd.ssc.constant.achieve.AchieveConstant;
import kd.ssc.enums.achieve.TargetCalculateParEnum;
import kd.ssc.enums.achieve.TargetRule;
import kd.ssc.task.util.DateUtil;

public class CalculateAchieveUtil {
    private static final Log logger = LogFactory.getLog(CalculateAchieveUtil.class);

    public static double calculateAchieveActualValue(String assessType, Long assessObjectId, Date startDate, Date endDate, Long targetId) {
        double result;
        QFilter targetFilter = new QFilter("id", "=", (Object)targetId);
        DynamicObject target = QueryServiceHelper.queryOne((String)"ssc_achievetarget", (String)"id,ruleexpjson_tag", (QFilter[])new QFilter[]{targetFilter});
        String reuleJson = target.getString("ruleexpjson_tag");
        if (reuleJson == null) {
            logger.info("\u4f20\u5165\u7ee9\u6548\u6307\u6807\u5b9e\u9645\u503c\u8ba1\u7b97\u65b9\u6cd5kd.ssc.achieve.CalculateAchieveUtil.calculateAchieveActualValue\u7684\u6307\u6807" + targetId + "\u7684\u8ba1\u7b97\u516c\u5f0f\u4e3anull\u4e0d\u80fd\u8fdb\u884c\u8ba1\u7b97");
            return 1.0E-4;
        }
        TargetRule rule = CalculateAchieveUtil.deserializeRule(reuleJson);
        String formula = rule.getExpression();
        if (formula == null || formula.isEmpty()) {
            logger.info(targetId + "\u8ba1\u7b97\u6307\u6807\u4e3a\u7a7a");
            return 1.0E-4;
        }
        Map<String, String> paramKeys = CalculateAchieveUtil.getParamKeys(formula);
        Map<String, Object> ctx = CalculateAchieveUtil.getParamCtx(paramKeys, assessType, assessObjectId, startDate, endDate);
        try {
            Object resultObj = FormulaEngine.runFormula((String)formula, ctx);
            if (resultObj != null) {
                BigDecimal resultBigDecimal = CalculateAchieveUtil.getBigDecimal(resultObj);
                if (resultBigDecimal == null) {
                    logger.info("calculateAchieveActualValue\u8c03\u7528FormulaEngine.runFormula\u8fd4\u56de\u7684\u503c\u7c7b\u578b\u4e0d\u80fd\u8f6c\u5316\u4e3aBigDecimal");
                    double result2 = 1.0E-4;
                    return 1.0E-4;
                }
                result = resultBigDecimal.compareTo(new BigDecimal(0)) == 0 ? 1.0E-4 : resultBigDecimal.setScale(2, 4).doubleValue();
            } else {
                logger.info("calculateAchieveActualValue\u8c03\u7528FormulaEngine.runFormula\u8fd4\u56de\u7684\u503c\u4e3anull");
                result = 1.0E-4;
            }
        }
        catch (RunFormulaException e) {
            result = 1.0E-4;
            logger.error("script:" + formula + ",error :" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static TargetRule deserializeRule(String json) {
        TargetRule ruleObj = StringUtils.isEmpty((CharSequence)json) ? new TargetRule() : (TargetRule)SerializationUtils.fromJsonString((String)json, TargetRule.class);
        return ruleObj;
    }

    private static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(value.toString());
            } else {
                logger.info("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    private static Map<String, Object> getParamCtx(Map<String, String> paramKeys, String assessType, Long assessObjectId, Date startDate, Date endDate) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(8);
        for (Map.Entry<String, String> entry : paramKeys.entrySet()) {
            String tableName = entry.getValue();
            String paramKey = entry.getKey();
            List<QFilter> paramQFilters = CalculateAchieveUtil.getParamQFilters(assessType, assessObjectId, startDate, endDate, tableName);
            double paramVaule = CalculateAchieveUtil.getParamValue(paramQFilters, tableName, paramKey, assessType);
            ctx.put(paramKey, paramVaule);
        }
        return ctx;
    }

    private static Map<String, String> getParamKeys(String formula) {
        HashMap<String, String> paramKeys = new HashMap<String, String>(8);
        for (TargetCalculateParEnum calParam : TargetCalculateParEnum.values()) {
            if (!formula.contains(calParam.getCode())) continue;
            String paramCode = calParam.getCode();
            String paramTableName = calParam.getTableName();
            paramKeys.put(paramCode, paramTableName);
        }
        return paramKeys;
    }

    private static double getParamValue(List<QFilter> filter, String tableName, String fieldName, String assessType) {
        QFilter[] filters = new QFilter[filter.size()];
        filter.toArray(filters);
        boolean isDutyTimeAndAssessUser = fieldName.equals(TargetCalculateParEnum.OndutyTime.getCode()) && assessType.equals("2");
        String selectFileds = isDutyTimeAndAssessUser ? AchieveConstant.buildSelectField("daten", "dutytimebitset") : fieldName;
        String algoKey = CalculateAchieveUtil.class + ".getParamValue()";
        BigDecimal sumValue = BigDecimal.ZERO;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)tableName, (String)selectFileds, (QFilter[])filters, null);){
            if (dataSet.hasNext()) {
                if (isDutyTimeAndAssessUser) {
                    DataSet dayOfDataSet = dataSet.groupBy(new String[]{"daten"}).agg((CustomAggFunction)new TimeBitSetAggFunction(), "dutytimebitset", "dutytimeofoneday").finish();
                    for (Row day : dayOfDataSet) {
                        sumValue = sumValue.add(day.getBigDecimal("dutytimeofoneday"));
                    }
                } else {
                    DataSet sumDataSet = dataSet.executeSql("select sum(" + fieldName + ") sumvalue");
                    Row sumValueRow = sumDataSet.next();
                    sumValue = sumValueRow.getBigDecimal("sumvalue");
                }
            }
        }
        return sumValue.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private static List<QFilter> getParamQFilters(String assessType, Long assessObjectId, Date startDate, Date endDate, String tableName) {
        ArrayList<QFilter> paramQFilters = new ArrayList<QFilter>(2);
        String dateField = null;
        String assessObjectField = null;
        switch (tableName) {
            case "ssc_workloadonline": {
                dateField = "completetime";
                assessObjectField = CalculateAchieveUtil.getWorkLoadField(assessType);
                break;
            }
            case "ssc_taskeffectquality": {
                dateField = "completetime";
                assessObjectField = CalculateAchieveUtil.getEffectQualityField(assessType);
                break;
            }
            case "ssc_userondutytime": {
                dateField = "daten";
                assessObjectField = CalculateAchieveUtil.getUserOnDutyTimeField(assessType);
                break;
            }
            default: {
                dateField = "";
                assessObjectField = "";
            }
        }
        Date startDateStart = null;
        Date endDateEnd = null;
        try {
            startDateStart = DateUtil.getCurDateForm(startDate, true);
            endDateEnd = DateUtil.getCurDateForm(endDate, false);
        }
        catch (ParseException e) {
            logger.info("CalculateAchieveUtil.getParamQFilters error:" + e.getMessage(), (Object)e);
        }
        QFilter fieldFilter = new QFilter(assessObjectField, "=", (Object)assessObjectId);
        paramQFilters.add(fieldFilter);
        QFilter dateFilter = new QFilter(dateField, ">=", (Object)startDateStart);
        dateFilter.and(new QFilter(dateField, "<=", (Object)endDateEnd));
        paramQFilters.add(dateFilter);
        return paramQFilters;
    }

    private static String getWorkLoadField(String assessType) {
        String assessObjectField = null;
        switch (assessType) {
            case "1": {
                assessObjectField = "groupid";
                break;
            }
            case "2": {
                assessObjectField = "handlerid";
                break;
            }
            default: {
                assessObjectField = "";
            }
        }
        return assessObjectField;
    }

    private static String getEffectQualityField(String assessType) {
        String assessObjectField = null;
        switch (assessType) {
            case "1": {
                assessObjectField = "groupid";
                break;
            }
            case "2": {
                assessObjectField = "handlerid";
                break;
            }
            default: {
                assessObjectField = "";
            }
        }
        return assessObjectField;
    }

    private static String getUserOnDutyTimeField(String assessType) {
        String assessObjectField = null;
        switch (assessType) {
            case "1": {
                assessObjectField = "groupid";
                break;
            }
            case "2": {
                assessObjectField = "userid";
                break;
            }
            default: {
                assessObjectField = "";
            }
        }
        return assessObjectField;
    }
}

