/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.achieve;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataType;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.achieve.BitSetUtil;

public class TimeBitSetAggFunction
extends CustomAggFunction<List<BitSet>> {
    public TimeBitSetAggFunction() {
        super("time_bitset_agg", (DataType)DataType.BigDecimalType);
    }

    public List<BitSet> newAggValue() {
        return new ArrayList<BitSet>();
    }

    public List<BitSet> addValue(List<BitSet> batchValues, Object value) {
        String bitsetStr = String.valueOf(value);
        batchValues.add(BitSetUtil.toBitSet(bitsetStr));
        return batchValues;
    }

    public List<BitSet> combineAggValue(List<BitSet> batchValues1, List<BitSet> batchValues2) {
        batchValues1.addAll(batchValues2);
        return batchValues1;
    }

    public Object getResult(List<BitSet> values) {
        BitSet aggValue = new BitSet();
        for (BitSet va : values) {
            aggValue.or(va);
        }
        return AchieveDateUtil.getHoursBigDecimal(aggValue.cardinality());
    }
}

