/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.eventSend.event;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.eventSend.core.SscEventContext;
import kd.ssc.eventSend.entity.SscEventDo;
import kd.ssc.eventSend.event.SscSendEvent;
import kd.ssc.eventSend.util.DutyManageDataHelper;
import kd.ssc.eventSend.util.SscEventResultHelper;

public class TaskCancelPendVerifyEvent
implements SscSendEvent {
    private static final Log logger = LogFactory.getLog(TaskCancelPendVerifyEvent.class);

    @Override
    public Map<String, Object> event(SscEventContext context) {
        Long taskId = context.getTaskId();
        SscEventDo sscEventDo = context.getSscEventDo();
        Map<String, Object> subParamMap = context.getParamMap();
        logger.info("TaskCancelPendVerifyEvent.event() start, taskId = {}", (Object)taskId);
        return this.taskCancelPendVerify(sscEventDo, taskId, subParamMap);
    }

    private Map<String, Object> taskCancelPendVerify(SscEventDo sscEventDo, Long taskId, Map<String, Object> subParamMap) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        String selectFields = "id, sscid, billlongid, billtype.bindbill.number, personid.id, pooltype, state, source, sourcetype, tasktypeid.qualityjudge";
        DynamicObject taskInfoDo = QueryServiceHelper.queryOne((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        if (taskInfoDo == null) {
            logger.error("TaskCancelPendVerifyEvent.event() end\uff1a\u5171\u4eab\u4efb\u52a1\u4e0d\u5b58\u5728");
            return SscEventResultHelper.getSuccessResult(null);
        }
        String taskProperty = taskInfoDo.getString("tasktypeid.qualityjudge");
        if ("1".equals(taskProperty)) {
            logger.info("TaskCancelPendVerifyEvent.event() end\uff0ctaskProperty = {}\uff1a\u8be5\u4efb\u52a1\u5c5e\u6027\u4e0d\u652f\u6301", (Object)taskProperty);
            return SscEventResultHelper.getSuccessResult(null);
        }
        return this.doBizService(sscEventDo, taskInfoDo, subParamMap);
    }

    private Map<String, Object> doBizService(SscEventDo sscEventDo, DynamicObject taskInfoDo, Map<String, Object> subParamMap) {
        QFilter filter3;
        QFilter filter2;
        Long taskId = taskInfoDo.getLong("id");
        Long sscId = taskInfoDo.getLong("sscid");
        String sscType = DutyManageDataHelper.getSSCType(sscId);
        String caseNumber = sscEventDo.getEventType().getCaseNumber();
        QFilter filter1 = new QFilter("bizextcase.number", "=", (Object)caseNumber);
        DynamicObject bizExtServiceDo = QueryServiceHelper.queryOne((String)"ssc_bizextservice", (String)"id,servicename,methodname,cloudid.number,appid.number", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("sscbusinesstype", "=", (Object)sscType), filter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (bizExtServiceDo == null) {
            logger.info("TaskCancelPendVerifyEvent.event() end\uff0csscType = {}\uff0ccaseNumber = {}\uff1a\u672a\u627e\u5230\u76f8\u5173\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u65e0\u9700\u6267\u884c", (Object)sscType, (Object)caseNumber);
            return SscEventResultHelper.getSuccessResult(null);
        }
        String serviceName = bizExtServiceDo.getString("servicename");
        String methodName = bizExtServiceDo.getString("methodname");
        String cloudId = bizExtServiceDo.getString("cloudid.number");
        String appId = bizExtServiceDo.getString("appid.number");
        if (StringUtils.isEmpty((Object)serviceName) || StringUtils.isEmpty((Object)methodName) || StringUtils.isEmpty((Object)cloudId) || StringUtils.isEmpty((Object)appId)) {
            logger.info("TaskCancelPendVerifyEvent.event() end\uff0c\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u76f8\u5173\u914d\u7f6e\u4e3a\u7a7a");
            return SscEventResultHelper.getSuccessResult(null);
        }
        cloudId = cloudId.toLowerCase();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        ArrayList<Long> taskIdList = new ArrayList<Long>(8);
        taskIdList.add(taskId);
        paramMap.put("taskIds", taskIdList);
        paramMap.put("paramMap", subParamMap);
        String paramMapJson = JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        sscEventDo.setEventDetailJson(paramMapJson);
        int maxCount = sscEventDo.getMaxCount();
        for (int i = 1; i <= maxCount; ++i) {
            try {
                logger.info("TaskCancelPendVerifyEvent.event(), paramMap=" + paramMapJson);
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{taskIdList, subParamMap});
                logger.info("TaskCancelPendVerifyEvent.event(), resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                return resultMap;
            }
            catch (Exception e) {
                logger.error("TaskCancelPendVerifyEvent.event() failed ", (Throwable)e);
                if (i != maxCount) continue;
                throw e;
            }
        }
        return SscEventResultHelper.getSuccessResult(null);
    }
}

