/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.compensate;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.ssc.exception.compensate.CompensateHandler;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.util.ExceptionHelperUtil;
import kd.ssc.task.create.CreateTask4Rule;
import org.apache.commons.lang3.math.NumberUtils;

public class RuleTaskCompensateHandler
extends CompensateHandler {
    public RuleTaskCompensateHandler(ExceptionDTO dto) {
        super(dto);
    }

    @Override
    public boolean exceptionCompensate() {
        try {
            long taskId = this.createTaskByParam();
            if (taskId == 0L) {
                ExceptionHelperUtil.updateTableAfterCompensate(CompensateStatusEnum.FAILURE, this.dto);
                return false;
            }
            ExceptionHelperUtil.updateTableAfterCompensate(CompensateStatusEnum.SUCCESS, this.dto);
            return true;
        }
        catch (Exception e) {
            ExceptionHelperUtil.updateTableAfterCompensateException(e, this.dto);
            return false;
        }
    }

    private long createTaskByParam() throws Exception {
        String requestParam = this.dto.getRequestParam();
        Map param = (Map)SerializationUtils.fromJsonString((String)requestParam, Map.class);
        long taskTypeId = NumberUtils.toLong((String)((String)param.get("taskTypeId")));
        long billTypeId = NumberUtils.toLong((String)((String)param.get("billTypeId")));
        String billId = (String)param.get("billId");
        long sscId = NumberUtils.toLong((String)((String)param.get("sscId")));
        String executeOpNumber = (String)param.get("executeOpNumber");
        String reverseOpNumber = (String)param.get("reverseOpNumber");
        long taskSubjectId = NumberUtils.toLong((String)((String)param.get("taskSubjectId")));
        if (ExceptionHelperUtil.taskIsExisted(billId, taskTypeId)) {
            return -1L;
        }
        return new CreateTask4Rule().createTask(taskTypeId, billTypeId, billId, sscId, executeOpNumber, reverseOpNumber, taskSubjectId);
    }
}

