/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.dto;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.constant.EntityField;
import kd.ssc.exception.domain.ExceptionDO;
import kd.ssc.exception.factory.GetOrgByDifBillFactory;
import kd.ssc.exception.factory.GetUserByDifBillFactory;
import kd.ssc.exception.util.ExceptionHelperUtil;
import kd.ssc.task.util.ObjectCloneUtil;

public class ExceptionDTO {
    private String billId;
    private String billType;
    private String exceptionCode;
    private String requestParam;
    private String failureReason;
    private String failureMsg;
    private Date failureTime;
    private String dealType;
    private String interfaceType;
    private String sourceSystem;
    private String isCompensate;

    public ExceptionDTO(String billId, String billType, String exceptionCode) {
        this.billId = billId;
        this.billType = billType;
        this.exceptionCode = exceptionCode;
    }

    public ExceptionDTO(String billId, String billType, String exceptionCode, String requestParam, String failureReason) {
        this.billId = billId;
        this.billType = billType;
        this.exceptionCode = exceptionCode;
        this.requestParam = requestParam;
        this.failureReason = failureReason;
    }

    public ExceptionDO transform2Do() {
        if (!ExceptionHelperUtil.isLegalDto(this)) {
            return null;
        }
        ExceptionDO exceptionDo = new ExceptionDO(this.billId, this.billType, this.exceptionCode);
        if (this.requestParam != null) {
            exceptionDo.setRequestParam(this.requestParam);
        }
        if (this.failureMsg != null) {
            exceptionDo.setFailureMsg(this.failureMsg);
        }
        if (this.failureReason != null) {
            exceptionDo.setFailureReason(this.failureReason);
        }
        if (this.failureTime != null) {
            exceptionDo.setFailureTime(this.failureTime);
        }
        if (this.dealType != null) {
            exceptionDo.setDealType(this.dealType);
        }
        if (this.interfaceType != null) {
            exceptionDo.setInterfaceType(this.interfaceType);
        }
        if (this.sourceSystem != null) {
            exceptionDo.setSourceSystem(this.sourceSystem);
        }
        if (this.isCompensate != null) {
            exceptionDo.setIsCompensate(this.isCompensate);
        }
        this.qryAndSetInf2Do(exceptionDo);
        return exceptionDo;
    }

    private void qryAndSetInf2Do(ExceptionDO exceptionDo) {
        QFilter[] qFilters;
        DynamicObject dyo;
        String billTypeName;
        String billTypeFileds = EntityField.buildSelectField("name");
        QFilter[] billTypeQfilters = new QFilter[]{new QFilter("number", "=", (Object)this.billType)};
        if (QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])billTypeQfilters) && StringUtils.isNotBlank((CharSequence)(billTypeName = (dyo = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)billTypeFileds, (QFilter[])billTypeQfilters)).getString("name")))) {
            exceptionDo.setBillTypeName(billTypeName);
        }
        if (QueryServiceHelper.exists((String)this.billType, (QFilter[])(qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(this.billId))}))) {
            Long orgId;
            Long creator;
            DynamicObject dyo2;
            String billNo;
            String user;
            String selectFields = EntityField.buildSelectField("billno");
            String org = GetOrgByDifBillFactory.getOrg(this.billType);
            if (org != null) {
                selectFields = EntityField.buildSelectField(selectFields, org);
            }
            if ((user = GetUserByDifBillFactory.getUser(this.billType)) != null) {
                selectFields = EntityField.buildSelectField(selectFields, user);
            }
            if (StringUtils.isNotBlank((CharSequence)(billNo = (dyo2 = QueryServiceHelper.queryOne((String)this.billType, (String)selectFields, (QFilter[])qFilters)).getString("billno")))) {
                exceptionDo.setBillNo(billNo);
            }
            if (user != null && QueryServiceHelper.exists((String)"bos_user", (Object)(creator = Long.valueOf(dyo2.getLong(user))))) {
                exceptionDo.setApplicant(creator);
            }
            if (org != null && QueryServiceHelper.exists((String)"bos_org", (Object)(orgId = Long.valueOf(dyo2.getLong(org))))) {
                exceptionDo.setApplOrg(orgId);
            }
        }
    }

    public void transformFromDo(ExceptionDO exceptionDo) {
        if (exceptionDo == null) {
            return;
        }
        if (exceptionDo.getBillId() != null) {
            this.setBillId(exceptionDo.getBillId());
        }
        if (exceptionDo.getBillType() != null) {
            this.setBillType(exceptionDo.getBillType());
        }
        if (exceptionDo.getExceptionType() != null) {
            this.setExceptionCode(exceptionDo.getExceptionType());
        }
        if (exceptionDo.getRequestParam() != null) {
            this.setRequestParam(exceptionDo.getRequestParam());
        }
        if (exceptionDo.getFailureMsg() != null) {
            this.setFailureMsg(exceptionDo.getFailureMsg());
        }
        if (exceptionDo.getFailureReason() != null) {
            this.setFailureReason(exceptionDo.getFailureReason());
        }
        if (exceptionDo.getFailureTime() != null) {
            this.setFailureTime(exceptionDo.getFailureTime());
        }
        if (exceptionDo.getDealType() != null) {
            this.setDealType(exceptionDo.getDealType());
        }
        if (exceptionDo.getInterfaceType() != null) {
            this.setInterfaceType(exceptionDo.getInterfaceType());
        }
        if (exceptionDo.getSourceSystem() != null) {
            this.setSourceSystem(exceptionDo.getSourceSystem());
        }
        if (exceptionDo.getIsCompensate() != null) {
            this.setIsCompensate(exceptionDo.getIsCompensate());
        }
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(String exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public String getRequestParam() {
        return this.requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Date getFailureTime() {
        return (Date)ObjectCloneUtil.cloneObject(this.failureTime);
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = (Date)ObjectCloneUtil.cloneObject(failureTime);
    }

    public String getDealType() {
        return this.dealType;
    }

    public void setDealType(String dealType) {
        this.dealType = dealType;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getFailureMsg() {
        return this.failureMsg;
    }

    public void setFailureMsg(String failureMsg) {
        this.failureMsg = failureMsg;
    }

    public String getIsCompensate() {
        return this.isCompensate;
    }

    public void setIsCompensate(String isCompensate) {
        this.isCompensate = isCompensate;
    }

    public String toString() {
        return "ExceptionDTO{billId='" + this.billId + '\'' + ", billType='" + this.billType + '\'' + ", exceptionCode='" + this.exceptionCode + '\'' + ", requestParam='" + this.requestParam + '\'' + ", failureReason='" + this.failureReason + '\'' + ", failureTime=" + this.failureTime + ", dealType='" + this.dealType + '\'' + ", interfaceType='" + this.interfaceType + '\'' + ", sourceSystem='" + this.sourceSystem + '\'' + ", isCompensate='" + this.isCompensate + '\'' + '}';
    }

    public ExceptionDTO(ExceptionDTOBuilder builder2) {
        this.billId = builder2.billId;
        this.billType = builder2.billType;
        this.exceptionCode = builder2.exceptionCode;
        this.requestParam = builder2.requestParam;
        this.failureReason = builder2.failureReason;
        this.failureMsg = builder2.failureMsg;
        this.failureTime = builder2.failureTime;
        this.dealType = builder2.dealType;
        this.interfaceType = builder2.interfaceType;
        this.sourceSystem = builder2.sourceSystem;
        this.isCompensate = builder2.isCompensate;
    }

    public static ExceptionDTOBuilder builder() {
        return new ExceptionDTOBuilder();
    }

    public static class ExceptionDTOBuilder {
        private String billId;
        private String billType;
        private String exceptionCode;
        private String requestParam;
        private String failureReason;
        private String failureMsg;
        private Date failureTime;
        private String dealType;
        private String interfaceType;
        private String sourceSystem;
        private String isCompensate;

        public ExceptionDTOBuilder billId(String billId) {
            this.billId = billId;
            return this;
        }

        public ExceptionDTOBuilder billType(String billType) {
            this.billType = billType;
            return this;
        }

        public ExceptionDTOBuilder exceptionCode(String exceptionCode) {
            this.exceptionCode = exceptionCode;
            return this;
        }

        public ExceptionDTOBuilder requestParam(String requestParam) {
            this.requestParam = requestParam;
            return this;
        }

        public ExceptionDTOBuilder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public ExceptionDTOBuilder failureMsg(String failureMsg) {
            this.failureMsg = failureMsg;
            return this;
        }

        public ExceptionDTOBuilder failureTime(Date failureTime) {
            this.failureTime = (Date)ObjectCloneUtil.cloneObject(failureTime);
            return this;
        }

        public ExceptionDTOBuilder dealType(String dealType) {
            this.dealType = dealType;
            return this;
        }

        public ExceptionDTOBuilder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public ExceptionDTOBuilder sourceSystem(String sourceSystem) {
            this.sourceSystem = sourceSystem;
            return this;
        }

        public ExceptionDTOBuilder isCompensate(String isCompensate) {
            this.isCompensate = isCompensate;
            return this;
        }

        public ExceptionDTO build() {
            return new ExceptionDTO(this);
        }
    }
}

