/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.ssc.exception.domain.ExceptionDO;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.ExceptionTypeEnum;

public class DtoCreateFactory {
    public static ExceptionDTO getDtoInstance(String billId, String billType, String exceptionCode) {
        ExceptionTypeEnum exceptionTypeEnum;
        ExceptionDTO dto = null;
        if (DtoCreateFactory.isLegal(billId, billType, exceptionCode) && (exceptionTypeEnum = ExceptionTypeEnum.getExceptionTypeByCode(exceptionCode)) != null) {
            switch (exceptionTypeEnum) {
                default: 
            }
            dto = new ExceptionDTO(billId, billType, exceptionCode);
        }
        return dto;
    }

    public static ExceptionDTO transFromDo2Dto(ExceptionDO exceptionDo) {
        String exceptionCode;
        String billType;
        String billId;
        ExceptionDTO dto = null;
        if (exceptionDo != null && (dto = DtoCreateFactory.getDtoInstance(billId = exceptionDo.getBillId(), billType = exceptionDo.getBillType(), exceptionCode = exceptionDo.getExceptionType())) != null) {
            dto.transformFromDo(exceptionDo);
        }
        return dto;
    }

    private static boolean isLegal(String billId, String billType, String exceptionCode) {
        return StringUtils.isNotBlank((CharSequence)billId) && StringUtils.isNotBlank((CharSequence)billType) && StringUtils.isNotBlank((CharSequence)exceptionCode);
    }
}

