/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.nsynexceprunnable;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.exception.compensate.CompensateHandler;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.factory.CompensateCreateFactory;

public class WfStatusCompensateRunnable
implements Runnable {
    private ExceptionDTO dto;
    private int retryTimes;
    private static final Log log = LogFactory.getLog(WfStatusCompensateRunnable.class);

    @Override
    public void run() {
        boolean compensateStatus = false;
        for (int i = 0; i <= this.retryTimes; ++i) {
            CompensateHandler compensateHandler = CompensateCreateFactory.getCompensateInstance(this.dto);
            if (compensateHandler != null) {
                compensateStatus = compensateHandler.exceptionCompensate();
            }
            if (compensateStatus) break;
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("\u7ebf\u7a0bsleep\u4e2d\u65ad\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public WfStatusCompensateRunnable(ExceptionDTO dto, int retryTimes) {
        this.dto = dto;
        this.retryTimes = retryTimes;
    }

    public ExceptionDTO getDto() {
        return this.dto;
    }

    public void setDto(ExceptionDTO dto) {
        this.dto = dto;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public String toString() {
        return "WfStatusCompensateRunnable{dto=" + this.dto + ", retryTimes=" + this.retryTimes + '}';
    }
}

