/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.schedule;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.pojo.ExcRecordNotifyArgs;
import kd.ssc.exception.util.ExcRecordNotifyArgsHelper;
import kd.ssc.exception.util.ExceptionHelperUtil;

public class ExceptionNotifySchedule
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ExceptionNotifySchedule.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.warn("\u8fdb\u5165\u5f02\u5e38\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1");
        if (map == null || map.get("retryTimes") == null) {
            return;
        }
        int retryTimes = Integer.parseInt((String)map.get("retryTimes"));
        log.warn("retryTimes:" + retryTimes);
        DynamicObjectCollection excRecords = this.getExceptionRecord(retryTimes);
        int count = excRecords.size();
        log.warn("count:" + count);
        if (count == 0) {
            return;
        }
        ExcRecordNotifyArgs args = ExcRecordNotifyArgsHelper.getExcRecordNotifyArgs();
        StringBuilder logWarn = new StringBuilder();
        logWarn.append("ExcRecordNotifyArgs:").append(args);
        log.warn(logWarn.toString());
        MessageInfo messageInfo = ExceptionHelperUtil.getMessageInfoBySscParam(args, count);
        if (messageInfo != null) {
            logWarn.setLength(0);
            logWarn.append("MessageInfo:").append(messageInfo);
            log.warn(logWarn.toString());
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private DynamicObjectCollection getExceptionRecord(int retryTimes) {
        QFilter filter = this.getFilter(retryTimes);
        return QueryServiceHelper.query((String)"task_exceptionrecord", (String)this.getSelectField(), (QFilter[])new QFilter[]{filter});
    }

    private String getSelectField() {
        return "*";
    }

    private QFilter getFilter(int retryTimes) {
        QFilter qFilter = new QFilter("compensatestatus", "=", (Object)CompensateStatusEnum.FAILURE.getValue());
        qFilter.and(new QFilter("retrycounts", ">=", (Object)retryTimes));
        return qFilter;
    }
}

