/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.service.impl;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.enums.NotCompensateEnum;
import kd.ssc.exception.service.CompensateService;
import kd.ssc.exception.util.ExceptionHelperUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class DataCompensateServiceImpl
implements CompensateService {
    private static final int TIME_THRESHOLD = 5;
    private static final int RETRY_TIMES = 6;
    private static final int LOAD_NUMBER_LIMIT = 1000;
    private static final Log log = LogFactory.getLog(DataCompensateServiceImpl.class);

    @Override
    public void compensate() {
        log.warn("\u81ea\u52a8\u8865\u507f\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f");
        DynamicObjectCollection excRecords = this.getExceptionRecord();
        int successCompensate = 0;
        while (excRecords != null && !excRecords.isEmpty()) {
            successCompensate += ExceptionHelperUtil.batchCompensate(excRecords, true);
            excRecords.clear();
            excRecords = this.getExceptionRecord();
        }
        log.warn("\u8865\u507f\u6210\u529f\u5355\u636e\u6570\u76eesuccessCompensate:(" + successCompensate + ")");
    }

    private DynamicObjectCollection getExceptionRecord() {
        QFilter filter = this.getFilter();
        log.info("\u8fc7\u6ee4\u6761\u4ef6filter:" + filter);
        return QueryServiceHelper.query((String)"task_exceptionrecord", (String)this.getSelectField(), (QFilter[])new QFilter[]{filter}, null, (int)1000);
    }

    private String getSelectField() {
        return "*";
    }

    private QFilter getFilter() {
        QFilter notRetryFilter = new QFilter("retrycounts", "=", (Object)NumberUtils.INTEGER_ZERO);
        QFilter retryFilter = new QFilter("retrycounts", ">", (Object)NumberUtils.INTEGER_ZERO).and(new QFilter("retrycounts", "<", (Object)6));
        Date timeLimit = this.getTimeLimit();
        QFilter failureTimeFilter = new QFilter("failuretime", "<=", (Object)timeLimit);
        QFilter retryTimeFilter = new QFilter("retrytime", "<=", (Object)timeLimit);
        QFilter notRetryAndFailureTimeFilter = notRetryFilter.and(failureTimeFilter);
        QFilter retryAndRetryTimeFilter = retryFilter.and(retryTimeFilter);
        QFilter timeFilter = notRetryAndFailureTimeFilter.or(retryAndRetryTimeFilter);
        QFilter compensateStatusFilter = new QFilter("compensatestatus", "=", (Object)CompensateStatusEnum.FAILURE.getValue());
        QFilter needCompensateFilter = new QFilter("iscompensate", "=", (Object)NotCompensateEnum.Y_COMPENSATE.getValue());
        return compensateStatusFilter.and(timeFilter).and(needCompensateFilter);
    }

    private Date getTimeLimit() {
        Calendar currentTime = Calendar.getInstance();
        currentTime.add(12, -5);
        return currentTime.getTime();
    }
}

