/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.mircoservice.exception;

import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.ssc.mircoservice.result.BaseErrorCode;
import kd.ssc.mircoservice.result.ServiceResult;

public class BizExceptionUtils {
    private static Log logger = LogFactory.getLog(BizExceptionUtils.class);

    public static <T> void handle(Exception e, ServiceResult<T> result) {
        try {
            if (e instanceof KDException) {
                KDException kdException = (KDException)e;
                ErrorCode errorCode = kdException.getErrorCode();
                if (result != null) {
                    result.setCodeAndMessage(errorCode.getCode(), kdException.getMessage());
                }
                if (logger.isErrorEnabled()) {
                    logger.error("Service occur customized exception:" + errorCode.getCode() + "," + kdException.getMessage());
                }
            } else {
                BizExceptionUtils.handleUnexpectedException(e, result);
            }
        }
        catch (Exception ex) {
            BizExceptionUtils.handleUnexpectedException(ex, result);
        }
    }

    private static <T> void handleUnexpectedException(Exception e, ServiceResult<T> result) {
        if (logger.isErrorEnabled()) {
            logger.error("Service occur exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        if (result != null) {
            result.setCodeAndMessage(BaseErrorCode.FAILURE);
        }
    }
}

