/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.mircoservice.result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.service.GenericServiceResult;
import kd.ssc.mircoservice.result.BaseErrorCode;

public class ServiceResult<T>
extends GenericServiceResult<T> {
    private static final long serialVersionUID = -3887079302901783119L;

    public static <T> ServiceResult<T> succeed(T data) {
        return new ServiceResult<T>(BaseErrorCode.SUCCESS, data);
    }

    public static <T> ServiceResult<T> fail() {
        return new ServiceResult<T>(BaseErrorCode.FAILURE);
    }

    public ServiceResult() {
        super(Boolean.TRUE, BaseErrorCode.SUCCESS.getCode(), BaseErrorCode.SUCCESS.getMessage());
    }

    public ServiceResult(String code, String message) {
        super(Boolean.valueOf(BaseErrorCode.SUCCESS.getCode().equals(code)), code, message);
    }

    public ServiceResult(String code, String message, T data) {
        super(Boolean.valueOf(BaseErrorCode.SUCCESS.getCode().equals(code)), code, message, data);
    }

    public ServiceResult(ErrorCode errorCode) {
        super(Boolean.valueOf(BaseErrorCode.SUCCESS.getCode().equals(errorCode.getCode())), errorCode.getCode(), errorCode.getMessage());
    }

    public ServiceResult(ErrorCode errorCode, T data) {
        super(Boolean.valueOf(BaseErrorCode.SUCCESS.getCode().equals(errorCode.getCode())), errorCode.getCode(), errorCode.getMessage(), data);
    }

    public ServiceResult(T data) {
        super(Boolean.TRUE, BaseErrorCode.SUCCESS.getCode(), BaseErrorCode.SUCCESS.getMessage(), data);
    }

    public void setCodeAndMessage(String code, String message) {
        super.setCode(code);
        super.setMessage(message);
        super.setSuccess(Boolean.valueOf(BaseErrorCode.SUCCESS.getCode().equals(code)));
    }

    public void setCodeAndMessage(ErrorCode errorCode) {
        super.setCode(errorCode.getCode());
        super.setMessage(errorCode.getMessage());
        super.setSuccess(Boolean.valueOf(BaseErrorCode.SUCCESS.getCode().equals(errorCode.getCode())));
    }

    public JSONObject toJSONObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", super.getCode());
        map.put("message", super.getMessage());
        map.put("success", super.getSuccess());
        map.put("data", super.getData());
        return new JSONObject(map);
    }

    public String toJSONString() {
        return JSON.toJSONString((Object)((Object)this));
    }

    public ApiResult toApiResult() {
        ApiResult apiResult = null;
        apiResult = this.getSuccess() != false ? ApiResult.success((Object)this.getData()) : ApiResult.fail((String)this.getMessage(), (String)this.getCode());
        return apiResult;
    }

    public ApiResult toApiResultWithoutData() {
        ApiResult apiResult = null;
        apiResult = this.getSuccess() != false ? ApiResult.success(null) : ApiResult.fail((String)this.getMessage(), (String)this.getCode());
        return apiResult;
    }

    public String toString() {
        return "ServiceResult{}" + super.toString();
    }
}

