/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.monitor.pojo;

import java.util.Comparator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.monitor.ExceptionStatusEnum;
import kd.ssc.monitor.pojo.MonitorRecord;
import kd.ssc.monitor.pojo.SSCTraceInfo;

public class SSCTraceInfos {
    public void saveTranceInfo(SSCTraceInfo traceInfo) {
        if (traceInfo == null) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("excep_billid", "=", (Object)traceInfo.getBillId()), new QFilter("taskbill", "=", (Object)traceInfo.getBillType()), new QFilter("ssc", "=", (Object)traceInfo.getSsc()), new QFilter("scenario", "=", (Object)traceInfo.getScenario()), new QFilter("tasktype", "=", (Object)traceInfo.getTaskTypeId()), new QFilter("status", "=", (Object)ExceptionStatusEnum.UN_PROCESSED.getValue())};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"ssc_exception", (QFilter[])qFilters);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ssc_exception");
            long sscId = traceInfo.getSsc();
            dynamicObject.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"ssc_exception", (DynamicObject)dynamicObject, (String)String.valueOf(sscId)));
            dynamicObject.set("excep_billid", (Object)traceInfo.getBillId());
            dynamicObject.set("excep_billno", (Object)traceInfo.getBillNo());
            dynamicObject.set("taskbill", (Object)traceInfo.getBillType());
            dynamicObject.set("tasktype", (Object)traceInfo.getTaskTypeId());
            dynamicObject.set("scenario", (Object)traceInfo.getScenario());
            dynamicObject.set("excep_first_time", (Object)traceInfo.getMonitorRecordList().get(0).getMonitorTime());
            dynamicObject.set("ssc", (Object)sscId);
            dynamicObject.set("status", (Object)ExceptionStatusEnum.UN_PROCESSED.getValue());
        }
        dynamicObject.set("taskid", (Object)traceInfo.getTaskId());
        dynamicObject.set("retryparam", (Object)traceInfo.getRetry());
        dynamicObject.set("bizAttribute", (Object)traceInfo.getBizAttribute());
        dynamicObject.set("excep_latest_time", (Object)traceInfo.getMonitorRecordList().get(0).getMonitorTime());
        DynamicObjectCollection monitorEntry = dynamicObject.getDynamicObjectCollection("monitor_entry");
        if (monitorEntry.size() > 10) {
            monitorEntry.sort(Comparator.comparing(a -> a.getDate("monitor_time")));
            monitorEntry.remove(1);
        }
        for (MonitorRecord monitorRecord : traceInfo.getMonitorRecordList()) {
            DynamicObject monitor = monitorEntry.addNew();
            monitor.set("monitor_time", (Object)monitorRecord.getMonitorTime());
            monitor.set("execute_method", (Object)monitorRecord.getExecuteMethod());
            monitor.set("executor", (Object)monitorRecord.getExecutor());
            monitor.set("log_detail", (Object)monitorRecord.getLog());
            monitor.set("traceid", (Object)monitorRecord.getTraceId());
        }
        for (int i = 0; i < monitorEntry.size(); ++i) {
            ((DynamicObject)monitorEntry.get(i)).set("seq", (Object)(monitorEntry.size() - i));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

