/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.monitor.sort;

import java.security.SecureRandom;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.ssc.monitor.sort.EntitySort;

public class EntityQuickSort
extends EntitySort {
    public EntityQuickSort(DynamicObjectCollection data, String timeField) {
        super(data, timeField);
    }

    @Override
    public void handle() {
        if (this.getLength() > 1) {
            this.handleSort(1, this.getLength());
        }
    }

    private void handleSort(int leftIndex, int rightIndex) {
        if (rightIndex - leftIndex >= 1 && leftIndex >= 1 && rightIndex <= this.getLength()) {
            int pivotIndex = this.getNextPivotIndex(leftIndex, rightIndex);
            this.handleSort(leftIndex, pivotIndex - 1);
            this.handleSort(pivotIndex + 1, rightIndex);
        }
    }

    private int getNextPivotIndex(int leftIndex, int rightIndex) {
        this.optimizeOnPivot(leftIndex, rightIndex);
        DynamicObject pivotValue = this.getElement(leftIndex);
        Date date = pivotValue.getDate(this.timeField);
        int compareSign = 1;
        while (leftIndex != rightIndex) {
            if (compareSign == 1) {
                DynamicObject rightDo = this.getElement(rightIndex);
                Date date1 = rightDo.getDate(this.timeField);
                if (date.before(date1)) {
                    this.setElement(leftIndex, rightDo);
                    compareSign = 2;
                    ++leftIndex;
                    continue;
                }
                --rightIndex;
                continue;
            }
            DynamicObject leftDo = this.getElement(leftIndex);
            Date date2 = leftDo.getDate(this.timeField);
            if (date2.before(date)) {
                this.setElement(rightIndex, leftDo);
                compareSign = 1;
                --rightIndex;
                continue;
            }
            ++leftIndex;
        }
        int pivotIndex = leftIndex;
        this.setElement(pivotIndex, pivotValue);
        return pivotIndex;
    }

    private void optimizeOnPivot(int leftIndex, int rightIndex) {
        int randomPivotIndex = (int)((double)leftIndex + new SecureRandom().nextDouble() * (double)(rightIndex - leftIndex + 1));
        this.swapElement(leftIndex, randomPivotIndex);
    }
}

