/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.builder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.smartApproval.enums.BillFieldSourceEnum;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.smartApproval.pojo.InputParameter;

public class InputParameterBuilder {
    private Map<Long, InputParameter> taskMap;
    private Map<Long, Long> taskIdMap;
    private Map<Long, List<InputParameter>> creatorMap;
    private Map<Long, List<InputParameter>> orgMap;
    private Map<String, Map<Long, List<InputParameter>>> billMap;
    private static final Log log = LogFactory.getLog((String)"InputParameterBuilder");

    public List<InputParameter> buildParameter(List<Long> taskIds) {
        if (taskIds == null || taskIds.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            int size = taskIds.size();
            this.taskMap = new HashMap<Long, InputParameter>(size);
            this.taskIdMap = new HashMap<Long, Long>(size);
            this.creatorMap = new HashMap<Long, List<InputParameter>>(size);
            this.orgMap = new HashMap<Long, List<InputParameter>>(size);
            this.billMap = new HashMap<String, Map<Long, List<InputParameter>>>(size);
            this.buildParameterWithTask(taskIds);
            this.buildParameterWithConfig();
            this.buildParameterWithCreditInfo();
            this.buildParameterWithOrgInfo();
            this.buildParameterWithUserInfo();
            this.buildParameterWithWithDrawal();
            this.buildParameterWithBreakRule();
            this.buildParameterWithOperation();
            this.buildParameterWithIDISchemaResult();
            return new ArrayList<InputParameter>(this.taskMap.values());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public InputParameter buildSingleParameter(long taskId) {
        if (taskId <= 0L) {
            return null;
        }
        this.taskMap = new HashMap<Long, InputParameter>(1);
        this.taskIdMap = new HashMap<Long, Long>(1);
        this.creatorMap = new HashMap<Long, List<InputParameter>>(1);
        this.orgMap = new HashMap<Long, List<InputParameter>>(1);
        this.billMap = new HashMap<String, Map<Long, List<InputParameter>>>(1);
        this.buildParameterWithSingleTask(taskId);
        this.buildParameterWithConfig();
        this.buildParameterWithCreditInfo();
        this.buildParameterWithOrgInfo();
        this.buildParameterWithUserInfo();
        this.buildParameterWithIDISchemaResult();
        ArrayList<InputParameter> values = new ArrayList<InputParameter>(this.taskMap.values());
        if (values.size() == 1) {
            return (InputParameter)values.get(0);
        }
        return null;
    }

    private void buildParameterWithIDISchemaResult() {
        Set<Long> longs = this.taskIdMap.keySet();
        if (longs.isEmpty()) {
            longs = this.taskMap.keySet();
        }
        Map<Long, IDISchemaResult> resultMap = IDISchemaResult.getSchemaResult(longs);
        Set<Map.Entry<Long, IDISchemaResult>> entries = resultMap.entrySet();
        for (Map.Entry<Long, IDISchemaResult> entry : entries) {
            String vectorValue;
            Long key = entry.getKey();
            IDISchemaResult schemaResult = entry.getValue();
            InputParameter inputParameter = this.taskMap.get(key);
            if (inputParameter == null) {
                Long hisId = this.taskIdMap.get(key);
                if (hisId == null) continue;
                inputParameter = this.taskMap.get(hisId);
            }
            String string = vectorValue = schemaResult == null ? "" : schemaResult.getVectorValue();
            if (inputParameter == null) continue;
            inputParameter.setFruleresult(vectorValue);
        }
    }

    private void buildParameterWithOperation() {
        Set<Long> taskIds;
        QFilter qFilter;
        String selectField;
        DynamicObjectCollection operationInfos;
        if (!this.taskMap.isEmpty() && (operationInfos = QueryServiceHelper.query((String)"task_taskhistory", (String)(selectField = "id, decisionitem"), (QFilter[])(qFilter = new QFilter("id", "in", taskIds = this.taskMap.keySet())).toArray())) != null) {
            for (DynamicObject operationInfo : operationInfos) {
                Object decisionItem;
                Long taskid = operationInfo.getLong("id");
                InputParameter buildParam = this.taskMap.get(taskid);
                if (buildParam == null || (decisionItem = operationInfo.get("decisionitem")) == null) continue;
                buildParam.setOperation(decisionItem + "");
            }
        }
    }

    private void buildParameterWithBreakRule() {
        Set<Long> taskIds;
        QFilter qFilter;
        String selectField;
        DynamicObjectCollection breakRuleInfos;
        if (!this.taskMap.isEmpty() && (breakRuleInfos = QueryServiceHelper.query((String)"task_crebreakrulerecord", (String)(selectField = "histaskid,subscorerule"), (QFilter[])(qFilter = new QFilter("histaskid", "in", taskIds = this.taskMap.keySet())).toArray())) != null) {
            HashMap<Long, List> breakRuleMap = new HashMap<Long, List>(16);
            for (DynamicObject breakRuleInfo : breakRuleInfos) {
                long taskid = breakRuleInfo.getLong("histaskid");
                List breakRuleList = breakRuleMap.computeIfAbsent(taskid, v -> new ArrayList(8));
                breakRuleList.add(breakRuleInfo.get("subscorerule") + "");
            }
            for (Map.Entry entry : breakRuleMap.entrySet()) {
                Long taskid = (Long)entry.getKey();
                List breakRuleList = (List)entry.getValue();
                InputParameter buildParam = this.taskMap.get(taskid);
                if (buildParam == null || breakRuleList.isEmpty()) continue;
                buildParam.setBreakrule(breakRuleList);
            }
        }
    }

    private void buildParameterWithWithDrawal() {
        Set<Long> taskIds;
        QFilter qFilter;
        String selectField;
        DynamicObjectCollection withdrawalIndos;
        if (!this.taskIdMap.isEmpty() && (withdrawalIndos = QueryServiceHelper.query((String)"task_withdrawal_unpass", (String)(selectField = "taskid,withdrawal"), (QFilter[])(qFilter = new QFilter("taskid", "in", taskIds = this.taskIdMap.keySet())).toArray())) != null) {
            HashMap<Long, List> withdrawMap = new HashMap<Long, List>(16);
            for (DynamicObject withdrawInfo : withdrawalIndos) {
                long taskid = withdrawInfo.getLong("taskid");
                Long hisTaskId = this.taskIdMap.get(taskid);
                if (hisTaskId == null || hisTaskId < 0L) continue;
                List withdrawList = withdrawMap.computeIfAbsent(hisTaskId, v -> new ArrayList(8));
                withdrawList.add(withdrawInfo.get("withdrawal") + "");
            }
            for (Map.Entry entry : withdrawMap.entrySet()) {
                Long hisTaskId = (Long)entry.getKey();
                List withdrawList = (List)entry.getValue();
                InputParameter buildParam = this.taskMap.get(hisTaskId);
                if (buildParam == null || withdrawList.isEmpty()) continue;
                buildParam.setWithdrawal(withdrawList);
            }
        }
    }

    private void buildParameterWithUserInfo() {
        if (!this.creatorMap.isEmpty()) {
            QFilter qFilter;
            String selectField;
            DynamicObjectCollection userInfo4Qrys;
            Set<Long> innerResult_creatorids = this.creatorMap.keySet();
            List userInfos = UserServiceHelper.get(new ArrayList<Long>(innerResult_creatorids));
            if (userInfos != null) {
                for (Map userInfo : userInfos) {
                    Long creatorid = Long.valueOf(userInfo.get("id") + "");
                    List<InputParameter> buildParams = this.creatorMap.get(creatorid);
                    if (buildParams == null) continue;
                    for (InputParameter buildParam : buildParams) {
                        buildParam.setFgender(userInfo.get("gender") + "");
                        buildParam.setFusertype(userInfo.get("usertype") + "");
                    }
                }
            }
            if ((userInfo4Qrys = QueryServiceHelper.query((String)"bos_user", (String)(selectField = "id,createtime"), (QFilter[])(qFilter = new QFilter("id", "in", innerResult_creatorids)).toArray())) != null) {
                for (DynamicObject userInfo : userInfo4Qrys) {
                    Long creatorid = userInfo.getLong("id");
                    List<InputParameter> buildParams = this.creatorMap.get(creatorid);
                    if (buildParams == null) continue;
                    for (InputParameter buildParam : buildParams) {
                        buildParam.setFcreatetime_user(userInfo.getDate("createtime"));
                    }
                }
            }
        }
    }

    private void buildParameterWithOrgInfo() {
        Set<Long> innerResult_orgids;
        QFilter qFilter;
        String selectField;
        DynamicObjectCollection orgInfos;
        if (!this.orgMap.isEmpty() && (orgInfos = QueryServiceHelper.query((String)"bos_org", (String)(selectField = "id,fyzjimorted,orgpattern,fispurchase,fissale,fisinventory,fisaccounting,createtime,isbizorg"), (QFilter[])(qFilter = new QFilter("id", "in", innerResult_orgids = this.orgMap.keySet())).toArray())) != null) {
            for (DynamicObject orgInfo : orgInfos) {
                Long orgid = orgInfo.getLong("id");
                List<InputParameter> buildParams = this.orgMap.get(orgid);
                if (buildParams == null) continue;
                for (InputParameter buildParam : buildParams) {
                    buildParam.setForgpatternid(orgInfo.get("orgpattern") + "");
                    buildParam.setFcreatetime_org(orgInfo.getDate("createtime"));
                    buildParam.setFyzjimported(orgInfo.getBoolean("fyzjimorted") ? "1" : "0");
                    buildParam.setFispurchase(orgInfo.getBoolean("fispurchase") ? "1" : "0");
                    buildParam.setFissale(orgInfo.getBoolean("fissale") ? "1" : "0");
                    buildParam.setFisinventory(orgInfo.getBoolean("fisinventory") ? "1" : "0");
                    buildParam.setFisaccounting(orgInfo.getBoolean("fisaccounting") ? "1" : "0");
                    buildParam.setFisbizorg(orgInfo.getBoolean("isbizorg") ? "1" : "0");
                }
            }
        }
    }

    private void buildParameterWithCreditInfo() {
        Set<Long> innerResult_creatorids;
        QFilter qFilter;
        String selectField;
        DynamicObjectCollection userCreditInfos;
        if (!this.creatorMap.isEmpty() && (userCreditInfos = QueryServiceHelper.query((String)"task_creditfiles", (String)(selectField = "creditlevel,creditvalue,user,unqualifiedtotalnum"), (QFilter[])(qFilter = new QFilter("user", "in", innerResult_creatorids = this.creatorMap.keySet())).toArray())) != null) {
            for (DynamicObject userCreditInfo : userCreditInfos) {
                Long userid = userCreditInfo.getLong("user");
                List<InputParameter> buildParams = this.creatorMap.get(userid);
                if (buildParams == null) continue;
                for (InputParameter buildParam : buildParams) {
                    buildParam.setFcreditlevel(userCreditInfo.get("creditlevel") + "");
                    buildParam.setFcreditvalue(Float.valueOf(userCreditInfo.get("creditvalue") + ""));
                    buildParam.setFuser(userCreditInfo.get("user") + "");
                    buildParam.setFunqualifiedtotalnum(Float.valueOf(userCreditInfo.get("unqualifiedtotalnum") + ""));
                }
            }
        }
    }

    private void buildParameterWithConfig() {
        if (!this.billMap.isEmpty()) {
            for (Map.Entry<String, Map<Long, List<InputParameter>>> entry : this.billMap.entrySet()) {
                String innerResult_bizbill = entry.getKey();
                Set<Long> innerResult_billids = entry.getValue().keySet();
                this.getMoneyFromConfig(innerResult_bizbill, innerResult_billids);
                this.getBizTypeFromConfig(innerResult_bizbill, innerResult_billids);
                this.getIsNeedImage(innerResult_bizbill, innerResult_billids);
            }
        }
    }

    private void getIsNeedImage(String innerResult_bizbill, Set<Long> innerResult_billids) {
        Map<Long, Object> configValueMap = this.getConfigValue(innerResult_bizbill, innerResult_billids, BillFieldSourceEnum.fisneedimage.getFieldName());
        Map<Long, List<InputParameter>> billChildMap = this.billMap.get(innerResult_bizbill);
        if (configValueMap != null && billChildMap != null) {
            for (Map.Entry<Long, Object> configEntry : configValueMap.entrySet()) {
                Long billid = configEntry.getKey();
                Object configValue = configEntry.getValue();
                List<InputParameter> buildParams = billChildMap.get(billid);
                if (buildParams == null) continue;
                for (InputParameter buildParam : buildParams) {
                    buildParam.setFisneedimage(configValue + "");
                }
            }
        }
    }

    private void getBizTypeFromConfig(String innerResult_bizbill, Set<Long> innerResult_billids) {
        Map<Long, Object> configValueMap = this.getConfigValue(innerResult_bizbill, innerResult_billids, BillFieldSourceEnum.ffeetype.getFieldName());
        Map<Long, List<InputParameter>> billChildMap = this.billMap.get(innerResult_bizbill);
        if (configValueMap != null && billChildMap != null) {
            for (Map.Entry<Long, Object> configEntry : configValueMap.entrySet()) {
                Long billid = configEntry.getKey();
                Object configValue = configEntry.getValue();
                List<InputParameter> buildParams = billChildMap.get(billid);
                if (buildParams == null) continue;
                for (InputParameter buildParam : buildParams) {
                    buildParam.setFfeetype(configValue + "");
                }
            }
        }
    }

    private void getMoneyFromConfig(String innerResult_bizbill, Set<Long> innerResult_billids) {
        Map<Long, Object> configValueMap = this.getConfigValue(innerResult_bizbill, innerResult_billids, BillFieldSourceEnum.fmoney.getFieldName());
        Map<Long, List<InputParameter>> billChildMap = this.billMap.get(innerResult_bizbill);
        for (Map.Entry<Long, Object> configEntry : configValueMap.entrySet()) {
            Long billid = configEntry.getKey();
            Object configValue = configEntry.getValue();
            float money = configValue instanceof Float || configValue instanceof Double || configValue instanceof Integer || configValue instanceof BigDecimal ? Float.parseFloat(configValue + "") : 0.0f;
            List<InputParameter> buildParams = billChildMap.get(billid);
            if (buildParams == null) continue;
            for (InputParameter buildParam : buildParams) {
                buildParam.setFmoney(Float.valueOf(money));
            }
        }
    }

    private Map<Long, Object> getConfigValue(String innerResult_bizbill, Set<Long> innerResult_billids, String configField) {
        QFilter entryFilter;
        QFilter titleFilter;
        String configFieldKey;
        DynamicObject configFieldInfo;
        HashMap<Long, Object> configValueMap = new HashMap<Long, Object>();
        if (StringUtils.isNotBlank((CharSequence)innerResult_bizbill) && !innerResult_billids.isEmpty() && (configFieldInfo = QueryServiceHelper.queryOne((String)"task_mapping_basefield", (String)(configFieldKey = "entryentity.mappedfieldnumber"), (QFilter[])new QFilter[]{titleFilter = new QFilter("billtype", "=", (Object)innerResult_bizbill), entryFilter = new QFilter("entryentity.billfieldsourcenumber", "=", (Object)configField)})) != null) {
            String fieldNum = configFieldInfo.getString("entryentity.mappedfieldnumber");
            String entityNum = this.getEntityNum(innerResult_bizbill);
            QFilter sourceFilter = new QFilter("id", "in", innerResult_billids);
            if (!StringUtils.isNotBlank((CharSequence)fieldNum)) {
                return configValueMap;
            }
            String selectField = "id," + fieldNum;
            DynamicObjectCollection sourceFieldInfos = QueryServiceHelper.query((String)entityNum, (String)selectField, (QFilter[])sourceFilter.toArray());
            if (sourceFieldInfos != null) {
                for (DynamicObject sourceFieldInfo : sourceFieldInfos) {
                    Long billid = sourceFieldInfo.getLong("id");
                    Object configFieldValue = sourceFieldInfo.get(fieldNum);
                    configValueMap.put(billid, configFieldValue);
                }
            }
        }
        return configValueMap;
    }

    private String getEntityNum(String innerResult_bizbill) {
        String selectField = "number";
        QFilter qFilter = new QFilter("id", "=", (Object)innerResult_bizbill);
        DynamicObject entityInfo = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)selectField, (QFilter[])qFilter.toArray());
        if (entityInfo != null) {
            return entityInfo.get("number") + "";
        }
        return "";
    }

    private void buildParameterWithTask(List<Long> taskIds) {
        String selectField = "id,billtype,orgid,sscid,imageok,creator,createtime,billid,state,sourcetaskid";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObjectCollection taskInfos = QueryServiceHelper.query((String)"task_taskhistory", (String)selectField, (QFilter[])qFilter.toArray());
        if (taskInfos != null) {
            for (DynamicObject task : taskInfos) {
                Long taskid = this.buildSingleParamter(task, true);
                if (taskid == null) continue;
                Long sourceTaskId = task.getLong("sourcetaskid");
                this.taskIdMap.put(sourceTaskId, taskid);
            }
        }
    }

    private void buildParameterWithSingleTask(long taskId) {
        String selectField = "id,billtype,orgid,sscid,imageok,creator,createtime,billid";
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)selectField, (QFilter[])qFilter.toArray());
        if (task != null) {
            this.buildSingleParamter(task, false);
        }
    }

    private Long buildSingleParamter(DynamicObject task, boolean isHis) {
        try {
            InputParameter buildParam = new InputParameter();
            Long taskid = task.getLong("id");
            String innerResult_bizbill = this.getBizbillId(task.getLong("billtype"));
            Long innerResult_orgid = task.getLong("orgid");
            Long innerResult_creatorid = task.getLong("creator");
            Long innerResult_billid = task.getLong("billid");
            buildParam.setFid(taskid + "");
            buildParam.setFbilltypeid(task.get("billtype") + "");
            buildParam.setForgid(task.get("orgid") + "");
            buildParam.setFsscid(task.get("sscid") + "");
            buildParam.setFimageok(task.get("imageok") + "");
            buildParam.setFcreatorid(task.get("creator") + "");
            buildParam.setFcreatetime(task.getDate("createtime"));
            buildParam.setFrecordtype(innerResult_bizbill);
            if (isHis) {
                buildParam.setFstate(task.get("state") + "");
            } else {
                buildParam.setFstate("");
            }
            this.taskMap.put(taskid, buildParam);
            List creatorList = this.creatorMap.computeIfAbsent(innerResult_creatorid, l -> new ArrayList(256));
            creatorList.add(buildParam);
            List orgList = this.orgMap.computeIfAbsent(innerResult_orgid, l -> new ArrayList(256));
            orgList.add(buildParam);
            Map childMap = this.billMap.computeIfAbsent(innerResult_bizbill, v -> new HashMap(32));
            List billList = childMap.computeIfAbsent(innerResult_billid, l -> new ArrayList(2));
            billList.add(buildParam);
            return taskid;
        }
        catch (Exception e) {
            log.error("Building task param error: " + task.getLong("id"), (Throwable)e);
            return null;
        }
    }

    private String getBizbillId(long fbilltypeid) {
        String selectField = "bindbill";
        QFilter qFilter = new QFilter("id", "=", (Object)fbilltypeid);
        DynamicObject bizBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)selectField, (QFilter[])qFilter.toArray());
        if (bizBill != null) {
            return bizBill.getString("bindbill");
        }
        return "";
    }
}

