/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.enums;

import java.util.Arrays;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public enum IDISchemaStatusEnum {
    SUCCESS("success"),
    DISABLE("disable"),
    EMPTY("empty"),
    NO_LICENSE("nolicense"),
    NO_START("nostart"),
    CALL_ERROR("callerror"),
    NO_RESULT("noresult"),
    UNDEFINED("undefined"),
    OLD_VERSION("oldversion");

    private static final Log LOG;
    private final String value;

    private IDISchemaStatusEnum(String value) {
        this.value = value;
    }

    public static IDISchemaStatusEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        Optional<IDISchemaStatusEnum> status = Arrays.stream(IDISchemaStatusEnum.values()).filter(v -> value.equals(v.value)).findFirst();
        if (status.isPresent()) {
            return status.get();
        }
        LOG.error(String.format("\u672a\u5b9a\u4e49\u7684\u6d1e\u5bdf\u72b6\u6001\uff1a%s\u9700\u53ca\u65f6\u8ddf\u8fdb\u3002", value));
        return UNDEFINED;
    }

    public String getValue() {
        return this.value;
    }

    public boolean schemaSuccess() {
        return this != CALL_ERROR && this != NO_RESULT;
    }

    static {
        LOG = LogFactory.getLog(IDISchemaStatusEnum.class);
    }
}

