/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.pojo;

import kd.ssc.smartApproval.enums.AIRiskLevel;
import kd.ssc.smartApproval.enums.IsPassEnum;
import kd.ssc.smartApproval.enums.IsSuccessEnum;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.smartApproval.pojo.SmartApprovalPredictedResult;

public class AIGeneralResult {
    private final long taskId;
    private final IDISchemaResult schemaResult;
    private final SmartApprovalPredictedResult predictResult;
    private IsPassEnum isPassEnum;
    private AIRiskLevel aiRiskLevel;

    public AIGeneralResult(long taskId, IDISchemaResult schemaResult, SmartApprovalPredictedResult predictedResult) {
        this.taskId = taskId;
        this.schemaResult = schemaResult;
        this.predictResult = predictedResult;
        this.generate();
    }

    private void generate() {
        if (this.schemaSuccess() && this.predictSuccess()) {
            this.isPassEnum = this.schemaResult.isPass() != false && this.predictResult.isPass() ? IsPassEnum.pass : IsPassEnum.unPass;
            this.aiRiskLevel = AIRiskLevel.getAIRiskLevel(this.predictResult.getIsPass(), this.schemaResult.isPass());
        } else if (this.predictSuccess()) {
            this.isPassEnum = this.predictResult.getIsPass();
            this.aiRiskLevel = AIRiskLevel.getAIRiskLevel(this.isPassEnum, null);
        } else if (this.schemaSuccess()) {
            this.isPassEnum = this.schemaResult.getSchemaPass();
            this.aiRiskLevel = null;
        }
    }

    public IDISchemaResult getSchemaResult() {
        return this.schemaResult;
    }

    public SmartApprovalPredictedResult getPredictResult() {
        return this.predictResult;
    }

    public IsPassEnum getIsPassEnum() {
        return this.isPassEnum;
    }

    public AIRiskLevel getAiRiskLevel() {
        return this.aiRiskLevel;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public boolean predictSuccess() {
        return this.predictResult != null && this.predictResult.getIsSuccess() == IsSuccessEnum.success;
    }

    public boolean schemaSuccess() {
        return this.schemaResult != null && this.schemaResult.isSchemaSuccess();
    }

    public Boolean isPass() {
        return this.isPassEnum == null ? null : Boolean.valueOf(this.isPassEnum == IsPassEnum.pass);
    }
}

