/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.pojo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.smartApproval.enums.IDISchemaStatusEnum;
import kd.ssc.smartApproval.enums.IsPassEnum;
import kd.ssc.task.dto.approve.DecisionResult;

public class IDISchemaResult {
    private long taskId;
    private long schemaScore;
    private IDISchemaStatusEnum schemaStatus;
    private IsPassEnum schemaPass;
    public static final long defaultScore = -1L;
    private static final Log LOG = LogFactory.getLog((String)"IDISchemaResult");

    public IDISchemaResult(long taskId) {
        this.taskId = taskId;
    }

    public IDISchemaResult(long taskId, Long schemaScore, IDISchemaStatusEnum schemaStatus, IsPassEnum schemaPass) {
        this.taskId = taskId;
        this.schemaScore = schemaScore;
        this.schemaStatus = schemaStatus;
        this.schemaPass = schemaPass;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public Long getSchemaScore() {
        return this.schemaScore;
    }

    public void setSchemaScore(Long schemaScore) {
        this.schemaScore = schemaScore;
    }

    public IDISchemaStatusEnum getSchemaStatus() {
        return this.schemaStatus;
    }

    public void setSchemaStatus(IDISchemaStatusEnum schemaStatus) {
        this.schemaStatus = schemaStatus;
    }

    public IsPassEnum getSchemaPass() {
        return this.schemaPass;
    }

    public void setSchemaPass(IsPassEnum schemaPass) {
        this.schemaPass = schemaPass;
    }

    public static Map<Long, IDISchemaResult> getSchemaResult(Collection<Long> taskIds) {
        HashMap<Long, IDISchemaResult> result = new HashMap<Long, IDISchemaResult>(taskIds.size());
        QFilter qTaskId = new QFilter("taskid", "in", taskIds);
        DynamicObjectCollection schemaStatusCol = QueryServiceHelper.query((String)"task_idischema_result", (String)"taskid,schemastatus,schemascore,schemapass", (QFilter[])qTaskId.toArray());
        if (schemaStatusCol != null) {
            for (DynamicObject dynamicObject : schemaStatusCol) {
                long taskId = dynamicObject.getLong("taskid");
                String status = dynamicObject.getString("schemastatus");
                long schemaScore = dynamicObject.getLong("schemascore");
                boolean pass = dynamicObject.getBoolean("schemapass");
                IsPassEnum schemaPass = pass ? IsPassEnum.pass : IsPassEnum.unPass;
                IDISchemaStatusEnum schemaStatus = IDISchemaStatusEnum.fromValue(status);
                IDISchemaResult idiSchemaResult = new IDISchemaResult(taskId, schemaScore, schemaStatus, schemaPass);
                result.put(taskId, idiSchemaResult);
            }
        }
        return result;
    }

    public static IDISchemaResult getSchemaResult(Long taskId) {
        return IDISchemaResult.getSchemaResult(Collections.singleton(taskId)).get(taskId);
    }

    public DynamicObject getIDISchemaResultDO() {
        QFilter[] qFilters = new QFilter("taskid", "=", (Object)this.taskId).toArray();
        DynamicObject resultObject = BusinessDataServiceHelper.loadSingle((String)"task_idischema_result", (QFilter[])qFilters);
        if (resultObject == null) {
            resultObject = BusinessDataServiceHelper.newDynamicObject((String)"task_idischema_result");
            resultObject.set("taskid", (Object)this.taskId);
        }
        return resultObject;
    }

    public void save() {
        QFilter[] qFilters = new QFilter("sourcetaskid", "=", (Object)this.taskId).toArray();
        boolean exists = QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])qFilters);
        if (exists) {
            LOG.error("\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u4e0d\u5141\u8bb8\u66f4\u65b0\u6d1e\u5bdf\u7ed3\u679c\u3002sourcetaskid\uff1a" + this.taskId);
            return;
        }
        DynamicObject idiSchemaResultDO = this.getIDISchemaResultDO();
        if (this.schemaStatus != null) {
            idiSchemaResultDO.set("schemastatus", (Object)this.schemaStatus.getValue());
        }
        idiSchemaResultDO.set("schemascore", (Object)this.schemaScore);
        if (this.schemaPass != null) {
            idiSchemaResultDO.set("schemapass", (Object)this.schemaPass.getCode());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{idiSchemaResultDO});
    }

    public void setBy(DecisionResult decisionResult) {
        if (decisionResult == null) {
            return;
        }
        this.schemaPass = decisionResult.isSucess() ? IsPassEnum.pass : IsPassEnum.unPass;
        this.schemaScore = decisionResult.getScore() == null ? -1L : decisionResult.getScore();
        this.schemaStatus = IDISchemaStatusEnum.fromValue(decisionResult.getStatus());
    }

    public String getVectorValue() {
        return this.schemaPass.getCode();
    }

    public Boolean isPass() {
        if (this.isSchemaSuccess()) {
            return this.schemaPass == IsPassEnum.pass;
        }
        return null;
    }

    public boolean isSchemaSuccess() {
        return this.schemaStatus == IDISchemaStatusEnum.OLD_VERSION || this.schemaStatus == IDISchemaStatusEnum.SUCCESS;
    }

    public String getSuggestDetail() {
        Boolean pass = this.isPass();
        if (pass == null) {
            return "";
        }
        if (pass.booleanValue()) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6240\u6709\u89c4\u5219\u68c0\u67e5\u9879\u5ba1\u6838\u901a\u8fc7\u3002", (String)"IDISchemaResult_1", (String)"ssc-task-common", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u90e8\u5206\u89c4\u5219\u68c0\u67e5\u9879\u5ba1\u6838\u4e0d\u901a\u8fc7\u3002", (String)"IDISchemaResult_0", (String)"ssc-task-common", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDISchemaResult that = (IDISchemaResult)o;
        return this.taskId == that.taskId && this.schemaScore == that.schemaScore && this.schemaStatus == that.schemaStatus && this.schemaPass == that.schemaPass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.schemaScore, this.schemaStatus, this.schemaPass});
    }

    public String toString() {
        return "IDISchemaResult{taskId=" + this.taskId + ", schemaScore=" + this.schemaScore + ", schemaStatus=" + (this.schemaStatus == null ? "null" : this.schemaStatus.getValue()) + ", schemaPass=" + (this.schemaPass == null ? "null" : this.schemaPass.getText()) + '}';
    }
}

