/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.predict;

import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.ssc.smartApproval.enums.IDISchemaStatusEnum;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.smartApproval.predict.NsynForecast;
import kd.ssc.task.dto.approve.DecisionResult;
import kd.ssc.task.helper.TaskBillChildQueryServiceHelper;
import kd.ssc.task.service.approve.impl.IntelligentDecisionServiceImpl;

public class IntelligentExecutor
implements Runnable,
Callable<IDISchemaResult> {
    private static final ThreadPool POOL_PREDICT = ThreadPools.newFixedThreadPool((String)"IntelligentExecutorPool", (int)2);
    private static final Log LOG = LogFactory.getLog((String)"IntelligentExecutor");
    private final long taskId;
    private final long taskTypeId;
    private final long billTypeId;
    private final String billId;
    private boolean asyncPredict = false;

    public IntelligentExecutor(long taskId, long taskTypeId, long billTypeId, String billId) {
        this.taskId = taskId;
        this.taskTypeId = taskTypeId;
        this.billTypeId = billTypeId;
        this.billId = billId;
    }

    public void setAsyncPredict(boolean asyncPredict) {
        LOG.info("\u8c03\u6574\u662f\u5426\u4e3a\u5f02\u6b65\u9884\u6d4b\uff1a" + asyncPredict);
        this.asyncPredict = asyncPredict;
    }

    public void execute() {
        POOL_PREDICT.execute((Runnable)this);
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            IDISchemaResult schemaResult = new IDISchemaResult(this.taskId);
            schemaResult.setSchemaStatus(IDISchemaStatusEnum.CALL_ERROR);
            schemaResult.save();
            LOG.error("\u8c03\u7528\u6570\u636e\u6d1e\u5bdf\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public IDISchemaResult call() {
        List<String> idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema(this.billTypeId, this.taskTypeId);
        IDISchemaResult schemaResult = new IDISchemaResult(this.taskId);
        if (idiSchemaList != null && !idiSchemaList.isEmpty()) {
            DynamicObject dataEntity = this.dataEntity();
            IntelligentDecisionServiceImpl decisionService = new IntelligentDecisionServiceImpl();
            DecisionResult decisionResult = decisionService.decisionAnalysis(this.taskId, null, dataEntity, idiSchemaList);
            schemaResult.setBy(decisionResult);
            schemaResult.save();
        }
        NsynForecast forecast = new NsynForecast(this.taskId, this.billId);
        if (this.asyncPredict) {
            POOL_PREDICT.execute((Runnable)forecast);
        } else {
            forecast.run();
        }
        return schemaResult;
    }

    private DynamicObject dataEntity() {
        DynamicObject dataEntity;
        String tmpStr;
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)this.taskId, (String)"task_task");
        String billId = taskObj.getString("billid");
        DynamicObject taskBill = BusinessDataServiceHelper.loadSingle((Object)this.billTypeId, (String)"task_taskbill");
        String billType = taskBill.getString("bindbill.number");
        Object bizDataTag = taskObj.get("bizdata_tag");
        String bizdata = null;
        if (bizDataTag != null && !StringUtils.isEmpty((String)(tmpStr = bizDataTag.toString()))) {
            bizdata = tmpStr;
        }
        if (bizdata == null) {
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType);
        } else {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)ORM.create().getDataEntityType(billType));
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
        }
        return dataEntity;
    }
}

