/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.predict;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.smartApproval.builder.InputParameterBuilder;
import kd.ssc.smartApproval.enums.AlgriModelNameEnum;
import kd.ssc.smartApproval.enums.IsSuccessEnum;
import kd.ssc.smartApproval.pojo.InputParameter;
import kd.ssc.smartApproval.util.TaskDataUploadHelper;

public class TaskApprovalForecast {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TASK_PREDICT_URL = "/record_check/predict";
    private static final CharSequence RET_OK = "0";
    private static final Log log = LogFactory.getLog(TaskApprovalForecast.class);

    /*
     * Enabled aggressive block sorting
     */
    public static void predict(long taskId, String billId) throws Exception {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"isEnableSmartApproval")});
        if (dynamicObject == null) return;
        if (!"true".equalsIgnoreCase(dynamicObject.getString("paramvalue"))) {
            return;
        }
        boolean lastTrainFailed = QueryServiceHelper.exists((String)"task_algri_mode", (QFilter[])new QFilter("threshold", "<", (Object)0).toArray());
        if (!lastTrainFailed) {
            TaskApprovalForecast.actualPredict(taskId, billId);
            return;
        }
        int getTrainResult = TaskDataUploadHelper.getModelTrainResult();
        if (getTrainResult == 0) {
            TaskApprovalForecast.actualPredict(taskId, billId);
            return;
        }
        if (getTrainResult == 1) {
            ErrorCode code = new ErrorCode("1", ResManager.loadKDString((String)"\u6a21\u578b\u6b63\u5728\u8bad\u7ec3\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"", (String)"", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        ErrorCode code = new ErrorCode("-2", ResManager.loadKDString((String)"\u6a21\u578b\u5c1a\u672a\u8bad\u7ec3\uff0c\u8bf7\u5148\u8bad\u7ec3\u6a21\u578b", (String)"", (String)"", (Object[])new Object[0]));
        throw new KDException(code, new Object[0]);
    }

    public static void actualPredict(long taskId, String billId) throws Exception {
        String url = TaskDataUploadHelper.getUrlSetting();
        if (StringUtils.isBlank((CharSequence)url)) {
            ErrorCode code = new ErrorCode("-3", ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        InputParameter parameter = new InputParameterBuilder().buildSingleParameter(taskId);
        if (parameter != null) {
            String input = TaskApprovalForecast.transTaskDataToJsonStr(parameter);
            log.info("\u8c03\u7528\u4efb\u52a1\u9884\u6d4b\u63a5\u53e3\uff0c\u5165\u53c2 " + input);
            String ret = TaskDataUploadHelper.executePostWithHeader(url + TASK_PREDICT_URL, input);
            log.info("\u8c03\u7528\u4efb\u52a1\u9884\u6d4b\u63a5\u53e3\uff0c\u8fd4\u56de\u7ed3\u679c " + ret);
            if (!TaskApprovalForecast.parseAndSaveResult(ret, billId)) {
                ErrorCode errorCode = new ErrorCode("-1", ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\u4efb\u52a1\u9884\u6d4b\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"TaskApprovalForecast_0", (String)"ssc-task-common", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[0]);
            }
        }
    }

    public static String transTaskDataToJsonStr(InputParameter parameter) {
        JSONObject dataJson = new JSONObject();
        JSONArray bodyArray = new JSONArray();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fid", (Object)parameter.getFid());
        jsonObject.put("fbilltypeid", (Object)parameter.getFbilltypeid());
        jsonObject.put("forgid", (Object)parameter.getForgid());
        jsonObject.put("fsscid", (Object)parameter.getFsscid());
        jsonObject.put("fimageok", (Object)parameter.getFimageok());
        jsonObject.put("fcreatorid", (Object)parameter.getFcreatorid());
        jsonObject.put("frecordtype", (Object)parameter.getFrecordtype());
        jsonObject.put("ffeetype", (Object)parameter.getFfeetype());
        jsonObject.put("fisneedimage", (Object)parameter.getFisneedimage());
        jsonObject.put("fcreditlevel", (Object)parameter.getFcreditlevel());
        jsonObject.put("funqualifiedtotalnum", (Object)parameter.getFunqualifiedtotalnum());
        jsonObject.put("fuser", (Object)parameter.getFuser());
        jsonObject.put("fyzjimported", (Object)parameter.getFyzjimported());
        jsonObject.put("forgpatternid", (Object)parameter.getForgpatternid());
        jsonObject.put("fispurchase", (Object)parameter.getFispurchase());
        jsonObject.put("fissale", (Object)parameter.getFissale());
        jsonObject.put("fisinventory", (Object)parameter.getFisinventory());
        jsonObject.put("fisaccounting", (Object)parameter.getFisaccounting());
        jsonObject.put("fisbizorg", (Object)parameter.getFisbizorg());
        jsonObject.put("fgender", (Object)parameter.getFgender());
        jsonObject.put("fusertype", (Object)parameter.getFusertype());
        jsonObject.put("fmoney", (Object)parameter.getFmoney());
        jsonObject.put("fcreditvalue", (Object)parameter.getFcreditvalue());
        jsonObject.put("fcreatetime", (Object)dateFormat.format(parameter.getFcreatetime()));
        jsonObject.put("fcreatetime_org", (Object)dateFormat.format(parameter.getFcreatetime_org()));
        jsonObject.put("fcreatetime_user", (Object)dateFormat.format(parameter.getFcreatetime_user()));
        jsonObject.put("fruleresult", (Object)parameter.getFruleresult());
        jsonObject.put("fstate", (Object)parameter.getFstate());
        jsonObject.put("fwithdrawal", parameter.getWithdrawal());
        jsonObject.put("fbreakrule", parameter.getBreakrule());
        jsonObject.put("foperation", (Object)parameter.getOperation());
        bodyArray.add((Object)jsonObject);
        dataJson.put("data", (Object)bodyArray);
        return dataJson.toJSONString();
    }

    public static boolean parseAndSaveResult(String ret, String billId) {
        if (StringUtils.isBlank((CharSequence)ret)) {
            return false;
        }
        boolean retIsNotEmpty = false;
        JSONObject resultObj = JSONObject.parseObject((String)ret);
        String code = resultObj.getString("code");
        if (StringUtils.equals((CharSequence)code, (CharSequence)RET_OK)) {
            JSONObject actualRet;
            JSONArray resultJsonArr = resultObj.getJSONArray("result");
            if (resultJsonArr != null && !resultJsonArr.isEmpty() && (actualRet = resultJsonArr.getJSONObject(0)) != null) {
                try {
                    TaskApprovalForecast.savePredictResult(ret, actualRet, billId);
                }
                catch (Exception e) {
                    ErrorCode errorCode = new ErrorCode("-1", ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\u4efb\u52a1\u9884\u6d4b\uff0c\u8fd4\u56de\u7ed3\u679c\u4e0d\u7b26\u5408\u7ea6\u5b9a\uff0c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790", (String)"", (String)"", (Object[])new Object[0]));
                    throw new KDException((Throwable)e, errorCode, new Object[0]);
                }
                retIsNotEmpty = true;
            }
        } else {
            String errMsg = resultObj.getString("err");
            ErrorCode errCode = new ErrorCode("-1", errMsg);
            throw new KDException(errCode, new Object[0]);
        }
        return retIsNotEmpty;
    }

    private static void savePredictResult(String ret, JSONObject actualRet, String billId) {
        long taskId = Long.parseLong(actualRet.getString("fid"));
        double unpassRate = actualRet.getDoubleValue("unpass");
        Map.Entry<Boolean, Double> analysisRate = TaskApprovalForecast.analysisRate(unpassRate);
        if (analysisRate == null) {
            ErrorCode errorCode = new ErrorCode("-1", ResManager.loadKDString((String)"\u6a21\u578b\u5c1a\u672a\u8bad\u7ec3\uff0c\u8bf7\u5148\u6267\u884c\u5b9a\u65f6\u4efb\u52a1", (String)"", (String)"", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        String unpass = actualRet.getString("lime_unpass");
        unpass = TaskApprovalForecast.formatValue(unpass, 600);
        String recommendWithdrawal = actualRet.getString("fwithdrawal");
        recommendWithdrawal = TaskApprovalForecast.formatValue(recommendWithdrawal, 100);
        String recommendBreakrule = actualRet.getString("fbreakrule");
        recommendBreakrule = TaskApprovalForecast.formatValue(recommendBreakrule, 100);
        String recommendOperation = actualRet.getString("foperation");
        recommendOperation = TaskApprovalForecast.formatValue(recommendOperation, 100);
        String similarTasks = actualRet.getString("similar_task");
        similarTasks = TaskApprovalForecast.formatValue(similarTasks, 150);
        DynamicObject saveDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_approval_result");
        saveDyo.set("taskid", (Object)taskId);
        saveDyo.set("predictsuccess", (Object)IsSuccessEnum.success.getCode());
        saveDyo.set("predictresult_tag", (Object)ret);
        saveDyo.set("predictpass", (Object)(analysisRate.getKey() != false ? 0 : 1));
        saveDyo.set("predictpassratio", (Object)analysisRate.getValue());
        saveDyo.set("affect", (Object)unpass);
        saveDyo.set("withdrawal", (Object)recommendWithdrawal);
        saveDyo.set("operation", (Object)recommendOperation);
        saveDyo.set("breakrule", (Object)recommendBreakrule);
        saveDyo.set("similartask", (Object)similarTasks);
        saveDyo.set("predicttime", (Object)new Date());
        if (StringUtils.isNotEmpty((CharSequence)billId)) {
            saveDyo.set("billid", (Object)billId);
        }
        try (TXHandle h = TX.requiresNew((String)"ssc_task_TaskApprovalForecast");){
            try {
                DeleteServiceHelper.delete((String)"task_approval_result", (QFilter[])new QFilter("taskid", "=", (Object)taskId).toArray());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static String formatValue(String value, int length) {
        if (value.length() > length) {
            value = value.substring(0, length);
            int lastIndex = value.lastIndexOf(44);
            value = value.substring(0, lastIndex);
            value = value + "]";
        }
        return value;
    }

    private static Map.Entry<Boolean, Double> analysisRate(double unpassRate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("threshold", ">", (Object)0));
        filters.add(new QFilter("number", "=", (Object)AlgriModelNameEnum.UNPASS.getNumber()));
        DynamicObjectCollection records = QueryServiceHelper.query((String)"TaskApprovalForecast.analysisRate", (String)"task_algri_mode", (String)"threshold", (QFilter[])filters.toArray(new QFilter[0]), (String)"lasttraintime desc,createtime desc", (int)1);
        if (records == null || records.isEmpty()) {
            return null;
        }
        double threshold = ((DynamicObject)records.get(0)).getBigDecimal("threshold").doubleValue();
        boolean unpass = true;
        if (unpassRate < threshold) {
            unpass = false;
            unpassRate = (threshold - unpassRate) / (2.0 * threshold) + 0.5;
        }
        return new AbstractMap.SimpleEntry<Boolean, Double>(unpass, unpassRate);
    }
}

