/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartcs.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.ssc.smartcs.enums.OperationEnum;
import kd.ssc.smartcs.parameter.AbstractAIMetaParameter;
import kd.ssc.smartcs.parameter.AreaParameter;
import kd.ssc.smartcs.product.AbstractAIMetaProduct;
import kd.ssc.smartcs.result.AreaResult;

public class AreaProduct
extends AbstractAIMetaProduct {
    public AreaProduct() {
    }

    public AreaProduct(AbstractAIMetaParameter inputParameter) {
        super(inputParameter);
    }

    @Override
    public void add() {
        String input = this.getAddInput();
        String output = this.invoke(OperationEnum.ADD_DOMAIN, input);
        boolean callSuccess = this.parseAddResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.ADD_DOMAIN.getOperate(), this.getInputParameterJson());
    }

    @Override
    public void update() {
        String input = this.getUpdateInput();
        String output = this.invoke(OperationEnum.EDIT_DOMAIN, input);
        boolean callSuccess = this.parseUpdateResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.EDIT_DOMAIN.getOperate(), this.getInputParameterJson());
    }

    @Override
    public void bdelete() {
        String input = this.getDeleteInput();
        String output = this.invoke(OperationEnum.DEL_DOMAIN, input);
        boolean callSuccess = this.parseDeleteResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.DEL_DOMAIN.getOperate(), this.getInputParameterJson());
    }

    @Override
    protected boolean parseResult(String outputJson) {
        this.setResult(new AreaResult());
        return super.parseResult(outputJson);
    }

    private String getAddInput() {
        HashMap<String, Object> input = new HashMap<String, Object>(2);
        input.put("skillId", ((AreaParameter)this.getInputParameter()).getSkillId());
        input.put("obj", this.getAddInputParamMap());
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getAddInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(5);
        AreaParameter parameter = (AreaParameter)this.getInputParameter();
        input.put("name", parameter.getName());
        input.put("number", parameter.getNumber());
        input.put("desc", parameter.getDescription());
        List<Map<String, Object>> permissionOrgns = this.getPermissionOrgns(parameter.getUseScc(), parameter.getUseRole());
        input.put("permissionOrgans", permissionOrgns);
        return input;
    }

    private List<Map<String, Object>> getPermissionOrgns(Map<Long, String> useScc, Map<String, String> roles) {
        ArrayList<Map<String, Object>> useOrgList = new ArrayList<Map<String, Object>>(useScc.size());
        for (Map.Entry<Long, String> entry : useScc.entrySet()) {
            String orgId = String.valueOf(entry.getKey());
            String orgName = entry.getValue();
            HashMap<String, String> orgInfo = new HashMap<String, String>(3);
            orgInfo.put("orgId", orgId);
            orgInfo.put("orgName", orgName);
            orgInfo.put("rangeKind", "share_center");
            useOrgList.add(orgInfo);
        }
        for (Map.Entry<Object, String> entry : roles.entrySet()) {
            HashMap<String, String> roleInfo = new HashMap<String, String>(3);
            String roleId = (String)entry.getKey();
            String roleName = entry.getValue();
            roleInfo.put("orgId", roleId);
            roleInfo.put("orgName", roleName);
            roleInfo.put("rangeKind", "role");
            useOrgList.add(roleInfo);
        }
        return useOrgList;
    }

    private boolean parseAddResult(String output) throws KDException {
        boolean callSuccess = this.parseResult(output);
        if (callSuccess) {
            JSONObject resultJson = JSON.parseObject((String)output);
            AreaResult result = (AreaResult)this.getResult();
            JSONObject data = resultJson.getJSONObject("data");
            if (data != null) {
                Long areaId = data.getLong("id");
                Long qaId = data.getLong("qaId");
                result.setId(areaId);
                result.setQaId(qaId);
                result.setName(data.getString("name"));
                result.setNumber(data.getString("number"));
            }
        }
        return callSuccess;
    }

    private String getUpdateInput() {
        Map<String, Object> input = this.getUpdateInputParamMap();
        input.put("skillId", ((AreaParameter)this.getInputParameter()).getSkillId());
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getUpdateInputParamMap() {
        Map<String, Object> input = this.getAddInputParamMap();
        input.put("id", ((AreaParameter)this.getInputParameter()).getId());
        return input;
    }

    private boolean parseUpdateResult(String output) {
        return this.parseResult(output);
    }

    private String getDeleteInput() {
        return SerializationUtils.toJsonString(this.getDeleteInputParamMap());
    }

    private Map<String, Object> getDeleteInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(2);
        AreaParameter inputParam = (AreaParameter)this.getInputParameter();
        input.put("skillId", inputParam.getSkillId());
        input.put("ids", inputParam.getDeleteIds());
        return input;
    }

    private boolean parseDeleteResult(String output) {
        return this.parseResult(output);
    }
}

