/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartcs.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.ssc.smartcs.enums.OperationEnum;
import kd.ssc.smartcs.parameter.AbstractAIMetaParameter;
import kd.ssc.smartcs.parameter.KeywordsParameter;
import kd.ssc.smartcs.product.AbstractAIMetaProduct;
import kd.ssc.smartcs.result.KeywordResult;

public class KeywordsProduct
extends AbstractAIMetaProduct {
    public KeywordsProduct() {
    }

    public KeywordsProduct(AbstractAIMetaParameter inputParameter) {
        super(inputParameter);
    }

    @Override
    public void add() {
        String input = this.getAddInput();
        String output = this.invoke(OperationEnum.ADD_KEYWORD, input);
        boolean callSuccess = this.parseAddResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.ADD_KEYWORD.getOperate(), this.getInputParameterJson());
    }

    public Long queryKeyword() {
        String input = this.getQueryInput();
        String output = this.invoke(OperationEnum.GET_KEYWORD, input);
        Long keywordId = this.parseQueryResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, this.getResult().isCallSuccess(), this.getResult().getTraceId(), OperationEnum.GET_KEYWORD.getOperate(), this.getInputParameterJson());
        return keywordId;
    }

    @Override
    protected boolean parseResult(String outputJson) {
        this.setResult(new KeywordResult());
        return super.parseResult(outputJson);
    }

    private String getAddInput() {
        HashMap<String, Map<String, Object>> input = new HashMap<String, Map<String, Object>>(1);
        input.put("obj", this.getAddInputParamMap());
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getAddInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(2);
        KeywordsParameter parameter = (KeywordsParameter)this.getInputParameter();
        input.put("qaId", parameter.getQaId());
        input.put("keyword", parameter.getKeyword());
        return input;
    }

    private boolean parseAddResult(String output) {
        boolean callSuccess = this.parseResult(output);
        if (callSuccess) {
            KeywordResult result = (KeywordResult)this.getResult();
            JSONObject resultJson = JSON.parseObject((String)output);
            JSONObject data = resultJson.getJSONObject("data");
            Long id = data.getLong("id");
            result.setId(id);
        }
        return callSuccess;
    }

    private String getQueryInput() {
        HashMap<String, Map<String, Object>> input = new HashMap<String, Map<String, Object>>(1);
        input.put("obj", this.getQueryInputParamMap());
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getQueryInputParamMap() {
        return this.getAddInputParamMap();
    }

    private Long parseQueryResult(String output) {
        JSONArray list;
        JSONObject result;
        JSONObject data;
        Long keywordId = -1L;
        boolean callSuccess = this.parseResult(output);
        if (callSuccess && (data = (result = JSON.parseObject((String)output)).getJSONObject("data")) != null && (list = data.getJSONArray("list")) != null && list.size() > 0) {
            keywordId = list.getJSONObject(0).getLong("id");
        }
        return keywordId;
    }
}

