/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartcs.userperm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public abstract class AbstractUserAccessPerm {
    private static final Log log = LogFactory.getLog(AbstractUserAccessPerm.class);

    abstract long convert2KDCCUserId(String var1);

    public Map<String, Object> getPermInfo(String userId) {
        long kdccUserId = this.convert2KDCCUserId(userId);
        if (kdccUserId > 0L) {
            return this.ggetPermInfoByUserId(kdccUserId);
        }
        return null;
    }

    private Map<String, Object> ggetPermInfoByUserId(long kdccUserId) {
        if (kdccUserId <= 0L) {
            log.error("parameter error, userId = " + kdccUserId);
            return this.buildFailedResult();
        }
        long mainOrgId = UserServiceHelper.getUserMainOrgId((long)kdccUserId);
        if (mainOrgId <= 0L) {
            log.error(String.format("getUserMainOrgId() failed. userId=%s, mainOrgId=%s", kdccUserId, mainOrgId));
            return this.buildFailedResult();
        }
        Map accountOrgInfo = OrgUnitServiceHelper.getCompanyByAdminOrg((Long)mainOrgId);
        Long accountOrgId = (Long)accountOrgInfo.get("id");
        if (accountOrgId == null || accountOrgId == 0L) {
            log.error(String.format("getCompanyByAdminOrg() failed. userId=%s, mainOrgId=%s, accountOrgId=%s", kdccUserId, mainOrgId, accountOrgId));
            return this.buildFailedResult();
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        List sscIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"12", (Long)accountOrgId, (boolean)true);
        List sscIds_ = sscIds.stream().map(String::valueOf).collect(Collectors.toList());
        returnData.put("share_center", sscIds_);
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        Set rolesIds = permService.getRolesByUser(Long.valueOf(kdccUserId));
        List bizRolesIds = permService.getBizRolesByUserID(Long.valueOf(kdccUserId));
        List bizRolesIds_ = bizRolesIds.stream().map(String::valueOf).collect(Collectors.toList());
        rolesIds.removeAll(bizRolesIds_);
        rolesIds.add("1MDO9B9H4ED+");
        returnData.put("role", rolesIds);
        log.info(String.format("getPermSSCAndRoleByUserId(long userId). userId=%s, mainOrgId=%s, accountOrgId=%s, returnData=%s", kdccUserId, mainOrgId, accountOrgId, ((Object)returnData).toString()));
        return returnData;
    }

    private Map<String, Object> buildFailedResult() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        returnData.put("share_center", new ArrayList(1));
        returnData.put("role", Collections.singletonList("1MDO9B9H4ED+"));
        return returnData;
    }
}

