/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.ssc.enums.RespCodeEnum;
import kd.ssc.enums.Source;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.create.AbstractCreateTask;
import kd.ssc.task.dto.TaskLogRecordDTO;
import kd.ssc.task.face.ICreateTask4ExternalSystem;
import kd.ssc.task.ierp.TaskLogFacadeImpl;

public class CreateTask4ExternalSystem
extends AbstractCreateTask
implements ICreateTask4ExternalSystem {
    protected Map<String, Object> param;
    protected List<Map<String, Object>> attachmentIds;
    protected String extParam;
    private static final Log log = LogFactory.getLog(CreateTask4ExternalSystem.class);

    @Override
    public long createTask(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            log.error("param is null or empty");
            return 0L;
        }
        log.info("Create Task By External,param : " + param);
        this.param = param;
        try {
            return super.createTask();
        }
        catch (Exception e) {
            TaskLogRecordDTO tlr = TaskLogRecordDTO.builder().appId("ssc-task").errorMsg(e instanceof KDException ? ((KDException)e).getErrorCode().getCode() : e.getMessage()).errorStack(ExceptionUtil.getStackTrace(e, 1000)).respCode(RespCodeEnum.create_task_error.getValue()).voucher(param.get("billType") + "").voucherId(param.get("billId") + "").method("kd.ssc.task.create.CreateTask4ExternalSystem.createTask").param(param).retry(Boolean.FALSE).type("CreateTask4ExternalSystem").build();
            TaskLogFacadeImpl taskLogFacade = new TaskLogFacadeImpl();
            taskLogFacade.saveTaskLogRecord(tlr);
            log.error("kd.ssc.task.create.CreateTask4ExternalSystem.createTask# Create Task By External error : " + param, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncAttachment(Long taskID) {
        try {
            List oldList = AttachmentServiceHelper.getAttachments((String)this.billType.getString("bindbill.number"), (Object)this.billID, (String)"attachmentpanel");
            HashSet<String> fileNames = new HashSet<String>(16);
            for (Map map : oldList) {
                fileNames.add((String)map.get("name"));
            }
            if (this.attachmentIds == null) {
                return;
            }
            for (Map map : this.attachmentIds) {
                HashMap<String, Object> mqCusMap = new HashMap<String, Object>();
                mqCusMap.put("fileName", fileNames);
                mqCusMap.put("attachIDMap", map);
                mqCusMap.put("bindbillNumber", this.billType.getString("bindbill.number"));
                mqCusMap.put("billID", this.billID);
                mqCusMap.put("taskID", "" + taskID);
                log.info("attachID : " + map.get("id"));
                log.info("\u5165\u961fMQ");
                log.info("\u521b\u5efaMQ\u6210\u529f");
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.eas.ssc_attachment");){
                    pub.publish(mqCusMap);
                }
            }
        }
        catch (Exception e) {
            throw TaskKDExcetptionUtil.createKDException(e, TaskErrorCodeEnum.C_EXTERNALSYSTEM_SYNCATTA_EXCEPTION.getCode(), ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u540e\u540c\u6b65\u9644\u4ef6\u5931\u8d25\u3002", (String)"CreateTask4ExternalSystem_0", (String)"ssc-task-common", (Object[])new Object[0]), new Object[0]);
        }
    }

    private void saveExtParam(Long taskID) {
        try {
            DynamicObject taskExtParam = this.orm.newDynamicObject("task_ext_param");
            RequestContext requestContext = RequestContext.get();
            String userid = requestContext.getUserId();
            taskExtParam.set("taskid", (Object)taskID);
            taskExtParam.set("createdate", (Object)new Date());
            taskExtParam.set("creator", (Object)userid);
            taskExtParam.set("extparam_tag", (Object)this.extParam);
            boolean isStoreInDB = this.billType.getBoolean("isstoredindb");
            taskExtParam.set("isstoredindb", (Object)isStoreInDB);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskExtParam});
        }
        catch (Exception e) {
            throw TaskKDExcetptionUtil.createKDException(TaskErrorCodeEnum.C_EXTERNALSYSTEM_SAVEPARAM_EXCEPTION.getCode(), ResManager.loadKDString((String)"\u201c\u5916\u90e8\u7cfb\u7edf\u6269\u5c55\u53c2\u6570\u201d\u4fdd\u5b58\u5f02\u5e38\u3002", (String)"CreateTask4ExternalSystem_1", (String)"ssc-task-common", (Object[])new Object[0]), new Object[0]);
        }
    }

    @Override
    protected void afterPrepareTaskData() {
        Object object_attachmentIds;
        Map imageImap;
        Object object_billimage;
        Object object_procinstID;
        Object object_assignID;
        Object object_reverseOprtNumber;
        Object object_billID;
        Object object_applierId;
        this.source = Source.ExternalSystem.getValue();
        Object object_sysNumber = this.param.get("sourceSys");
        if (object_sysNumber != null) {
            String sysNumber = object_sysNumber.toString();
            this.extenderp = this.orm.queryOne("bas_extenderp", new QFilter[]{new QFilter("number", "=", (Object)sysNumber)});
        }
        if ((object_applierId = this.param.get("applierId")) != null) {
            String applierId = object_applierId.toString();
            try {
                Map innerOrgMap = SysIntegrationServiceHelper.getInternalData((Long)1L, (String)"bos_person", (String)applierId, null, null);
                if (innerOrgMap != null) {
                    this.applier = this.orm.newDynamicObject("bos_user");
                    this.applier.set("id", innerOrgMap.get("id"));
                    this.applier.set("number", innerOrgMap.get("number"));
                    this.applier.set("name", innerOrgMap.get("name"));
                }
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
        }
        if ((object_billID = this.param.get("billId")) != null) {
            this.billID = object_billID.toString();
        }
        Object object_oprtNumber = this.param.get("oprtNumber");
        this.executeOprt = "audit";
        if (object_oprtNumber != null) {
            this.executeOprt = object_oprtNumber.toString();
        }
        if ((object_reverseOprtNumber = this.param.get("reverseOprtNumber")) != null) {
            this.reverseOprt = object_reverseOprtNumber.toString();
        }
        if ((object_assignID = this.param.get("workflowNode")) != null) {
            this.assignID = object_assignID.toString();
        }
        if ((object_procinstID = this.param.get("workflowInst")) != null) {
            this.procinstID = object_procinstID.toString();
        }
        if ((object_billimage = this.param.get("billimage")) != null && (imageImap = (Map)object_billimage) != null) {
            DynamicObject billImageMap = this.orm.queryOne("task_billimagemap", new QFilter[]{new QFilter("imagenumber", "=", imageImap.get("imageNumber"))});
            if (billImageMap != null) {
                billImageMap.set("billtype", (Object)this.billType.getString("bindbill.number"));
                billImageMap.set("billid", (Object)this.billID);
                billImageMap.set("billnumber", (Object)this.getBillNumber(this.billData));
                billImageMap.set("imageurl", imageImap.get("imageUrl"));
                this.orm.update(billImageMap);
            } else {
                billImageMap = this.orm.newDynamicObject("task_billimagemap");
                billImageMap.set("billtype", (Object)this.billType.getString("bindbill.number"));
                billImageMap.set("billid", (Object)this.billID);
                billImageMap.set("billnumber", (Object)this.getBillNumber(this.billData));
                billImageMap.set("imagenumber", imageImap.get("imageNumber"));
                billImageMap.set("imageurl", imageImap.get("imageUrl"));
                Map imageStataObj = (Map)imageImap.get("imageState");
                billImageMap.set("imagestate", imageStataObj.get("value"));
                this.orm.insert(billImageMap);
            }
        }
        if ((object_attachmentIds = this.param.get("attachmentIds")) != null) {
            this.attachmentIds = (List)object_attachmentIds;
        }
        Object object_extparam = this.param.get("extParam");
        if (object_attachmentIds != null) {
            this.extParam = SerializationUtils.toJsonString((Object)object_extparam);
        }
    }

    @Override
    protected DynamicObject getBillType() {
        Object object_billTypeNumber = this.param.get("billType");
        if (object_billTypeNumber != null) {
            String billTypeNumber = object_billTypeNumber.toString();
            this.setBillData(billTypeNumber);
            QFilter bindBIllFil = new QFilter("bindbill.number", "=", (Object)billTypeNumber);
            Map billTypeMap = BusinessDataServiceHelper.loadFromCache((String)"task_taskbill", (QFilter[])new QFilter[]{bindBIllFil});
            if (CollectionUtils.isEmpty((Map)billTypeMap)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230bindbill.number\u4e3a%s\u7684\u5171\u4eab\u4e2d\u5fc3\u4e1a\u52a1\u5355\u636e", (String)"CreateTask4ExternalSystem_2", (String)"ssc-task-common", (Object[])new Object[0]), billTypeNumber));
            }
            for (DynamicObject dynObj : billTypeMap.values()) {
                DynamicObject org;
                if (!this.matchSuitableOrg(dynObj, (org = this.getMainOrg(dynObj)).getLong("id"))) continue;
                return dynObj;
            }
            log.info("\u672a\u627e\u5230\u7ec4\u7ec7\uff08id = " + this.org.getLong("id") + "\uff09\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e");
        }
        return null;
    }

    private boolean matchSuitableOrg(DynamicObject billType, Long orgId) {
        DynamicObjectCollection sscBillOrgParColl = billType.getDynamicObjectCollection("sscbillorgpar");
        for (DynamicObject sscBillOrgPar : sscBillOrgParColl) {
            if (Long.compare(sscBillOrgPar.getLong("fbasedataid_id"), orgId) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected DynamicObject getTaskType() {
        Integer taskTypeNum = this.getTaskTypeNum();
        if (taskTypeNum == null || taskTypeNum <= 0) {
            return null;
        }
        Long taskTypeId = this.getTaskTypeId(taskTypeNum);
        if (taskTypeId == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)taskTypeId)};
        return this.orm.queryOne("task_tasktype", qFilters);
    }

    private Long getTaskTypeId(Integer taskTypeNum) {
        DynamicObjectCollection billEntry = this.billType.getDynamicObjectCollection("entryentity");
        if (billEntry == null || billEntry.size() < taskTypeNum) {
            return null;
        }
        DynamicObject taskTypeDynamicObj = ((DynamicObject)billEntry.get(taskTypeNum - 1)).getDynamicObject("tasktype");
        if (taskTypeDynamicObj == null) {
            return null;
        }
        return taskTypeDynamicObj.getLong("id");
    }

    private Integer getTaskTypeNum() {
        Object taskTypeObj = this.param.get("taskType");
        Integer taskTypeNum = null;
        try {
            taskTypeNum = Integer.parseInt(String.valueOf(taskTypeObj));
        }
        catch (Exception e) {
            log.error(String.format("getTaskTypeNum error, msg:{%s}, taskTypeObj:{%s}", e.getMessage(), taskTypeObj));
        }
        return taskTypeNum;
    }

    @Override
    protected DynamicObject getMainOrg(DynamicObject billType) {
        Object object_orgId = this.param.get("orgId");
        if (object_orgId != null) {
            String orgId = object_orgId.toString();
            try {
                Map innerOrgMap = SysIntegrationServiceHelper.getInternalData((Long)1L, (String)"bos_org", (String)orgId, null, null);
                if (innerOrgMap != null && innerOrgMap.size() > 0) {
                    DynamicObject org = this.orm.newDynamicObject("bos_org");
                    org.set("id", innerOrgMap.get("id"));
                    org.set("number", innerOrgMap.get("number"));
                    org.set("name", innerOrgMap.get("name"));
                    return org;
                }
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
        }
        return super.getMainOrg(billType);
    }

    @Override
    public DynamicObject getBaseData(ORM orm, String entityKey, Map<String, Object> orginValue) {
        return null;
    }

    public DynamicObject json2DynamicObject(String entityType, Map billDataMap) {
        DynamicObject billDataDO = ORM.create().newDynamicObject(entityType);
        this.jsonMap2DynamicObject(billDataMap, billDataDO);
        return billDataDO;
    }

    private void jsonMap2DynamicObject(Map billDataMap, DynamicObject billDataDO) {
        DynamicObjectType billObjectType = billDataDO.getDynamicObjectType();
        DataEntityPropertyCollection proColl = billObjectType.getProperties();
        String pkName = billObjectType.getPrimaryKey().getName();
        ORM orm = ORM.create();
        for (IDataEntityProperty prop : proColl) {
            Object orginValueObject = billDataMap.get(prop.getName());
            if (pkName.equalsIgnoreCase(prop.getName())) {
                billDataDO.set(prop, (Object)1);
                continue;
            }
            if (prop instanceof DynamicSimpleProperty) {
                String orginValue = null;
                if (orginValueObject != null) {
                    orginValue = orginValueObject.toString();
                }
                Object value = null;
                if (!StringUtils.isNotEmpty((CharSequence)orginValue)) continue;
                Class type = prop.getPropertyType();
                value = type == String.class ? orginValue : (type == Integer.TYPE ? Integer.valueOf(orginValue) : (type == Float.TYPE ? Float.valueOf(orginValue) : (type == Long.TYPE ? Long.valueOf(orginValue) : (type == Boolean.TYPE ? (((Boolean)(value = Boolean.valueOf(orginValue))).booleanValue() ? Character.valueOf('1') : Character.valueOf('0')) : (type == Date.class ? new Date(Long.parseLong(orginValue)) : (type == ILocaleString.class ? orginValue : orginValueObject))))));
                if (value == null) continue;
                billDataDO.set(prop, value);
                continue;
            }
            if (prop instanceof DynamicComplexProperty) {
                DynamicObject baseData;
                DynamicComplexProperty cprop = (DynamicComplexProperty)prop;
                IDataEntityType det = cprop.getComplexType();
                if (orginValueObject instanceof String) {
                    String orginValueString = orginValueObject.toString();
                    baseData = CreateTask4ExternalSystem.getBaseData(orm, det.getName(), orginValueString);
                    if (baseData == null) continue;
                    prop.setValueFast((Object)billDataDO, (Object)baseData);
                    continue;
                }
                if (!(orginValueObject instanceof Map)) continue;
                Map orginValueMap = (Map)orginValueObject;
                baseData = this.getBaseData(orm, det.getName(), orginValueMap);
                if (baseData == null) continue;
                prop.setValueFast((Object)billDataDO, (Object)baseData);
                continue;
            }
            if (!(prop instanceof DynamicCollectionProperty)) continue;
            DynamicCollectionProperty entryProp = (DynamicCollectionProperty)prop;
            DynamicObjectType entryObjectType = (DynamicObjectType)entryProp.getItemType();
            if (orginValueObject == null) continue;
            List entryList = (List)orginValueObject;
            DynamicObjectCollection entryColl = billDataDO.getDynamicObjectCollection(prop);
            for (Map entryMap : entryList) {
                DynamicObject entryDo = orm.newDynamicObject(entryObjectType);
                this.jsonMap2DynamicObject(entryMap, entryDo);
                entryColl.add((Object)entryDo);
            }
        }
    }

    private static DynamicObject getBaseData(ORM orm, String detName, String orginValue) {
        QFilter numberFilter = new QFilter("number", "=", (Object)orginValue);
        QFilter nameFilter = new QFilter("name", "=", (Object)orginValue);
        QFilter filter = numberFilter.or(nameFilter);
        DynamicObject baseData = orm.queryOne(detName, new QFilter[]{filter});
        return baseData;
    }

    private void setBillData(String billEntityNum) {
        Object object_billdata = this.param.get("billData");
        if (object_billdata != null) {
            this.billData = this.json2DynamicObject(billEntityNum, (HashMap)object_billdata);
        }
    }

    @Override
    protected void afterCreateTask() {
        Long taskID = this.task.getLong("id");
        this.saveExtParam(taskID);
        this.syncAttachment(taskID);
        super.afterCreateTask();
    }
}

