/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.Source;
import kd.ssc.task.create.AbstractCreateTask;
import kd.ssc.task.face.ICreateTask4Rule;

public class CreateTaskByMService
extends AbstractCreateTask
implements ICreateTask4Rule {
    private static final Log log = LogFactory.getLog(CreateTaskByMService.class);
    private long taskTypeID;
    private long billTypeID;

    @Override
    protected DynamicObject getBillType() {
        return BusinessDataServiceHelper.loadSingle((Object)this.billTypeID, (String)"task_taskbill");
    }

    @Override
    protected DynamicObject getTaskType() {
        return BusinessDataServiceHelper.loadSingle((Object)this.taskTypeID, (String)"task_tasktype");
    }

    @Override
    public long createTask(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID) {
        this.taskTypeID = taskTypeID;
        this.billTypeID = billTypeID;
        this.billID = billID;
        this.executeOprt = executeOprtNumber;
        this.reverseOprt = reverseOprtNumber;
        this.isFromExternalSystem = false;
        boolean result = this.taskCreateMethodValidate(billTypeID, taskTypeID);
        if (result) {
            return super.createTask();
        }
        ErrorCode code = new ErrorCode("fi.ssc.taskCreateMethod", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4efb\u52a1\u521b\u5efa\u65b9\u5f0f\u914d\u7f6e\u6709\u8bef\u3002", (String)"CreateTaskByWorkflow_5", (String)"ssc-task-common", (Object[])new Object[0]));
        throw new KDException(code, new Object[]{ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (String)"CreateTaskByMService_0", (String)"ssc-task-common", (Object[])new Object[0])});
    }

    public long createTask(long taskTypeId, long billTypeId, String billId, Map<String, Object> extParams) {
        long taskID;
        this.assignID = (String)extParams.get("wfTaskId");
        this.sourceType = (String)extParams.get("sourceType");
        try {
            taskID = this.createTask(taskTypeId, billTypeId, billId, 0L, "", "", 0L);
        }
        catch (Exception e) {
            log.error(CreateTaskByMService.class + ".createTask() error, billID: " + billId, (Throwable)e);
            throw e;
        }
        return taskID;
    }

    private boolean taskCreateMethodValidate(long billTypeId, long taskTypeId) {
        QFilter idFil = new QFilter("id", "=", (Object)billTypeId);
        QFilter taskTypeFil = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId);
        DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"entryentity.childpkid childpkid", (QFilter[])new QFilter[]{idFil, taskTypeFil});
        if (taskBill == null) {
            String info = String.format("taskCreateMethodValidate().taskBill == null: billTypeId = %s, taskTypeId = %s", billTypeId, taskTypeId);
            log.error(info);
            return false;
        }
        QFilter idFil_2 = new QFilter("id", "=", (Object)taskBill.getLong("childpkid"));
        QFilter originalFil = new QFilter("taskoriginal", "=", (Object)"3");
        return QueryServiceHelper.exists((String)"task_taskbill_child", (QFilter[])new QFilter[]{idFil_2, originalFil});
    }

    @Override
    protected void afterPrepareTaskData() {
        this.source = Source.MService.getValue();
        this.extenderp = CreateTaskByMService.setExtendErp(this.billTypeID);
        this.billData = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(this.billID), (String)this.billType.getString("bindbill.number"));
        super.doSetApplier();
    }

    public static DynamicObject setExtendErp(long billTypeId) {
        DynamicObject extenderpTemp = null;
        DynamicObject taskBill = BusinessDataServiceHelper.loadSingle((Object)billTypeId, (String)"task_taskbill");
        if (taskBill != null) {
            extenderpTemp = taskBill.getDynamicObject("externalerp");
        }
        if (extenderpTemp == null) {
            extenderpTemp = BusinessDataServiceHelper.loadSingle((String)"bas_extenderp", (String)"id,number,name,producer,fversion,impleclass,fdescription,cfgfolder", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KDCC")});
        }
        if (extenderpTemp == null) {
            ErrorCode errorCode = new ErrorCode("fi.ssc.externalErpEmpty", ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u7a7a", (String)"CreateTaskByWorkflow_2", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (String)"CreateTaskByMService_0", (String)"ssc-task-common", (Object[])new Object[0])});
        }
        return extenderpTemp;
    }
}

