/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.ssc.enums.TaskSourceTypeEnum;
import kd.ssc.task.create.CreateTaskByMService;

public class CreateTaskWrapper {
    private static final Log LOG = LogFactory.getLog(CreateTaskWrapper.class);
    private static final String EXCEPTION_ERROR_CODE = "workFlowCreateSSCTaskException";
    private static final String SSCNODE_WFKEY = "SSCApprove";
    private static final String QUERY_TASKTYPE_SQL = "select ftasktypeid,ftaskoriginal from t_tk_taskbillchild where fid in(select fchildpkid from t_tk_taskrulebill where fid = ?) and ftaskoriginal<'9'";

    public Map<String, Object> createTask4HRActivity(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        Long taskId = 0L;
        String entityNumber = (String)paramMap.get("entityNumber");
        Long billId = (Long)paramMap.get("billId");
        Long processDefinitionId = (Long)paramMap.get("wfDefinitionId");
        int taskLevel = (Integer)paramMap.get("taskLevel");
        HashMap<String, Object> extParams = new HashMap<String, Object>(8);
        extParams.put("wfTaskId", paramMap.get("wfTaskId"));
        String sourceType = paramMap.get("sourceType") == null ? "1" : paramMap.get("sourceType");
        extParams.put("sourceType", sourceType);
        DynamicObject billType = this.matchTaskBillType(entityNumber, billId, processDefinitionId);
        if (billType != null) {
            long billTypeId = billType.getLong("id");
            String createTaskModel = billType.getString("createtaskmodel");
            Map<String, Object> objectMap = this.getTaskTypeIds(billTypeId);
            HashSet taskTypeIds = (HashSet)objectMap.get("taskTypeIds");
            if (taskTypeIds.size() < 1) {
                ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636e\u672a\u914d\u7f6e\u5355\u636e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eid\u4e3a\uff1a%1$s, \u5355\u636e\u5b9e\u4f53\u4e3a\uff1a%2$s\uff0c\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%3$s\u3002", (String)"CreateTaskTestListener_10", (String)"ssc-task-common", (Object[])new Object[0]), billId, entityNumber, billTypeId));
                throw new KDException(errorCode, new Object[0]);
            }
            if ("1".equals(createTaskModel)) {
                HashSet<Long> matchedTaskTypes = this.matchTaskTypeByTaskLevel(taskTypeIds, taskLevel);
                if (matchedTaskTypes.size() < 1) {
                    ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, String.format(ResManager.loadKDString((String)"\u672a\u5728\u4e1a\u52a1\u5355\u636e\u4e2d\u627e\u5230\u8be5\u5171\u4eab\u8282\u70b9\u914d\u7f6e\u7684\u4efb\u52a1\u7ea7\u6b21\u7684\u5355\u636e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%1$s\uff0c\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u7684\u4efb\u52a1\u7ea7\u6b21\u4e3a\uff1a%2$s\u3002", (String)"CreateTaskTestListener_13", (String)"ssc-task-common", (Object[])new Object[0]), billTypeId, taskLevel));
                    throw new KDException(errorCode, new Object[0]);
                }
                taskId = this.createTaskByMService(billId, billTypeId, matchedTaskTypes, extParams);
            }
        } else {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6d41\u7a0b\u91c7\u7528\u4e86\u5355\u5171\u4eab\u8282\u70b9\u6a21\u5f0f\uff0c\u4f46\u4e0d\u5b58\u5728\u751f\u6548\u6216\u5728\u9014\u7684\u5171\u4eab\u521b\u5efa\u4efb\u52a1\u6a21\u5f0f\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_9", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        resultMap.put("taskId", taskId);
        return resultMap;
    }

    public Map<String, Object> createTask4HRNotActivity(Map<String, Object> paramMap) {
        paramMap.put("sourceType", TaskSourceTypeEnum.HR_NOT_ACTIVITY.getValue());
        return this.createTask4HRActivity(paramMap);
    }

    private long createTaskByMService(Long billId, Long billTypeId, HashSet<Long> taskTypeIds, Map<String, Object> extParams) {
        Long taskId = 0L;
        ArrayList<Long> createFailTaskTypeIds = new ArrayList<Long>();
        for (Long taskTypeId : taskTypeIds) {
            taskId = new CreateTaskByMService().createTask(taskTypeId, billTypeId, Long.toString(billId), extParams);
            if (taskId != 0L) continue;
            createFailTaskTypeIds.add(taskTypeId);
        }
        if (createFailTaskTypeIds.size() > 0) {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5171\u4eabssc\u5fae\u670d\u52a1\u65b9\u6cd5createParTaskByWf\u521b\u5efa\u6765\u6e90\u4e3a\u5de5\u4f5c\u6d41\u7684\u5171\u4eab\u4efb\u52a1\u5931\u8d25\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eId\u4e3a\uff1a%1$s\uff0c\u4f7f\u7528\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%2$s\uff0c\u521b\u5efa\u5931\u8d25\u7684\u4efb\u52a1\u7c7b\u578bid\u96c6\u4e3a\uff1a%3$s\u3002", (String)"CreateTaskTestListener_12", (String)"ssc-task-common", (Object[])new Object[0]), billId, billTypeId, createFailTaskTypeIds));
            throw new KDException(errorCode, new Object[0]);
        }
        return taskId;
    }

    private DynamicObject matchTaskBillType(String entityNumber, Long billId, Long processDefinitionId) {
        DynamicObject billData = BusinessDataServiceHelper.loadHead((Object)billId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        long effectiveBillTypeId = this.getFitTaskBillType(entityNumber, billData, "1");
        DynamicObject billTypeDyo = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"id,createtaskmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)effectiveBillTypeId)});
        if (billTypeDyo == null) {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, String.format(ResManager.loadKDString((String)"\u672a\u5728\u4efb\u4e00\u5171\u4eab\u4e2d\u5fc3\u4e0b\uff0c\u627e\u5230\u751f\u6548\u7684\u4e1a\u52a1\u5355\u636e\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eId\u4e3a\uff1a%1$s, \u5355\u636e\u5b9e\u4f53\u4e3a\uff1a%2$s", (String)"CreateTaskTestListener_5", (String)"ssc-task-common", (Object[])new Object[0]), billId, entityNumber));
            throw new KDException(errorCode, new Object[0]);
        }
        String createTaskModel = billTypeDyo.getString("createtaskmodel");
        if ("0".equals(createTaskModel)) {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u8be5\u5171\u4eab\u8282\u70b9\u914d\u7f6e\u4e86\u4efb\u52a1\u7ea7\u6b21\u53c2\u6570\u4f46\u672a\u5728\u4efb\u4e00\u5171\u4eab\u4e2d\u5fc3\u4e0b\u627e\u5230\u9002\u914d\u7684\u5de5\u4f5c\u6d41\u6a21\u5f0f\u5171\u4eab\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_7", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        return billTypeDyo;
    }

    private long getFitTaskBillType(String entityNumber, DynamicObject billData, String effectiveStatus) {
        Long billTypeId;
        DynamicObjectCollection taskBillTypes = QueryServiceHelper.query((String)"task_taskbill", (String)"id,entryentityfield.sourcefieldnumber sourcefieldnumber", (QFilter[])new QFilter[]{new QFilter("bindbill.number", "=", (Object)entityNumber), new QFilter("entryentityfield.fieldconfiguration", "=", (Object)"10"), new QFilter("effective", "=", (Object)effectiveStatus)});
        if (taskBillTypes.size() < 1) {
            String errorMsg = "2".equals(effectiveStatus) ? String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u5de5\u4f5c\u6d41\u5171\u4eab\u5ba1\u6838\u8282\u70b9\u672a\u914d\u7f6e\u4efb\u52a1\u7ea7\u6b21\uff08tasklevel\uff09\u503c\uff0c\u521b\u5efa\u4efb\u52a1\u65f6\u5339\u914d\u5230\u201c\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u201d\u4e3a\u201c\u5de5\u4f5c\u6d41\u521b\u5efa\u201d\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u9700\u5728\u5de5\u4f5c\u6d41\u5171\u4eab\u5ba1\u6279\u8282\u70b9\u8bbe\u7f6e\u4efb\u52a1\u7ea7\u6b21\u503c\uff0c\u6216\u8005\u8bbe\u7f6e\u4e00\u6761\u201c\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u201d\u4e3a\u201c\u5171\u4eab\u4e2d\u5fc3\u521b\u5efa\u4efb\u52a1\u201d\uff0c\u201c\u6765\u6e90\u5355\u636e\u201d\u4e3a%s\uff0c\u4e14\u751f\u6548\u72b6\u6001\u4e3a\u201c\u5728\u9014\u751f\u6548\u201d\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_15", (String)"ssc-task-common", (Object[])new Object[0]), entityNumber) : String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u4e00\u6761\u6765\u6e90\u5355\u636e\u4e3a%1$s\uff0c\u751f\u6548\u72b6\u6001\u4e3a%2$s\u4e14\u542b\u6709\u7ec4\u7ec7\u6620\u5c04\u5b57\u6bb5\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_14", (String)"ssc-task-common", (Object[])new Object[0]), entityNumber, this.getNameOfComboByValue(effectiveStatus));
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, errorMsg);
            throw new KDException(errorCode, new Object[0]);
        }
        Map<Long, String> orgFiledMap = taskBillTypes.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("sourcefieldnumber"), (v1, v2) -> v1));
        DynamicObjectCollection applyOrgCollection = QueryServiceHelper.query((String)"task_taskbill", (String)"id,sscbillorgpar.fbasedataid sscbillorgpar", (QFilter[])new QFilter[]{new QFilter("id", "in", orgFiledMap.keySet())});
        HashMap<Long, Set> billTypeApplyOrgMap = new HashMap<Long, Set>(16);
        for (DynamicObject applyOrg : applyOrgCollection) {
            billTypeId = applyOrg.getLong("id");
            Long applyOrgId = applyOrg.getLong("sscbillorgpar");
            billTypeApplyOrgMap.computeIfAbsent(billTypeId, k -> new HashSet(16)).add(applyOrgId);
        }
        for (Map.Entry<Long, String> item : orgFiledMap.entrySet()) {
            billTypeId = item.getKey();
            String orgFieldKey = item.getValue();
            long mainOrgId = this.getMainOrgId(billData, orgFieldKey);
            if (mainOrgId != 0L) {
                if (!((Set)billTypeApplyOrgMap.get(billTypeId)).contains(mainOrgId)) continue;
                return billTypeId;
            }
            LOG.info(String.format("\u83b7\u53d6\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u9519\u8bef\uff1a\u4f9d\u636eid\u4e3a%s\u7684\u4e1a\u52a1\u5355\u636e\u914d\u7f6e\u7684\u7ec4\u7ec7\u6620\u5c04\u5b57\u6bb5\u4ece\u5b9e\u4f53%s\u7684\u5355\u636e%s\u83b7\u53d6\u7ec4\u7ec7\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", billTypeId, entityNumber, billData.getPkValue()));
        }
        String errorMsg = "2".equals(effectiveStatus) ? ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6d41\u7a0b\u914d\u7f6e\u4e86\u5355\u5171\u4eab\u5ba1\u6838\u8282\u70b9\uff0c\u4f46\u662f\u672a\u914d\u7f6e\u4efb\u52a1\u7ea7\u6b21\uff0c\u6839\u636e\u4efb\u52a1\u521b\u5efa\u903b\u8f91\u5339\u914d\u5728\u9014\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u627e\u5230\u4e86\u6765\u6e90\u5355\u636e\u4e3a%s\u7684\u4e1a\u52a1\u5355\u636e\u4e3a\u5728\u9014\u751f\u6548\u72b6\u6001\uff0c\u4f46\u662f\u65e0\u5339\u914d\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5728\u9014\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\u4e2d\u7ec4\u7ec7\u5b57\u6bb5\u914d\u7f6e\u5bf9\u5e94\u7684\u503c\uff0c\u662f\u5426\u5305\u542b\u5728\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e2d\u3002", (String)"CreateTaskTestListener_16", (String)"ssc-task-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u627e\u5230\u4e86\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\u6765\u6e90\u5355\u636e\u4e3a%s\uff0c\u4f46\u662f\u65e0\u5339\u914d\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\u4e2d\u7ec4\u7ec7\u5b57\u6bb5\u914d\u7f6e\u5bf9\u5e94\u7684\u503c\uff0c\u662f\u5426\u5305\u542b\u5728\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e2d\u3002", (String)"CreateTaskTestListener_17", (String)"ssc-task-common", (Object[])new Object[0]);
        ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, errorMsg);
        throw new KDException(errorCode, new Object[]{entityNumber});
    }

    private long getMainOrgId(DynamicObject billData, String orgFieldKey) {
        DynamicObject orgRel;
        if (StringUtils.isEmpty((String)orgFieldKey)) {
            return 0L;
        }
        Object orgObj = billData.get(orgFieldKey);
        if (orgObj == null) {
            return 0L;
        }
        if (orgObj instanceof DynamicObject) {
            return ((DynamicObject)orgObj).getLong("id");
        }
        if (orgObj instanceof String && (orgRel = ORM.create().queryOne("bos_org", "id", new QFilter[]{new QFilter("name", "=", (Object)orgObj.toString())})) != null) {
            return orgRel.getLong("id");
        }
        return 0L;
    }

    private int getCountOfSSCNodeInDef(Long processDefinitionId) {
        List elements = WorkflowServiceHelper.getProcElementsByProcDefId((Long)processDefinitionId);
        int result = 0;
        for (WFFlowElement element : elements) {
            if (!SSCNODE_WFKEY.equals(element.getType())) continue;
            ++result;
        }
        return result;
    }

    private Map<String, Object> getTaskTypeIds(Long billTypeId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashSet<Long> taskTypeIds = new HashSet<Long>();
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)billTypeId)};
        String algoKey = this.getClass() + ".getTaskTypeByBillTypeId()";
        try (DataSet taskTypeDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_TASKTYPE_SQL, (Object[])params);){
            if (taskTypeDataSet.hasNext()) {
                for (Row row : taskTypeDataSet) {
                    String taskOriginal = row.getString("ftaskoriginal");
                    Long taskTypeId = row.getLong("ftasktypeid");
                    if (taskTypeId.equals(0L)) continue;
                    taskTypeIds.add(taskTypeId);
                }
            }
        }
        result.put("taskTypeIds", taskTypeIds);
        return result;
    }

    private HashSet<Long> matchTaskTypeByTaskLevel(HashSet<Long> allTaskTypes, int taskLevel) {
        HashSet<Long> result = new HashSet<Long>();
        String taskLevelStr = String.valueOf(taskLevel);
        QFilter idFilter = new QFilter("id", "in", allTaskTypes);
        DynamicObjectCollection taskTypes = QueryServiceHelper.query((String)"task_tasktype", (String)"id,tasklevel", (QFilter[])idFilter.toArray());
        for (DynamicObject taskType : taskTypes) {
            if (!taskLevelStr.equals(taskType.getString("tasklevel"))) continue;
            result.add(taskType.getLong("id"));
        }
        return result;
    }

    private String getNameOfComboByValue(String value) {
        ComboProp comboProp = (ComboProp)EntityMetadataCache.getDataEntityType((String)"task_taskbill").getProperty("effective");
        if (comboProp != null) {
            return comboProp.getItemByName(value);
        }
        return value;
    }
}

