/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.createrule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.IOperationTask;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.ErpFactory;

public class CreateTask4RuleBosImpl
implements IOperationTask {
    private String billTypeKey;
    private String operationKey;
    private DynamicObject billType;
    private static final Log log = LogFactory.getLog(CreateTask4RuleBosImpl.class);

    public void execute(OperationContext context, DynamicObject[] colls, OperationResult operationResult) {
        log.error("\u64cd\u4f5c\u521b\u5efa\u5171\u4eab\u4efb\u52a1\uff1a" + context.getEntityTypeId() + "," + context.getOperationKey());
        this.billTypeKey = context.getEntityTypeId();
        if (this.billTypeKey == null || !this.getCachedBillTypeSet().contains(this.billTypeKey)) {
            return;
        }
        this.operationKey = context.getOperationKey();
        if (this.operationKey == null || !this.getCachedOperationSet().contains(this.operationKey)) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        if (successPkIds != null) {
            successPkIds.forEach(result -> {
                String billID = result.toString();
                try {
                    this.createTask(billID);
                }
                catch (Exception e) {
                    log.error("\u521b\u5efa\u5171\u4eab\u5e73\u53f0\u4efb\u52a1\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    public void createTask(Object billID) {
        DynamicObject[] createrules = this.getCreateRules(this.billTypeKey, this.operationKey);
        if (createrules == null) {
            return;
        }
        for (DynamicObject createrule : createrules) {
            DynamicObject taskType = (DynamicObject)createrule.get("tasktype");
            Object executeOprtObject = createrule.get("executeoprtnumber");
            long taskTypeID = Long.parseLong(taskType.get("id").toString());
            long billTypeID = Long.parseLong(this.billType.get("id").toString());
            ErpFactory.getCreateTask4Rule(null).createTask(taskTypeID, billTypeID, billID.toString(), 0L, executeOprtObject.toString(), "", 0L);
        }
    }

    private Set<String> getCachedOperationSet() {
        HashSet<String> operationSet;
        String jsonOperation = SscDistributeCache.get("ssc-task-operation");
        if (!StringUtils.isEmpty((String)jsonOperation)) {
            operationSet = (HashSet<String>)SerializationUtils.fromJsonString((String)jsonOperation, HashSet.class);
        } else {
            DynamicObjectCollection ruleColl = ORM.create().query("task_taskbill_child", "id,taskoprtnumber", new QFilter[0]);
            operationSet = new HashSet<String>();
            for (DynamicObject rule : ruleColl) {
                String taskoprtnumber = rule.getString("taskoprtnumber");
                if (StringUtils.isEmpty((String)taskoprtnumber)) continue;
                operationSet.add(taskoprtnumber);
            }
            operationSet.add("save");
            operationSet.add("submit");
            String jsonString = "";
            if (operationSet != null && operationSet.size() > 0) {
                jsonString = SerializationUtils.toJsonString(operationSet);
            }
            SscDistributeCache.put("ssc-task-operation", jsonString);
        }
        return operationSet;
    }

    private Set<String> getCachedBillTypeSet() {
        HashSet<String> billTypeSet;
        String jsonBillType = SscDistributeCache.get("ssc-task-billtype");
        if (!StringUtils.isEmpty((String)jsonBillType)) {
            billTypeSet = (HashSet<String>)SerializationUtils.fromJsonString((String)jsonBillType, HashSet.class);
        } else {
            DynamicObjectCollection billtypecoll = ORM.create().query("task_taskbill", "id,bindbill.number", new QFilter[0]);
            billTypeSet = new HashSet<String>();
            for (DynamicObject billtype : billtypecoll) {
                String billtypenumber = billtype.getString("bindbill.number");
                billTypeSet.add(billtypenumber);
            }
            String jsonString = "";
            if (billTypeSet != null && billTypeSet.size() > 0) {
                jsonString = SerializationUtils.toJsonString(billTypeSet);
            }
            SscDistributeCache.put("ssc-task-billtype", jsonString);
        }
        return billTypeSet;
    }

    private DynamicObject[] getCreateRules(String bindBillTypeKey, String operationKey) {
        ORM orm = ORM.create();
        this.billType = orm.queryOne("task_taskbill", "id,entryentity.id,entryentity.childpkid", new QFilter[]{new QFilter("bindbill.number", "=", (Object)bindBillTypeKey), new QFilter("effective", "=", (Object)Boolean.TRUE)});
        if (this.billType == null) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u521b\u5efa\u4efb\u52a1\uff1a\u672a\u627e\u5230\u4efb\u4e00\u751f\u6548\u7684\u4e1a\u52a1\u5355\u636e\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e3a\uff1a%s", (String)"CreateTask4RuleBosImpl_0", (String)"ssc-task-common", (Object[])new Object[0]), bindBillTypeKey));
        }
        DynamicObjectCollection entryentity = (DynamicObjectCollection)this.billType.get("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            return null;
        }
        long[] ids = new long[entryentity.size()];
        int i = 0;
        for (DynamicObject entry : entryentity) {
            ids[i++] = Long.parseLong(entry.getString("childpkid"));
        }
        DynamicObject[] createRules = BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)"id,tasktype,ssc,taskoprtnumber,executeoprtnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids), new QFilter("taskoprtnumber", "=", (Object)operationKey)});
        if (createRules != null && createRules.length > 0) {
            return createRules;
        }
        return null;
    }
}

