/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.delete.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.task.delete.service.DeleteTaskService;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.util.TaskCommonUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class DeleteTaskServiceImpl
implements DeleteTaskService {
    private static final Log log = LogFactory.getLog(DeleteTaskServiceImpl.class);

    @Override
    public boolean deleteSingleTask(long taskId, String newStatus, String newComment, long userId, int status) throws Exception {
        boolean deleteTaskSuccess = false;
        ThreadLocal<DynamicObject> task = new ThreadLocal<DynamicObject>();
        try {
            deleteTaskSuccess = this.deleteSingleTaskExceptModifyComment(taskId, task);
        }
        catch (Exception e) {
            ErrorCode code;
            String taskStr = "empty";
            if (task.get() != null) {
                taskStr = this.buildExJson4Task(task.get());
            }
            if (e instanceof KDException && (code = ((KDException)e).getErrorCode()) != null && "delete_task_0".equals(code.getCode())) {
                throw new KDException((Throwable)e, code, new Object[]{taskStr});
            }
            code = new ErrorCode("delete_task_1", e.getMessage());
            throw new KDException((Throwable)e, code, new Object[]{taskStr});
        }
        if (newStatus == null || newStatus.isEmpty() || newComment == null || newComment.isEmpty()) {
            return deleteTaskSuccess;
        }
        if (deleteTaskSuccess && task.get() != null) {
            try {
                TaskWorkFlowUtil.updateWfMsgAfterTaskDelete(task.get(), newStatus, newComment, userId, status);
            }
            catch (Exception e) {
                String taskStr = this.buildExJson4Task(task.get());
                ErrorCode code = new ErrorCode("delete_task_2", e.getMessage());
                throw new KDException((Throwable)e, code, new Object[]{taskStr});
            }
        }
        return true;
    }

    private boolean deleteSingleTaskExceptModifyComment(long taskId, ThreadLocal<DynamicObject> taskCache) throws Exception {
        DynamicObject task = this.getTask(taskId);
        if (task == null) {
            log.info("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0ctaskid\uff1a" + taskId);
            return true;
        }
        taskCache.set(task);
        if (this.sysBill(task)) {
            if (!this.deleteVoucher(task)) {
                return false;
            }
            return this.deleteTaskAndInst(task);
        }
        log.info("\u5f02\u6784\u5355\u636e\uff0c\u4efb\u52a1id\uff1a" + taskId);
        QFilter taskDeleteFilter = new QFilter("id", "=", (Object)task.getLong("id"));
        int success = DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskDeleteFilter});
        return success == 1;
    }

    public boolean deleteTaskAndInst(DynamicObject task) {
        Long billID;
        QFilter taskDeleteFilter = new QFilter("id", "=", (Object)task.getLong("id"));
        Long billType = task.getLong("billtype");
        QFilter[] qFilters = new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "=", (Object)(billID = Long.valueOf(task.getLong("billid")))), new QFilter("ptstatus", "=", (Object)FlowInstEnum.PROCESSING.getValue()), new QFilter("workflowid", "!=", (Object)0L)};
        DynamicObject[] insts = BusinessDataServiceHelper.load((String)"task_partaskinst", (String)"id, ptstatus", (QFilter[])qFilters);
        if (insts == null || insts.length == 0) {
            DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskDeleteFilter});
            return true;
        }
        HashSet<Long> instIdSet = new HashSet<Long>(insts.length);
        for (DynamicObject inst : insts) {
            instIdSet.add((Long)inst.getPkValue());
            inst.set("ptstatus", (Object)FlowInstEnum.FAILED.getValue());
        }
        QFilter[] nodeFilter = new QFilter[]{new QFilter("instantid", "in", instIdSet)};
        TXHandle nodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"taskid,state", (QFilter[])nodeFilter);
        if (nodes == null || ((DynamicObject[])nodes).length == 0) {
            try (TXHandle h = TX.required((String)(this.getClass().getName() + "deleteTask"));){
                try {
                    SaveServiceHelper.save((DynamicObject[])insts);
                    DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskDeleteFilter});
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            return true;
        }
        for (DynamicObject node : nodes) {
            if (node.getInt("state") != InstNodeEnum.PROCESSING.getValue()) continue;
            node.set("state", (Object)InstNodeEnum.FAILED.getValue());
        }
        try (TXHandle h = TX.required((String)(this.getClass().getName() + "deleteTaskWithInstNode"));){
            try {
                SaveServiceHelper.save((DynamicObject[])insts);
                SaveServiceHelper.save((DynamicObject[])nodes);
                DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskDeleteFilter});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return true;
    }

    private boolean deleteVoucherWithoutException(DynamicObject task) {
        boolean result = false;
        try {
            result = this.deleteVoucher(task);
        }
        catch (Exception e) {
            log.error("\u51ed\u8bc1\u5220\u9664\u5931\u8d25\uff1a", (Throwable)e);
        }
        return result;
    }

    private boolean deleteVoucher(DynamicObject task) throws Exception {
        long billId = task.getLong("billid");
        QFilter[] idFilters = new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId)};
        DynamicObjectCollection voucherDyns = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid", (QFilter[])idFilters);
        if (voucherDyns == null || voucherDyns.isEmpty()) {
            return true;
        }
        List voucherIds = voucherDyns.stream().map(d -> d.getLong("voucherid")).collect(Collectors.toList());
        QFilter[] existFilters = new QFilter[]{new QFilter("id", "in", voucherIds), new QFilter("billstatus", "=", (Object)"C")};
        boolean existAudit = QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])existFilters);
        if (existAudit) {
            ErrorCode code = new ErrorCode("delete_task_0", ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6838\u51ed\u8bc1", (String)"DeleteTaskServiceImpl_0", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        String billEntity = TaskCommonUtil.getBillEntityNumberByTask(task.getLong("id"));
        OperateOption option = OperateOption.create();
        Map voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billEntity, (String)"deletevoucher");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)((String)voucherOperate.get("key")), (String)billEntity, (Object[])new Object[]{billId}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            List allErrorInfo = operationResult.getAllErrorInfo();
            StringBuilder allErrorMsgStr = new StringBuilder();
            allErrorInfo.forEach(error -> allErrorMsgStr.append(error.getMessage()));
            String exceptionString = String.format(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"DeleteTaskServiceImpl_1", (String)"ssc-task-common", (Object[])new Object[0]), billId, allErrorMsgStr.toString());
            throw new KDException(new ErrorCode("delete_task_0", exceptionString), new Object[0]);
        }
        return true;
    }

    private boolean sysBill(DynamicObject task) {
        String billIdStr = task.getString("billid");
        if (billIdStr == null || billIdStr.isEmpty() || billIdStr.equals("0")) {
            return false;
        }
        return billIdStr.matches("[0-9]+");
    }

    private DynamicObject getTask(long taskId) {
        if (taskId == 0L) {
            return null;
        }
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        String selectField = "id,sscid,tasktypeid,billtype,billnumber,billid,assignid,pooltype";
        return QueryServiceHelper.queryOne((String)"task_task", (String)selectField, (QFilter[])new QFilter[]{taskFilter});
    }

    private String buildExJson4Task(DynamicObject task) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("id", task.getLong("id"));
        map.put("sscid", task.getLong("sscid"));
        map.put("tasktypeid", task.getLong("tasktypeid"));
        map.put("billtype", task.getLong("billtype"));
        map.put("billnumber", task.getString("billnumber"));
        map.put("billid", Long.valueOf(task.getString("billid")));
        map.put("assignid", Long.valueOf(task.getString("assignid")));
        return SerializationUtils.toJsonString(map);
    }

    @Override
    public boolean deleteTaskWithoutUpdateWf(long taskId) {
        DynamicObject task = this.getTask(taskId);
        if (task == null) {
            return true;
        }
        if (this.sysBill(task)) {
            boolean forceDelete;
            if (!this.deleteVoucherWithoutException(task) && !(forceDelete = this.isForceDelete())) {
                return false;
            }
            return this.deleteTaskAndInst(task);
        }
        log.info("\u5f02\u6784\u5355\u636e\uff0c\u4efb\u52a1id\uff1a" + taskId);
        QFilter taskDeleteFilter = new QFilter("id", "=", (Object)task.getLong("id"));
        int success = DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskDeleteFilter});
        return success == 1;
    }

    private boolean isForceDelete() {
        String forceDelete = TaskParamHelper.getTaskParamByName("forceDeleteTask");
        return "true".equals(forceDelete);
    }
}

