/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.https;

import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpsClientUtil {
    private static final Log logger = LogFactory.getLog(HttpsClientUtil.class);
    private static final int MAX_TOTAL = 20;
    private static final int MAX_PER_ROUTE = 5;
    private static CloseableHttpClient httpClient;

    public static final String executePost(String url, String json, Map<String, String> headerMap) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        return HttpsClientUtil.execute(json, headerMap, (HttpEntityEnclosingRequestBase)httpPost);
    }

    public static final String executeGet(String url, Map<String, String> headerMap) throws Exception {
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            HttpGet httpGet = new HttpGet(URI.create(url));
            if (headerMap != null && headerMap.size() != 0) {
                for (Map.Entry<String, String> map : headerMap.entrySet()) {
                    httpGet.setHeader(map.getKey(), map.getValue());
                }
            }
            if ((entity = (response = httpClient.execute((HttpUriRequest)httpGet)).getEntity()) != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001HTTP GET\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519:" + e.getMessage());
                }
            }
        }
        return responseContent;
    }

    public static final String executePut(String url, String json, Map<String, String> headerMap) throws Exception {
        HttpPut httpPut = new HttpPut(url);
        return HttpsClientUtil.execute(json, headerMap, (HttpEntityEnclosingRequestBase)httpPut);
    }

    private static String execute(String json, Map<String, String> headerMap, HttpEntityEnclosingRequestBase http) throws IOException {
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            if (!CollectionUtils.isEmpty(headerMap)) {
                for (Map.Entry<String, String> map : headerMap.entrySet()) {
                    http.setHeader(map.getKey(), map.getValue());
                }
            }
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            http.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)http);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001HTTP\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519:" + e.getMessage());
                }
            }
        }
        return responseContent;
    }

    static {
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return s.equalsIgnoreCase(sslSession.getPeerHost());
            }
        });
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        poolingHttpClientConnectionManager.setMaxTotal(20);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(5);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).build();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(requestConfig).build();
    }
}

