/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.image;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class TaskUploadImage {
    private static final Log log = LogFactory.getLog(TaskUploadImage.class);

    public void updateTaskInfo(Map<String, ImageInfo> billImageMap) throws Exception {
        QFilter notQuaCheckFil;
        if (billImageMap == null || billImageMap.size() == 0) {
            log.info(".updateTaskInfo().billImageMap is null or billImageMap.size() = 0");
            return;
        }
        QFilter billIdFil = new QFilter("billid", "in", billImageMap.keySet());
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"sscid,oldtaskstate,state,imageuploadtime,pooltype,tasktypeid,billtype,personid,createtime,billid,imageok,source,assignid", (QFilter[])new QFilter[]{billIdFil, notQuaCheckFil = new QFilter("qualitysamplelibrary", "=", (Object)0)});
        if (tasks == null || tasks.length == 0) {
            log.info(".updateTaskInfo().task is null or task.size() = 0");
            return;
        }
        Date now = new Date();
        HashMap<String, String> oldPoolTypeMap = new HashMap<String, String>();
        for (DynamicObject task : tasks) {
            task.set("imageok", (Object)"1");
            if (TaskStateEnum.RESCAN.getValue().equals(task.getString("state"))) {
                this.addJobStateTime(task, "16", TaskStateEnum.REUPLOAD_IMAGE.getValue(), "0", "", null);
                task.set("oldtaskstate", (Object)task.getString("state"));
                task.set("state", (Object)TaskStateEnum.REUPLOAD_IMAGE.getValue());
                task.set("imageuploadtime", (Object)now);
                continue;
            }
            if (!TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(task.getString("pooltype"))) continue;
            oldPoolTypeMap.put(task.getString("id"), task.getString("pooltype"));
            task.set("imageuploadtime", (Object)now);
            task.set("oldtaskstate", (Object)task.getString("state"));
            task.set("state", (Object)TaskStateEnum.TO_BE_DIS.getValue());
            task.set("pooltype", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
        for (DynamicObject task : tasks) {
            try {
                String oldPoolType;
                String billId = task.getString("billid");
                String scanUserID = billImageMap.get(billId).getScanuserId();
                String extendErp = this.getExternalerp(billId);
                if (!extendErp.equalsIgnoreCase("KDCC")) continue;
                long userId = TaskUploadImage.getDataMapping(scanUserID);
                if (userId == -1L) {
                    if (scanUserID != null) {
                        try {
                            userId = Long.parseLong(scanUserID);
                        }
                        catch (Exception e) {
                            userId = RequestContext.get().getCurrUserId();
                        }
                    } else {
                        userId = 0L;
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)(oldPoolType = (String)oldPoolTypeMap.get(task.getString("id")))) || !TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(oldPoolType)) continue;
                TaskWorkFlowUtil.addWorkFlowComment(new DynamicObject[]{task}, "", ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf\u6210\u529f", (String)"TaskUploadImage_0", (String)"ssc-task-common", (Object[])new Object[0]), userId);
                TaskWorkFlowUtil.updateWfMsg(task, true);
                TaskWorkFlowUtil.updatePersonAndMsgWithCheck(new DynamicObject[]{task}, ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskUploadImage_1", (String)"ssc-task-common", (Object[])new Object[0]), false);
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u5f71\u50cf\u901a\u77e5\u5de5\u4f5c\u6d41\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void addJobStateTime(DynamicObject jobObj, String operation, String newJobState, String messageState, String message, String innerMsg) throws KDException {
        ORM orm = ORM.create();
        DynamicObject stateChangeObj = orm.newDynamicObject("task_statechange");
        stateChangeObj.set("jobid", (Object)jobObj.getString("id"));
        stateChangeObj.set("oldjobstate", (Object)jobObj.getString("state"));
        stateChangeObj.set("newjobstate", (Object)newJobState);
        stateChangeObj.set("message", (Object)message);
        stateChangeObj.set("messagestate", (Object)messageState);
        stateChangeObj.set("operatorid", (Object)jobObj.getLong("personid.id"));
        stateChangeObj.set("operation", (Object)operation);
        stateChangeObj.set("tasktype", (Object)jobObj.getLong("tasktypeid.id"));
        stateChangeObj.set("billtype", (Object)jobObj.getLong("billtype.id"));
        stateChangeObj.set("changetime", (Object)new Date());
        stateChangeObj.set("innermsg", (Object)innerMsg);
        orm.insert(stateChangeObj);
    }

    private String getExternalerp(Object billid) {
        QFilter idFilter = new QFilter("billid", "=", billid);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject taskObject = QueryServiceHelper.queryOne((String)"task_task", (String)"billtype", (QFilter[])filters);
        if (taskObject == null) {
            return "";
        }
        idFilter = new QFilter("id", "=", (Object)taskObject.getLong("billtype"));
        filters = new QFilter[]{idFilter};
        DynamicObject taskbillObject = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"externalerp.number", (QFilter[])filters);
        return taskbillObject.getString("externalerp.number");
    }

    public static long getDataMapping(String scanUserID) {
        QFilter idFilter = new QFilter("extdataid", "=", (Object)scanUserID);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject datamapping = QueryServiceHelper.queryOne((String)"bas_datamapping", (String)"dataid", (QFilter[])filters);
        if (datamapping == null) {
            return -1L;
        }
        return datamapping.getLong("dataid");
    }
}

